/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.fogofwar;

import com.solegendary.reignofnether.fogofwar.FogOfWarClientEvents;
import com.solegendary.reignofnether.registrars.PacketHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class FogOfWarClientboundPacket {
    public boolean enable;
    public String playerName;
    public int unitId;

    public static void setEnabled(boolean enable) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new FogOfWarClientboundPacket(enable, "", 0));
    }

    public static void revealOrHidePlayer(boolean reveal, String playerName) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new FogOfWarClientboundPacket(reveal, playerName, 0));
    }

    public static void revealRangedUnit(String playerBeingAttacked, int unitId) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new FogOfWarClientboundPacket(true, playerBeingAttacked, unitId));
    }

    public FogOfWarClientboundPacket(boolean enable, String playerName, int unitId) {
        this.enable = enable;
        this.playerName = playerName;
        this.unitId = unitId;
    }

    public FogOfWarClientboundPacket(FriendlyByteBuf buffer) {
        this.enable = buffer.readBoolean();
        this.playerName = buffer.m_130277_();
        this.unitId = buffer.readInt();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.enable);
        buffer.m_130070_(this.playerName);
        buffer.writeInt(this.unitId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (this.unitId > 0) {
                FogOfWarClientEvents.revealRangedUnit(this.playerName, this.unitId);
            } else if (this.playerName.isEmpty()) {
                FogOfWarClientEvents.setEnabled(this.enable);
            } else {
                FogOfWarClientEvents.revealOrHidePlayer(this.enable, this.playerName);
            }
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

