/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.gamerules;

import com.solegendary.reignofnether.gamemode.ClientGameModeHelper;
import com.solegendary.reignofnether.gamemode.GameMode;
import com.solegendary.reignofnether.gamerules.GameruleAction;
import com.solegendary.reignofnether.gamerules.GameruleClient;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.registrars.PacketHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class GameruleClientboundPacket {
    GameruleAction action;
    String playerName;
    Long value;

    public static void setLogFalling(boolean logFalling) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new GameruleClientboundPacket(GameruleAction.SET_LOG_FALLING, "", logFalling ? 1L : 0L));
    }

    public static void setNeutralAggro(boolean neutralAggro) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new GameruleClientboundPacket(GameruleAction.SET_NEUTRAL_AGGRO, "", neutralAggro ? 1L : 0L));
    }

    public static void setMaxPopulation(long maxPopulation) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new GameruleClientboundPacket(GameruleAction.SET_MAX_POPULATION, "", maxPopulation));
    }

    public static void setUnitGriefing(boolean unitGriefing) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new GameruleClientboundPacket(GameruleAction.SET_UNIT_GRIEFING, "", unitGriefing ? 1L : 0L));
    }

    public static void setPlayerGriefing(boolean playerGriefing) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new GameruleClientboundPacket(GameruleAction.SET_PLAYER_GRIEFING, "", playerGriefing ? 1L : 0L));
    }

    public static void setImprovedPathfinding(boolean improvedPathfinding) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new GameruleClientboundPacket(GameruleAction.SET_IMPROVED_PATHFINDING, "", improvedPathfinding ? 1L : 0L));
    }

    public static void setGroundYLevel(long groundYLevel) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new GameruleClientboundPacket(GameruleAction.SET_GROUND_Y_LEVEL, "", groundYLevel));
    }

    public static void setFlyingMaxYLevel(long flyingMaxYLevel) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new GameruleClientboundPacket(GameruleAction.SET_FLYING_MAX_Y_LEVEL, "", flyingMaxYLevel));
    }

    public static void setAllowBeacons(boolean allowBeacons) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new GameruleClientboundPacket(GameruleAction.SET_ALLOW_BEACONS, "", allowBeacons ? 1L : 0L));
    }

    public static void setPvpModesOnly(boolean pvpModesOnly) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new GameruleClientboundPacket(GameruleAction.SET_PVP_MODES_ONLY, "", pvpModesOnly ? 1L : 0L));
    }

    public static void setBeaconWinMinutes(long beaconWinMinutes) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new GameruleClientboundPacket(GameruleAction.SET_BEACON_WIN_MINUTES, "", beaconWinMinutes));
    }

    public static void setSlantedBuilding(boolean slantedBuilding) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new GameruleClientboundPacket(GameruleAction.SET_SLANTED_BUILDING, "", slantedBuilding ? 1L : 0L));
    }

    public GameruleClientboundPacket(GameruleAction action, String playerName, Long value) {
        this.action = action;
        this.playerName = playerName;
        this.value = value;
    }

    public GameruleClientboundPacket(FriendlyByteBuf buffer) {
        this.action = (GameruleAction)buffer.m_130066_(GameruleAction.class);
        this.playerName = buffer.m_130277_();
        this.value = buffer.readLong();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.action);
        buffer.m_130070_(this.playerName);
        buffer.writeLong(this.value.longValue());
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            switch (this.action) {
                case SET_LOG_FALLING: {
                    GameruleClient.doLogFalling = this.value == 1L;
                    break;
                }
                case SET_NEUTRAL_AGGRO: {
                    GameruleClient.neutralAggro = this.value == 1L;
                    break;
                }
                case SET_MAX_POPULATION: {
                    GameruleClient.maxPopulation = Math.toIntExact(this.value);
                    break;
                }
                case SET_UNIT_GRIEFING: {
                    GameruleClient.doUnitGriefing = this.value == 1L;
                    break;
                }
                case SET_PLAYER_GRIEFING: {
                    GameruleClient.doPlayerGriefing = this.value == 1L;
                    break;
                }
                case SET_IMPROVED_PATHFINDING: {
                    GameruleClient.improvedPathfinding = this.value == 1L;
                    break;
                }
                case SET_GROUND_Y_LEVEL: {
                    GameruleClient.groundYLevel = this.value.longValue();
                    OrthoviewClientEvents.setMinOrthoviewY(this.value + 30L);
                    break;
                }
                case SET_FLYING_MAX_Y_LEVEL: {
                    GameruleClient.flyingMaxYLevel = this.value.longValue();
                    break;
                }
                case SET_ALLOW_BEACONS: {
                    GameruleClient.allowBeacons = this.value == 1L;
                    break;
                }
                case SET_PVP_MODES_ONLY: {
                    boolean bl = GameruleClient.pvpModesOnly = this.value == 1L;
                    if (!GameruleClient.pvpModesOnly) break;
                    ClientGameModeHelper.gameMode = GameMode.CLASSIC;
                    break;
                }
                case SET_BEACON_WIN_MINUTES: {
                    GameruleClient.beaconWinMinutes = this.value.longValue();
                    break;
                }
                case SET_SLANTED_BUILDING: {
                    GameruleClient.slantedBuilding = this.value == 1L;
                }
            }
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

