/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hud;

import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.LanguageUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ControlGroup {
    private static final long DOUBLE_CLICK_TIME_MS = 500L;
    public long lastClickTime = 0L;
    public final ArrayList<Integer> entityIds = new ArrayList();
    private final ArrayList<BlockPos> buildingBps = new ArrayList();
    private Keybinding keybinding = null;
    private ResourceLocation iconRl = null;

    public int getKey() {
        return this.keybinding != null ? this.keybinding.key : -1;
    }

    public void clearAll() {
        this.entityIds.clear();
        this.buildingBps.clear();
    }

    public boolean isEmpty() {
        return this.entityIds.size() == 0 && this.buildingBps.size() == 0;
    }

    public void clean() {
        this.entityIds.removeIf(e -> !UnitClientEvents.getAllUnits().stream().map(Entity::m_19879_).toList().contains(e));
        this.buildingBps.removeIf(b -> !BuildingClientEvents.getBuildings().stream().map(b2 -> b2.originPos).toList().contains(b));
    }

    public void saveFromSelected(Keybinding keybinding) {
        int numSaveableUnits = UnitClientEvents.getSelectedUnits().stream().filter(e -> UnitClientEvents.getPlayerToEntityRelationship(e) == Relationship.OWNED).toList().size();
        int numSaveableBuildings = BuildingClientEvents.getSelectedBuildings().stream().filter(b -> BuildingClientEvents.getPlayerToBuildingRelationship(b) == Relationship.OWNED).toList().size();
        if (numSaveableUnits == 0 && numSaveableBuildings == 0) {
            return;
        }
        this.clearAll();
        this.keybinding = keybinding;
        ArrayList<LivingEntity> selUnits = UnitClientEvents.getSelectedUnits();
        ArrayList<BuildingPlacement> selBuildings = BuildingClientEvents.getSelectedBuildings();
        if (selUnits.size() > 0 && UnitClientEvents.getPlayerToEntityRelationship(selUnits.get(0)) == Relationship.OWNED) {
            this.entityIds.addAll(selUnits.stream().map(Entity::m_19879_).toList());
        } else if (selBuildings.size() > 0 && BuildingClientEvents.getPlayerToBuildingRelationship(selBuildings.get(0)) == Relationship.OWNED) {
            this.buildingBps.addAll(selBuildings.stream().map(b -> b.originPos).toList());
        }
        if (HudClientEvents.hudSelectedEntity != null) {
            String unitName = HudClientEvents.getSimpleEntityName((Entity)HudClientEvents.hudSelectedEntity);
            this.iconRl = new ResourceLocation("reignofnether", "textures/mobheads/" + unitName + ".png");
        } else if (HudClientEvents.hudSelectedPlacement != null) {
            this.iconRl = HudClientEvents.hudSelectedPlacement.getBuilding().icon;
        }
    }

    public void loadToSelected() {
        boolean doubleClicked;
        Minecraft MC = Minecraft.m_91087_();
        LocalPlayer player = MC.f_91074_;
        if (MC.f_91073_ == null) {
            return;
        }
        boolean bl = doubleClicked = System.currentTimeMillis() - this.lastClickTime < 500L && player != null;
        if (this.entityIds.size() > 0) {
            BuildingClientEvents.clearSelectedBuildings();
            UnitClientEvents.clearSelectedUnits();
            for (int id : this.entityIds) {
                List<LivingEntity> entities = UnitClientEvents.getAllUnits().stream().filter(e -> this.entityIds.contains(e.m_19879_()) && e instanceof Unit).toList();
                if (entities.size() <= 0) continue;
                UnitClientEvents.clearSelectedUnits();
                for (LivingEntity entity : entities) {
                    UnitClientEvents.addSelectedUnit(entity);
                }
                HudClientEvents.setLowestCdHudEntity();
                if (!doubleClicked) continue;
                OrthoviewClientEvents.centreCameraOnPos(entities.get(0).m_20182_());
            }
        } else if (this.buildingBps.size() > 0) {
            UnitClientEvents.clearSelectedUnits();
            BuildingClientEvents.clearSelectedBuildings();
            for (BlockPos bp : this.buildingBps) {
                for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
                    if (!building.originPos.equals((Object)bp)) continue;
                    BuildingClientEvents.addSelectedBuilding(building);
                }
            }
            if (doubleClicked) {
                BlockPos pos = this.buildingBps.get(0);
                for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
                    if (!building.originPos.equals((Object)pos)) continue;
                    OrthoviewClientEvents.centreCameraOnPos(building.centrePos);
                }
            }
        }
        this.lastClickTime = System.currentTimeMillis();
    }

    public Button getButton() {
        return new Button("Control Group " + this.getKey(), Button.itemIconSize, this.iconRl == null ? new ResourceLocation("") : this.iconRl, this.keybinding, () -> false, () -> false, () -> true, this::loadToSelected, () -> {
            if (Keybindings.shiftMod.isDown()) {
                this.clearAll();
            }
        }, List.of(FormattedCharSequence.m_13714_((String)LanguageUtil.getTranslation("hud.control_group.reignofnether.control_group", this.keybinding.buttonLabel), (Style)Style.f_131099_)));
    }
}

