/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.mixin;

import com.google.common.collect.Lists;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.villagers.PillagerUnit;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractArrow.class})
public abstract class AbstractArrowMixin
extends Projectile {
    @Shadow
    private int f_36697_;
    @Shadow
    private SoundEvent f_36700_;
    @Shadow
    private IntOpenHashSet f_36701_;
    @Shadow
    private List<Entity> f_36702_;
    @Shadow
    private double f_36698_;
    @Shadow
    public AbstractArrow.Pickup f_36705_;
    @Shadow
    private int f_36699_;

    protected AbstractArrowMixin(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Shadow
    public abstract boolean m_36797_();

    private boolean isInsideTopOfBuilding(BuildingPlacement building) {
        BlockPos bp = this.m_20183_();
        boolean isPosInsideBuildingExt = bp.m_123341_() <= building.maxCorner.m_123341_() + 1 && bp.m_123341_() >= building.minCorner.m_123341_() - 1 && bp.m_123342_() <= building.maxCorner.m_123342_() + 1 && bp.m_123342_() >= building.minCorner.m_123342_() - 1 && bp.m_123343_() <= building.maxCorner.m_123343_() + 1 && bp.m_123343_() >= building.minCorner.m_123343_() - 1;
        return building.isPosInsideBuilding(this.m_20183_()) && this.m_20183_().m_123342_() > building.originPos.m_123342_() + 5;
    }

    @Inject(method={"isNoPhysics"}, at={@At(value="HEAD")}, cancellable=true)
    public void isNoPhysics(CallbackInfoReturnable<Boolean> cir) {
        BuildingPlacement building;
        AttackerUnit aUnit;
        GarrisonableBuilding garrisonableBuilding;
        Entity entity = this.m_19749_();
        if (entity instanceof AttackerUnit && (garrisonableBuilding = GarrisonableBuilding.getGarrison((Unit)((Object)(aUnit = (AttackerUnit)entity)))) instanceof BuildingPlacement && this.isInsideTopOfBuilding(building = (BuildingPlacement)((Object)garrisonableBuilding))) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        if (this.m_36797_()) {
            Vec3 vec3 = this.m_20184_();
            double d4 = vec3.m_165924_();
            double d6 = vec3.f_82480_;
            this.m_146926_((float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875));
            this.m_146926_(AbstractArrowMixin.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
            this.m_146922_(AbstractArrowMixin.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
        }
    }

    @Inject(method={"tickDespawn"}, at={@At(value="TAIL")})
    protected void tickDespawn(CallbackInfo ci) {
        if (this.m_19749_() instanceof Unit && this.f_36697_ >= 200) {
            this.m_146870_();
        }
    }

    @Shadow
    public byte m_36796_() {
        return 0;
    }

    @Shadow
    public boolean m_36792_() {
        return false;
    }

    @Shadow
    protected abstract ItemStack m_7941_();

    @Shadow
    protected void m_7761_(LivingEntity pTarget) {
    }

    @Shadow
    public boolean m_36795_() {
        return false;
    }

    @Inject(method={"onHitEntity"}, at={@At(value="HEAD")}, cancellable=true)
    protected void onHitEntity(EntityHitResult pResult, CallbackInfo ci) {
        PillagerUnit pUnit;
        Entity entity;
        DamageSource damagesource;
        Entity entity1;
        ci.cancel();
        super.m_5790_(pResult);
        Entity entity2 = pResult.m_82443_();
        float f = (float)this.m_20184_().m_82553_();
        int i = Mth.m_14165_((double)Mth.m_14008_((double)((double)f * this.f_36698_), (double)0.0, (double)2.147483647E9));
        if (this.m_36796_() > 0) {
            if (this.f_36701_ == null) {
                this.f_36701_ = new IntOpenHashSet(5);
            }
            if (this.f_36702_ == null) {
                this.f_36702_ = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.f_36701_.size() >= this.m_36796_() + 1) {
                this.m_146870_();
                return;
            }
            this.f_36701_.add(entity2.m_19879_());
        }
        if (this.m_36792_()) {
            long j = this.f_19796_.m_188503_(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        if ((entity1 = this.m_19749_()) == null) {
            damagesource = this.m_269291_().m_269418_((AbstractArrow)new Arrow(this.m_9236_(), this.f_19854_, this.f_19855_, this.f_19856_), (Entity)this);
        } else {
            damagesource = this.m_269291_().m_269418_((AbstractArrow)new Arrow(this.m_9236_(), this.f_19854_, this.f_19855_, this.f_19856_), entity1);
            if (entity1 instanceof LivingEntity) {
                ((LivingEntity)entity1).m_21335_(entity2);
            }
        }
        boolean flag = entity2.m_6095_() == EntityType.f_20566_;
        int k = entity2.m_20094_();
        if (this.m_6060_() && !flag) {
            entity2.m_20254_(5);
        }
        if (entity2.m_6469_(damagesource, (float)i)) {
            if (flag) {
                return;
            }
            if (entity2 instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity2;
                if (!this.m_9236_().f_46443_ && this.m_36796_() <= 0) {
                    livingentity.m_21317_(livingentity.m_21234_() + 1);
                }
                if (this.f_36699_ > 0) {
                    double d0 = Math.max(0.0, 1.0 - livingentity.m_21133_(Attributes.f_22278_));
                    Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.f_36699_ * 0.6 * d0);
                    if (vec3.m_82556_() > 0.0) {
                        livingentity.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
                    }
                }
                if (!this.m_9236_().f_46443_ && entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity);
                }
                this.m_7761_(livingentity);
                if (entity1 != null && livingentity != entity1 && livingentity instanceof Player && entity1 instanceof ServerPlayer && !this.m_20067_()) {
                    ((ServerPlayer)entity1).f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                }
                if (!entity2.m_6084_() && this.f_36702_ != null) {
                    this.f_36702_.add((Entity)livingentity);
                }
                if (!this.m_9236_().f_46443_ && entity1 instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)entity1;
                    if (this.f_36702_ != null && this.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverplayer, this.f_36702_);
                    } else if (!entity2.m_6084_() && this.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverplayer, Arrays.asList(entity2));
                    }
                }
            }
            this.m_5496_(this.f_36700_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            if (this.m_36796_() <= 0) {
                this.m_146870_();
            }
        } else {
            if (this.f_36701_ == null) {
                this.f_36701_ = new IntOpenHashSet(5);
            }
            if (this.f_36702_ == null) {
                this.f_36702_ = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.f_36701_.size() >= this.m_36796_() + 1) {
                this.m_146870_();
                return;
            }
            this.f_36701_.add(entity2.m_19879_());
        }
        if ((entity = this.m_19749_()) instanceof PillagerUnit && !(pUnit = (PillagerUnit)entity).m_9236_().m_5776_() && pUnit.m_20159_()) {
            pUnit.m_9236_().m_254877_((Entity)this, damagesource, null, pResult.m_82443_().m_146892_().f_82479_, pResult.m_82443_().m_146892_().f_82480_, pResult.m_82443_().m_146892_().f_82481_, 1.0f, false, Level.ExplosionInteraction.NONE);
        }
    }

    @Inject(method={"onHitBlock"}, at={@At(value="HEAD")})
    protected void onHitBlock(BlockHitResult pResult, CallbackInfo ci) {
        PillagerUnit pUnit;
        Entity entity = this.m_19749_();
        if (entity instanceof PillagerUnit && !(pUnit = (PillagerUnit)entity).m_9236_().m_5776_() && pUnit.m_20159_()) {
            pUnit.m_9236_().m_254877_((Entity)this, null, null, pResult.m_82450_().f_82479_, pResult.m_82450_().f_82480_, pResult.m_82450_().f_82481_, 1.0f, false, Level.ExplosionInteraction.NONE);
        }
    }
}

