/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.player;

import com.mojang.brigadier.CommandDispatcher;
import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.alliance.AlliancesServerEvents;
import com.solegendary.reignofnether.alliance.AllyCommand;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.NetherZone;
import com.solegendary.reignofnether.building.buildings.neutral.Beacon;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.production.ProductionBuilding;
import com.solegendary.reignofnether.gamemode.GameMode;
import com.solegendary.reignofnether.gamemode.GameModeClientboundPacket;
import com.solegendary.reignofnether.guiscreen.TopdownGuiContainer;
import com.solegendary.reignofnether.hero.HeroClientEvents;
import com.solegendary.reignofnether.hero.HeroClientboundPacket;
import com.solegendary.reignofnether.player.PlayerClientboundPacket;
import com.solegendary.reignofnether.player.RTSPlayer;
import com.solegendary.reignofnether.player.RTSPlayerSaveData;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.registrars.GameRuleRegistrar;
import com.solegendary.reignofnether.research.ResearchClientboundPacket;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.sandbox.SandboxServer;
import com.solegendary.reignofnether.startpos.StartPosServerEvents;
import com.solegendary.reignofnether.survival.SurvivalServerEvents;
import com.solegendary.reignofnether.time.TimeUtils;
import com.solegendary.reignofnether.tutorial.TutorialServerEvents;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.unit.packets.UnitSyncClientboundPacket;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkHooks;

public class PlayerServerEvents {
    private static final Map<String, GameType> playerDefaultGameModes = new HashMap<String, GameType>();
    private static final Map<String, Boolean> playerGuiOpenStatus = new HashMap<String, Boolean>();
    public static final ArrayList<ServerPlayer> players = new ArrayList();
    public static final ArrayList<ServerPlayer> orthoviewPlayers = new ArrayList();
    public static final List<RTSPlayer> rtsPlayers = Collections.synchronizedList(new ArrayList());
    public static boolean rtsLocked = false;
    public static boolean rtsSyncingEnabled = true;
    private static final int MONSTER_START_TIME_OF_DAY = 500;
    public static final int ORTHOVIEW_PLAYER_BASE_Y = 85;
    public static final int TICKS_TO_REVEAL = 1200;
    public static long rtsGameTicks = 0L;
    public static ServerLevel serverLevel = null;
    public static final List<String> singleWordCheats = List.of("warpten", "operationcwal", "modifythephasevariance", "medievalman", "foodforthought", "thereisnospoon", "slipslopslap", "wouldyoukindly");
    private static final int SAVE_TICKS_MAX = 1200;
    private static int saveTicks = 0;

    public static void saveRTSPlayers() {
        if (serverLevel == null) {
            return;
        }
        RTSPlayerSaveData data = RTSPlayerSaveData.getInstance((LevelAccessor)serverLevel);
        data.rtsPlayers.clear();
        data.rtsPlayers.addAll(rtsPlayers);
        data.save();
        serverLevel.m_8895_().m_78151_();
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent evt) {
        ServerLevel level = evt.getServer().m_129880_(Level.f_46428_);
        if (level != null) {
            RTSPlayerSaveData data = RTSPlayerSaveData.getInstance((LevelAccessor)level);
            rtsPlayers.clear();
            rtsPlayers.addAll(data.rtsPlayers);
            for (RTSPlayer rtsPlayer : rtsPlayers) {
                if (rtsPlayer.faction != Faction.NONE) continue;
                GameModeClientboundPacket.setAndLockAllClientGameModes(GameMode.SANDBOX);
                PlayerServerEvents.enableAllCheats(rtsPlayer.name);
                break;
            }
            UnitServerEvents.maxPopulation = level.m_46469_().m_46215_(GameRuleRegistrar.MAX_POPULATION);
            ((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46148_)).m_46246_(true, evt.getServer());
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent evt) {
        PlayerServerEvents.saveRTSPlayers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRTSPlayer(String playerName) {
        List<RTSPlayer> list = rtsPlayers;
        synchronized (list) {
            return rtsPlayers.stream().filter(p -> p.name.equals(playerName)).toList().size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRTSPlayer(int id) {
        List<RTSPlayer> list = rtsPlayers;
        synchronized (list) {
            return rtsPlayers.stream().filter(p -> p.id == id).toList().size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBot(String playerName) {
        List<RTSPlayer> list = rtsPlayers;
        synchronized (list) {
            for (RTSPlayer rtsPlayer : rtsPlayers) {
                if (!rtsPlayer.name.equalsIgnoreCase(playerName)) continue;
                return rtsPlayer.isBot();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBot(int id) {
        List<RTSPlayer> list = rtsPlayers;
        synchronized (list) {
            for (RTSPlayer rtsPlayer : rtsPlayers) {
                if (rtsPlayer.id != id) continue;
                return rtsPlayer.isBot();
            }
        }
        return false;
    }

    public static boolean isGameActive() {
        return !rtsPlayers.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent evt) {
        ServerLevel level;
        serverLevel = evt.getServer().m_129880_(Level.f_46428_);
        List<RTSPlayer> list = rtsPlayers;
        synchronized (list) {
            if (evt.phase == TickEvent.Phase.END) {
                for (RTSPlayer rtsPlayer : rtsPlayers) {
                    rtsPlayer.tick();
                }
                for (RTSPlayer rtsPlayer : rtsPlayers) {
                    if (rtsPlayer.beaconOwnerTicks != Beacon.getTicksToWin((Level)serverLevel)) continue;
                    PlayerServerEvents.beaconVictory(rtsPlayer.name);
                    break;
                }
                if (rtsPlayers.isEmpty()) {
                    rtsGameTicks = 0L;
                } else {
                    if (++rtsGameTicks % 200L == 0L) {
                        PlayerClientboundPacket.syncRtsGameTime(rtsGameTicks);
                    }
                    if (rtsGameTicks % 20L == 0L) {
                        for (RTSPlayer rtsPlayer : rtsPlayers) {
                            PlayerClientboundPacket.syncBeaconOwnerTicks(rtsPlayer.name, rtsPlayer.beaconOwnerTicks);
                        }
                    }
                }
            }
        }
        if (evt.phase == TickEvent.Phase.END && ++saveTicks >= 1200 && (level = evt.getServer().m_129880_(Level.f_46428_)) != null) {
            PlayerServerEvents.saveRTSPlayers();
            saveTicks = 0;
        }
    }

    private static void syncUnits() {
        for (LivingEntity entity : UnitServerEvents.getAllUnits()) {
            if (entity instanceof Unit) {
                Unit unit = (Unit)entity;
                UnitSyncClientboundPacket.sendSyncResourcesPacket(unit);
                UnitSyncClientboundPacket.sendSyncOwnerNamePacket(unit);
                UnitSyncClientboundPacket.sendSyncAnchorPosPacket(entity, unit.getAnchor());
            }
            if (!(entity instanceof HeroUnit)) continue;
            HeroUnit hero = (HeroUnit)entity;
            HeroClientboundPacket.setExperience(entity.m_19879_(), hero.getExperience());
            HeroClientboundPacket.setSkillPoints(entity.m_19879_(), hero.getSkillPoints());
            HeroClientboundPacket.setCharges(entity.m_19879_(), hero.getChargesForSaveData());
            List<HeroAbility> abls = hero.getHeroAbilities();
            if (abls.size() > 0) {
                HeroClientboundPacket.setAbilityRank(entity.m_19879_(), abls.get((int)0).rank, 0);
            }
            if (abls.size() > 1) {
                HeroClientboundPacket.setAbilityRank(entity.m_19879_(), abls.get((int)1).rank, 1);
            }
            if (abls.size() > 2) {
                HeroClientboundPacket.setAbilityRank(entity.m_19879_(), abls.get((int)2).rank, 2);
            }
            if (abls.size() <= 3) continue;
            HeroClientboundPacket.setAbilityRank(entity.m_19879_(), abls.get((int)3).rank, 3);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        ServerPlayer serverPlayer = (ServerPlayer)evt.getEntity();
        players.add((ServerPlayer)evt.getEntity());
        String playerName = serverPlayer.m_7755_().getString();
        ReignOfNether.LOGGER.info("Player logged in: " + playerName + ", id: " + serverPlayer.m_19879_());
        if (rtsSyncingEnabled) {
            MinecraftServer server = evt.getEntity().m_9236_().m_7654_();
            if (server == null || !server.m_6982_()) {
                CompletableFuture.delayedExecutor(1000L, TimeUnit.MILLISECONDS).execute(PlayerServerEvents::syncUnits);
            } else {
                PlayerServerEvents.syncUnits();
            }
            ResearchServerEvents.syncResearch(playerName);
            ResearchServerEvents.syncCheats(playerName);
        }
        if (orthoviewPlayers.stream().map(Entity::m_19879_).toList().contains(evt.getEntity().m_19879_())) {
            orthoviewPlayers.add((ServerPlayer)evt.getEntity());
        }
        if (!TutorialServerEvents.isEnabled()) {
            if (!PlayerServerEvents.isRTSPlayer(serverPlayer.m_19879_())) {
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"tutorial.reignofnether.welcome").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"tutorial.reignofnether.join"));
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"tutorial.reignofnether.help"));
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"tutorial.reignofnether.controls"));
                if (rtsLocked) {
                    serverPlayer.m_213846_((Component)Component.m_237113_((String)""));
                    serverPlayer.m_213846_((Component)Component.m_237115_((String)"tutorial.reignofnether.locked"));
                }
            } else {
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"tutorial.reignofnether.welcome_back").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
            }
            if (serverPlayer.m_20310_(4)) {
                serverPlayer.m_213846_((Component)Component.m_237113_((String)""));
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"tutorial.reignofnether.op_commands"));
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"tutorial.reignofnether.fog"));
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"tutorial.reignofnether.lock"));
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"tutorial.reignofnether.syncing"));
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"tutorial.reignofnether.reset"));
                serverPlayer.m_213846_((Component)Component.m_237113_((String)""));
            }
            if (!rtsSyncingEnabled) {
                serverPlayer.m_213846_((Component)Component.m_237113_((String)""));
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"tutorial.reignofnether.sync_disabled1"));
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"tutorial.reignofnether.sync_disabled2"));
                serverPlayer.m_213846_((Component)Component.m_237113_((String)""));
            }
        }
        if (PlayerServerEvents.isRTSPlayer(playerName)) {
            PlayerClientboundPacket.enableRTSStatus(playerName);
        } else {
            PlayerClientboundPacket.disableRTSStatus(playerName);
        }
        if (rtsLocked) {
            PlayerClientboundPacket.lockRTS(playerName);
        } else {
            PlayerClientboundPacket.unlockRTS(playerName);
        }
        if (rtsSyncingEnabled) {
            PlayerClientboundPacket.enableStartRTS(playerName);
        } else {
            PlayerClientboundPacket.disableStartRTS(playerName);
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent evt) {
        int id = evt.getEntity().m_19879_();
        ReignOfNether.LOGGER.info("Player logged out: " + evt.getEntity().m_7755_().getString() + ", id: " + id);
        players.removeIf(player -> player.m_19879_() == id);
    }

    public static void startRTS(int playerId, Vec3 pos, Faction faction) {
        PlayerServerEvents.startRTS(playerId, pos, faction, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startRTS(int playerId, Vec3 pos, Faction faction, boolean readiedStart) {
        List<RTSPlayer> list = rtsPlayers;
        synchronized (list) {
            BlockPos bp;
            ServerPlayer serverPlayer = null;
            for (ServerPlayer player : players) {
                if (player.m_19879_() != playerId) continue;
                serverPlayer = player;
            }
            if (serverPlayer == null) {
                return;
            }
            if (rtsLocked) {
                serverPlayer.m_213846_((Component)Component.m_237113_((String)""));
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"server.reignofnether.locked"));
                serverPlayer.m_213846_((Component)Component.m_237113_((String)""));
                return;
            }
            if (PlayerServerEvents.isRTSPlayer(serverPlayer.m_19879_())) {
                serverPlayer.m_213846_((Component)Component.m_237113_((String)""));
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"server.reignofnether.already_started"));
                serverPlayer.m_213846_((Component)Component.m_237113_((String)""));
                return;
            }
            if (serverPlayer.m_9236_().m_6857_().m_61941_(pos.f_82479_, pos.f_82481_) < 1.0 && faction != Faction.NONE) {
                serverPlayer.m_213846_((Component)Component.m_237113_((String)""));
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"server.reignofnether.outside_border"));
                serverPlayer.m_213846_((Component)Component.m_237113_((String)""));
                return;
            }
            EntityType entityType = switch (faction) {
                default -> throw new IncompatibleClassChangeError();
                case Faction.VILLAGERS -> (EntityType)EntityRegistrar.VILLAGER_UNIT.get();
                case Faction.MONSTERS -> (EntityType)EntityRegistrar.ZOMBIE_VILLAGER_UNIT.get();
                case Faction.PIGLINS -> (EntityType)EntityRegistrar.GRUNT_UNIT.get();
                case Faction.NONE -> null;
            };
            rtsPlayers.add(RTSPlayer.getNewPlayer(serverPlayer, faction));
            String playerName = serverPlayer.m_7755_().getString();
            ResourcesServerEvents.assignResources(playerName);
            PlayerClientboundPacket.enableRTSStatus(playerName);
            ServerLevel level = (ServerLevel)serverPlayer.m_9236_();
            ArrayList<Entity> workers = new ArrayList<Entity>();
            for (int i = -1; i <= 1; ++i) {
                Entity entity;
                Entity entity2 = entity = entityType != null ? entityType.m_20615_((Level)level) : null;
                if (entity == null) continue;
                bp = MiscUtil.getHighestNonAirBlock((Level)level, new BlockPos((int)(pos.f_82479_ + (double)i), 0, (int)pos.f_82481_)).m_7494_().m_7494_();
                ((Unit)entity).setOwnerName(playerName);
                entity.m_20035_(bp, 0.0f, 0.0f);
                if (!readiedStart) {
                    level.m_7967_(entity);
                }
                workers.add(entity);
            }
            if (faction != Faction.NONE) {
                if (SurvivalServerEvents.isEnabled()) {
                    level.m_8615_(500L + TimeUtils.getWaveSurvivalTimeModifier(SurvivalServerEvents.getDifficulty()));
                    for (RTSPlayer rtsPlayer : rtsPlayers) {
                        if (rtsPlayer.name.equals(playerName)) continue;
                        AlliancesServerEvents.addAlliance(rtsPlayer.name, playerName);
                    }
                } else {
                    level.m_8615_(500L);
                }
            } else {
                PlayerServerEvents.enableAllCheats(playerName);
            }
            ResourcesServerEvents.resetResources(playerName);
            if (readiedStart) {
                ProductionBuilding building = null;
                ArrayList<BuildingBlock> blocks = null;
                switch (faction) {
                    case VILLAGERS: {
                        building = Buildings.TOWN_CENTRE;
                        blocks = Buildings.TOWN_CENTRE.getRelativeBlockData((LevelAccessor)level);
                        break;
                    }
                    case MONSTERS: {
                        building = Buildings.MAUSOLEUM;
                        blocks = Buildings.MAUSOLEUM.getRelativeBlockData((LevelAccessor)level);
                        break;
                    }
                    case PIGLINS: {
                        building = Buildings.CENTRAL_PORTAL;
                        blocks = Buildings.CENTRAL_PORTAL.getRelativeBlockData((LevelAccessor)level);
                    }
                }
                if (building != null) {
                    bp = PlayerServerEvents.getBuildingOriginPos(new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_), blocks);
                    for (int i = 0; i < workers.size(); ++i) {
                        ((Entity)workers.get(i)).m_20035_(bp.m_7918_(i, 0, 0), 0.0f, 0.0f);
                        level.m_7967_((Entity)workers.get(i));
                    }
                    int[] workerIds = workers.stream().map(Entity::m_19879_).mapToInt(Integer::intValue).toArray();
                    BuildingServerEvents.placeBuilding(building, bp, Rotation.NONE, playerName, workerIds, false, false);
                }
            }
            if (!TutorialServerEvents.isEnabled() && !readiedStart) {
                serverPlayer.m_213846_((Component)Component.m_237113_((String)""));
                if (faction == Faction.NONE) {
                    PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.started_sandbox", true, playerName);
                } else {
                    PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.started", true, playerName);
                }
                PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.total_players", false, rtsPlayers.size());
            }
            PlayerClientboundPacket.syncRtsGameTime(rtsGameTicks);
            PlayerServerEvents.saveRTSPlayers();
        }
    }

    public static BlockPos getBuildingOriginPos(BlockPos bp, ArrayList<BuildingBlock> blocks) {
        Vec3i buildingDimensions = BuildingUtils.getBuildingSize(blocks);
        int xRadius = buildingDimensions.m_123341_() / 2;
        int zRadius = buildingDimensions.m_123343_() / 2;
        return bp.m_7918_(-xRadius, 0, -zRadius);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startRTSBot(String name, Vec3 pos, Faction faction) {
        List<RTSPlayer> list = rtsPlayers;
        synchronized (list) {
            if (players.isEmpty()) {
                return;
            }
            ServerLevel level = (ServerLevel)players.get(0).m_9236_();
            EntityType entityType = switch (faction) {
                default -> throw new IncompatibleClassChangeError();
                case Faction.VILLAGERS -> (EntityType)EntityRegistrar.VILLAGER_UNIT.get();
                case Faction.MONSTERS -> (EntityType)EntityRegistrar.ZOMBIE_VILLAGER_UNIT.get();
                case Faction.PIGLINS -> (EntityType)EntityRegistrar.GRUNT_UNIT.get();
                case Faction.NONE -> null;
            };
            RTSPlayer bot = RTSPlayer.getNewBot(name, faction);
            rtsPlayers.add(bot);
            ResourcesServerEvents.assignResources(bot.name);
            for (int i = -1; i <= 1; ++i) {
                Entity entity;
                Entity entity2 = entity = entityType != null ? entityType.m_20615_((Level)level) : null;
                if (entity == null) continue;
                BlockPos bp = MiscUtil.getHighestNonAirBlock((Level)level, new BlockPos((int)(pos.f_82479_ + (double)i), 0, (int)pos.f_82481_)).m_7494_().m_7494_();
                ((Unit)entity).setOwnerName(bot.name);
                entity.m_20035_(bp, 0.0f, 0.0f);
                level.m_7967_(entity);
            }
            if (faction == Faction.MONSTERS) {
                level.m_8615_(500L);
            }
            ResourcesServerEvents.resetResources(bot.name);
            if (!TutorialServerEvents.isEnabled()) {
                PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.bot_added", true, bot.name);
                PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.total_players", false, rtsPlayers.size());
            }
            PlayerServerEvents.saveRTSPlayers();
        }
    }

    @SubscribeEvent
    public static void onPlayerChat(ServerChatEvent evt) {
        if (evt.getPlayer().m_20310_(4)) {
            String msg = evt.getMessage().getString();
            String[] words = msg.split(" ");
            String playerName = evt.getPlayer().m_7755_().getString();
            if (words.length == 1 && words[0].equalsIgnoreCase("thebeastofcaerbannog")) {
                UnitServerEvents.spawnMob(EntityRegistrar.getEntityType("Killer Rabbit"), serverLevel, (Vec3i)evt.getPlayer().m_20097_(), playerName);
                PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.used_cheat", false, playerName, words[0]);
            }
            if (words.length == 1 && words[0].equalsIgnoreCase("elitetaurenchieftain")) {
                for (LivingEntity livingEntity : UnitServerEvents.getAllUnits()) {
                    HeroUnit heroUnit;
                    if (!(livingEntity instanceof HeroUnit) || !(heroUnit = (HeroUnit)livingEntity).getOwnerName().equals(playerName)) continue;
                    heroUnit.addExperience(10000);
                    heroUnit.setSkillPoints(10);
                    HeroClientboundPacket.setExperience(livingEntity.m_19879_(), heroUnit.getExperience());
                    HeroClientboundPacket.setSkillPoints(livingEntity.m_19879_(), 10);
                }
                PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.used_cheat", false, playerName, words[0]);
            }
            if (words.length == 2) {
                try {
                    int amount;
                    if (words[0].equalsIgnoreCase("greedisgood") && (amount = Integer.parseInt(words[1])) > 0) {
                        ResourcesServerEvents.addSubtractResources(new Resources(playerName, amount, amount, amount));
                        evt.setCanceled(true);
                        PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.used_cheat_amount", false, playerName, words[0], Integer.toString(amount));
                    }
                }
                catch (NumberFormatException err) {
                    ReignOfNether.LOGGER.error((Object)err);
                }
            }
            if (words.length == 3) {
                try {
                    int amount;
                    if (words[0].equalsIgnoreCase("greedisgood") && (amount = Integer.parseInt(words[2])) > 0 && List.of("food", "wood", "ore").contains(words[1].toLowerCase())) {
                        switch (words[1].toLowerCase()) {
                            case "food": {
                                ResourcesServerEvents.addSubtractResources(new Resources(playerName, amount, 0, 0));
                                break;
                            }
                            case "wood": {
                                ResourcesServerEvents.addSubtractResources(new Resources(playerName, 0, amount, 0));
                                break;
                            }
                            case "ore": {
                                ResourcesServerEvents.addSubtractResources(new Resources(playerName, 0, 0, amount));
                            }
                        }
                        evt.setCanceled(true);
                        PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.used_cheat_amount", false, playerName, words[0] + " " + words[1], Integer.toString(amount));
                    }
                }
                catch (NumberFormatException err) {
                    ReignOfNether.LOGGER.error((Object)err);
                }
            }
            for (String string : singleWordCheats) {
                if (words.length != 1 || !words[0].equalsIgnoreCase(string)) continue;
                if (ResearchServerEvents.playerHasCheat(playerName, string)) {
                    ResearchServerEvents.removeCheat(playerName, string);
                    ResearchClientboundPacket.removeCheat(playerName, string);
                    evt.setCanceled(true);
                    PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.disabled_cheat", false, playerName, string);
                    continue;
                }
                ResearchServerEvents.addCheat(playerName, string);
                ResearchClientboundPacket.addCheat(playerName, string);
                evt.setCanceled(true);
                PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.enabled_cheat", false, playerName, string);
            }
            if (words.length == 1 && words[0].equalsIgnoreCase("allcheats") && (playerName.equalsIgnoreCase("solegendary") || playerName.equalsIgnoreCase("altsolegendary"))) {
                ResourcesServerEvents.addSubtractResources(new Resources(playerName, 99999, 99999, 99999));
                UnitServerEvents.maxPopulation = 99999;
                PlayerServerEvents.enableAllCheats(playerName);
                evt.setCanceled(true);
                PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.all_cheats", false, playerName);
            }
        }
    }

    public static void enableAllCheats(String playerName) {
        for (String cheatName : singleWordCheats) {
            ResearchServerEvents.addCheat(playerName, cheatName);
            ResearchClientboundPacket.addCheat(playerName, cheatName);
        }
    }

    public static void enableOrthoview(int id) {
        ServerPlayer player = PlayerServerEvents.getPlayerById(id);
        player.m_21219_();
        orthoviewPlayers.removeIf(p -> p.m_19879_() == id);
        orthoviewPlayers.add(player);
    }

    public static void disableOrthoview(int id) {
        orthoviewPlayers.removeIf(p -> p.m_19879_() == id);
    }

    private static ServerPlayer getPlayerById(int playerId) {
        return players.stream().filter(player -> playerId == player.m_19879_()).findAny().orElse(null);
    }

    public static void openTopdownGui(int playerId) {
        ServerPlayer serverPlayer = PlayerServerEvents.getPlayerById(playerId);
        if (serverPlayer != null) {
            MenuConstructor provider = TopdownGuiContainer.getServerContainerProvider();
            SimpleMenuProvider namedProvider = new SimpleMenuProvider(provider, TopdownGuiContainer.TITLE);
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)namedProvider);
            String playerName = serverPlayer.m_7755_().getString();
            playerDefaultGameModes.putIfAbsent(playerName, serverPlayer.f_8941_.m_9290_());
            playerGuiOpenStatus.put(playerName, true);
            serverPlayer.m_143403_(GameType.SPECTATOR);
        } else {
            ReignOfNether.LOGGER.warn("serverPlayer is null, cannot open topdown GUI");
        }
    }

    public static void closeTopdownGui(int playerId) {
        ServerPlayer serverPlayer = PlayerServerEvents.getPlayerById(playerId);
        if (serverPlayer != null) {
            String playerName = serverPlayer.m_7755_().getString();
            if (Boolean.TRUE.equals(playerGuiOpenStatus.get(playerName))) {
                GameType originalGameType = playerDefaultGameModes.remove(playerName);
                if (originalGameType != null) {
                    serverPlayer.m_143403_(originalGameType);
                } else {
                    ReignOfNether.LOGGER.warn("No original game mode found for player {}", (Object)playerName);
                }
                if (SandboxServer.isSandboxPlayer(playerName)) {
                    serverPlayer.m_143403_(GameType.CREATIVE);
                }
                playerGuiOpenStatus.remove(playerName);
            } else {
                ReignOfNether.LOGGER.warn("Attempted to close GUI for player {} who didn't have it open", (Object)playerName);
            }
        } else {
            ReignOfNether.LOGGER.warn("serverPlayer is null, cannot close topdown GUI");
        }
    }

    public static void movePlayer(int playerId, double x, double y, double z) {
        ServerPlayer serverPlayer = PlayerServerEvents.getPlayerById(playerId);
        serverPlayer.m_6021_(x, y, z);
    }

    public static void sendMessageToAllPlayers(String msg) {
        PlayerServerEvents.sendMessageToAllPlayers(msg, false, new Object[0]);
    }

    public static void sendMessageToAllPlayers(String msg, int color, boolean bold, Object ... formatArgs) {
        for (ServerPlayer player : players) {
            player.m_213846_((Component)Component.m_237113_((String)""));
            if (bold) {
                player.m_213846_((Component)Component.m_237110_((String)msg, (Object[])formatArgs).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(color)));
            } else {
                player.m_213846_((Component)Component.m_237110_((String)msg, (Object[])formatArgs).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_178520_(color)));
            }
            player.m_213846_((Component)Component.m_237113_((String)""));
        }
    }

    public static void sendMessageToAllPlayers(String msg, boolean bold, Object ... formatArgs) {
        PlayerServerEvents.sendMessageToAllPlayers(msg, 0xFFFFFF, bold, formatArgs);
    }

    public static void sendMessageToAllPlayersNoNewlines(String msg) {
        PlayerServerEvents.sendMessageToAllPlayersNoNewlines(msg, false, new Object[0]);
    }

    public static void sendMessageToAllPlayersNoNewlines(String msg, boolean bold, Object ... formatArgs) {
        for (ServerPlayer player : players) {
            if (bold) {
                player.m_213846_((Component)Component.m_237110_((String)msg, (Object[])formatArgs).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                continue;
            }
            player.m_213846_((Component)Component.m_237110_((String)msg, (Object[])formatArgs));
        }
    }

    public static void sendMessageToPlayer(String playerName, String msg) {
        PlayerServerEvents.sendMessageToPlayer(playerName, msg, false, new Object[0]);
    }

    public static void sendMessageToPlayer(String playerName, String msg, boolean bold, Object ... formatArgs) {
        for (ServerPlayer player : players) {
            if (!player.m_7755_().getString().equals(playerName)) continue;
            player.m_213846_((Component)Component.m_237113_((String)""));
            if (bold) {
                player.m_213846_((Component)Component.m_237110_((String)msg, (Object[])formatArgs).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
            } else {
                player.m_213846_((Component)Component.m_237110_((String)msg, (Object[])formatArgs));
            }
            player.m_213846_((Component)Component.m_237113_((String)""));
            return;
        }
    }

    public static void defeat(int playerId, String reason) {
        for (ServerPlayer player : players) {
            if (player.m_19879_() != playerId) continue;
            PlayerServerEvents.defeat(player.m_7755_().getString(), reason);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void defeat(String playerName, String reason) {
        if (SandboxServer.isSandboxPlayer(playerName)) {
            return;
        }
        List<RTSPlayer> list = rtsPlayers;
        synchronized (list) {
            rtsPlayers.removeIf(rtsPlayer -> {
                if (rtsPlayer.name.equals(playerName)) {
                    PlayerServerEvents.sendMessageToAllPlayers(playerName + " has " + reason + " and is defeated!", true, new Object[0]);
                    PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.players_remaining", false, rtsPlayers.size() - 1);
                    PlayerClientboundPacket.defeat(playerName);
                    for (LivingEntity entity : UnitServerEvents.getAllUnits()) {
                        Unit unit;
                        if (!(entity instanceof Unit) || !(unit = (Unit)entity).getOwnerName().equals(playerName)) continue;
                        unit.resetBehaviours();
                        Unit.resetBehaviours(unit);
                        if (unit instanceof AttackerUnit) {
                            AttackerUnit aUnit = (AttackerUnit)((Object)unit);
                            AttackerUnit.resetBehaviours(aUnit);
                        }
                        if (unit instanceof WorkerUnit) {
                            WorkerUnit wUnit = (WorkerUnit)((Object)unit);
                            WorkerUnit.resetBehaviours(wUnit);
                        }
                        unit.setOwnerName("");
                    }
                    for (BuildingPlacement building : BuildingServerEvents.getBuildings()) {
                        if (!building.ownerName.equals(playerName)) continue;
                        if (building instanceof ProductionPlacement) {
                            ProductionPlacement productionBuilding = (ProductionPlacement)building;
                            productionBuilding.productionQueue.clear();
                        }
                        building.ownerName = "";
                    }
                    return true;
                }
                return false;
            });
            PlayerServerEvents.saveRTSPlayers();
            ResearchServerEvents.removeAllResearchFor(playerName);
            ResearchServerEvents.syncResearch(playerName);
            ResearchServerEvents.saveResearch();
            ResearchServerEvents.removeAllCheatsFor(playerName);
            ResourcesServerEvents.resourcesList.removeIf(rl -> rl.ownerName.equals(playerName));
            if (rtsPlayers.size() > 1) {
                String referencePlayer;
                Set<String> factionGroup;
                Set remainingPlayers = rtsPlayers.stream().map(player -> player.name).collect(Collectors.toSet());
                if (remainingPlayers.equals(factionGroup = AlliancesServerEvents.getAllConnectedAllies(referencePlayer = (String)remainingPlayers.iterator().next()))) {
                    for (String winner : remainingPlayers) {
                        PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.victory_alliance", true, winner);
                        PlayerClientboundPacket.victory(winner);
                    }
                }
            } else if (rtsPlayers.size() == 1) {
                RTSPlayer winner = rtsPlayers.get(0);
                PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.victorious", true, winner.name);
                PlayerClientboundPacket.victory(winner.name);
            }
        }
    }

    public static void beaconVictory(String playerName) {
        if (SurvivalServerEvents.isEnabled()) {
            if (AlliancesServerEvents.getAllAllies(playerName).isEmpty()) {
                PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.victorious", true, playerName);
            } else {
                PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.victory_alliance", true, playerName);
            }
            PlayerClientboundPacket.victory(playerName);
            for (String allyName : AlliancesServerEvents.getAllAllies(playerName)) {
                PlayerClientboundPacket.victory(allyName);
            }
            SurvivalServerEvents.endCurrentWave();
        } else {
            List<String> playerNames = rtsPlayers.stream().map(p -> p.name).filter(n -> !AlliancesServerEvents.isAllied(playerName, n) && !n.equals(playerName)).toList();
            for (String name : playerNames) {
                PlayerServerEvents.defeat(name, Component.m_237115_((String)"server.reignofnether.beacon_defeat").getString());
            }
        }
    }

    public static String getBeaconWinTime(String playerName) {
        for (RTSPlayer rtsPlayer : rtsPlayers) {
            if (!rtsPlayer.name.equals(playerName)) continue;
            return TimeUtils.getTimeStrFromTicks(Beacon.getTicksToWin((Level)serverLevel) - rtsPlayer.beaconOwnerTicks);
        }
        return TimeUtils.getTimeStrFromTicks(Beacon.getTicksToWin((Level)serverLevel));
    }

    @SubscribeEvent
    public static void onRegisterCommand(RegisterCommandsEvent evt) {
        AllyCommand.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetRTS(boolean hardReset) {
        StartPosServerEvents.cancelStartGameCountdown(true);
        boolean isSandbox = SandboxServer.isAnyoneASandboxPlayer();
        List<RTSPlayer> list = rtsPlayers;
        synchronized (list) {
            Unit unit;
            rtsPlayers.clear();
            for (LivingEntity entity : UnitServerEvents.getAllUnits()) {
                if (!hardReset && (!(entity instanceof Unit) || Unit.hasAnchor(unit = (Unit)entity) || isSandbox)) continue;
                entity.m_6074_();
            }
            if (!isSandbox) {
                UnitServerEvents.getAllUnits().removeIf(u -> {
                    Unit unit;
                    return hardReset || u instanceof Unit && !Unit.hasAnchor(unit = (Unit)u);
                });
            }
            for (LivingEntity entity : UnitServerEvents.getAllUnits()) {
                if (!(entity instanceof Unit)) continue;
                unit = (Unit)entity;
                unit.setOwnerName("");
            }
            for (BuildingPlacement building : BuildingServerEvents.getBuildings()) {
                if (building instanceof ProductionPlacement) {
                    ProductionPlacement productionBuilding = (ProductionPlacement)building;
                    productionBuilding.productionQueue.clear();
                }
                if (!building.getBuilding().shouldDestroyOnReset && !hardReset || isSandbox) continue;
                building.destroy((ServerLevel)building.getLevel());
            }
            if (!isSandbox) {
                BuildingServerEvents.getBuildings().removeIf(b -> b.getBuilding().shouldDestroyOnReset || hardReset);
            }
            for (BuildingPlacement building : BuildingServerEvents.getBuildings()) {
                building.ownerName = "";
            }
            ResearchServerEvents.removeAllResearch();
            ResearchServerEvents.removeAllCheats();
            PlayerClientboundPacket.resetRTS(hardReset);
            if (!TutorialServerEvents.isEnabled()) {
                if (hardReset) {
                    PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.match_reset_hard", true, new Object[0]);
                } else {
                    PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.match_reset", true, new Object[0]);
                }
            }
            ResourcesServerEvents.resourcesList.clear();
            BuildingServerEvents.netherZones.forEach(NetherZone::startRestoring);
            PlayerServerEvents.saveRTSPlayers();
            BuildingServerEvents.saveBuildings(serverLevel);
            BuildingServerEvents.saveNetherZones(serverLevel);
            UnitServerEvents.saveGatherTargets(serverLevel);
            ResourcesServerEvents.saveResources(serverLevel);
            ResearchServerEvents.saveResearch();
            if (rtsLocked) {
                PlayerServerEvents.setRTSLock(false);
            }
            AlliancesServerEvents.resetAllAlliances();
            SurvivalServerEvents.reset();
        }
        HeroClientEvents.fallenHeroes.clear();
        for (ServerPlayer player : serverLevel.m_6907_()) {
            player.m_143403_(GameType.SPECTATOR);
        }
        playerDefaultGameModes.replaceAll((key, oldValue) -> GameType.SPECTATOR);
    }

    public static void setRTSLock(boolean lock) {
        PlayerServerEvents.setRTSLock(lock, false);
    }

    public static void setRTSLock(boolean lock, boolean noMsg) {
        rtsLocked = lock;
        serverLevel.m_6907_().forEach(p -> {
            if (rtsLocked) {
                PlayerClientboundPacket.lockRTS(p.m_7755_().getString());
            } else {
                PlayerClientboundPacket.unlockRTS(p.m_7755_().getString());
            }
        });
        if (!noMsg) {
            if (rtsLocked) {
                PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.match_locked");
            } else {
                PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.match_unlocked");
            }
        }
    }

    public static void setRTSSyncingEnabled(boolean enable) {
        rtsSyncingEnabled = enable;
        if (rtsSyncingEnabled) {
            PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.sync_enabled");
        } else {
            PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.sync_disabled");
        }
    }
}

