/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.research;

import com.mojang.datafixers.util.Pair;
import com.solegendary.reignofnether.ReignOfNether;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;

public class ResearchSaveData
extends SavedData {
    public final ArrayList<Pair<String, ResourceLocation>> researchItems = new ArrayList();

    private static ResearchSaveData create() {
        return new ResearchSaveData();
    }

    @Nonnull
    public static ResearchSaveData getInstance(LevelAccessor level) {
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return ResearchSaveData.create();
        }
        return (ResearchSaveData)server.m_129783_().m_8895_().m_164861_(ResearchSaveData::load, ResearchSaveData::create, "saved-research-data");
    }

    public static ResearchSaveData load(CompoundTag tag) {
        ReignOfNether.LOGGER.info("ResearchSaveData.load");
        ResearchSaveData data = ResearchSaveData.create();
        ListTag ltag = (ListTag)tag.m_128423_("researchItems");
        if (ltag != null) {
            for (Tag ctag : ltag) {
                ResourceLocation researchKey;
                CompoundTag btag = (CompoundTag)ctag;
                String ownerName = btag.m_128461_("ownerName");
                if (btag.m_128441_("researchKey")) {
                    researchKey = ResourceLocation.m_135820_((String)btag.m_128461_("researchKey"));
                } else {
                    String researchName = btag.m_128461_("researchName");
                    researchKey = ResearchSaveData.translateOldData(researchName);
                }
                data.researchItems.add((Pair<String, ResourceLocation>)new Pair((Object)ownerName, (Object)researchKey));
                ReignOfNether.LOGGER.info("ResearchSaveData.load: " + ownerName + "|" + researchKey.toString());
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        this.researchItems.forEach((Consumer<Pair<String, ResourceLocation>>)((Consumer<Pair>)b -> {
            CompoundTag cTag = new CompoundTag();
            cTag.m_128359_("ownerName", (String)b.getFirst());
            cTag.m_128359_("researchKey", ((ResourceLocation)b.getSecond()).toString());
            list.add((Object)cTag);
        }));
        tag.m_128365_("researchItems", (Tag)list);
        return tag;
    }

    public void save() {
        this.m_77762_();
    }

    private static ResourceLocation translateOldData(String researchName) {
        String newName = switch (researchName) {
            case "Iron Beacon" -> "beacon_level_1";
            case "Gold Beacon" -> "beacon_level_2";
            case "Emerald Beacon" -> "beacon_level_3";
            case "Diamond Beacon" -> "beacon_level_4";
            case "Netherite Beacon" -> "beacon_level_5";
            case "Walls of Fire" -> "blaze_firewall";
            case "Shield Tactics" -> "brute_shields";
            case "Officer's Quarters" -> "castle_flag";
            case "Drowned Zombies" -> "drowned";
            case "Vexing Summons" -> "evoker_vexes";
            case "Husk Zombies" -> "husks";
            case "Lightning Rod" -> "lab_lightning_rod";
            case "Multishot Crossbows" -> "pillager_crossbows";
            case "Civilian Portal" -> "portal_for_civilian";
            case "Military Portal" -> "portal_for_military";
            case "Transport Portal" -> "portal_for_transport";
            case "Ravager Artillery" -> "ravager_cavalry";
            case "Worker Carry Bags" -> "resource_capacity";
            case "Infested Defences" -> "silverfish";
            case "Slimy Conversion" -> "slime_conversion";
            case "Sticky Webbing" -> "spider_webs";
            case "Stray Skeletons" -> "strays";
            case "Diamond Axes" -> "vindicator_axes";
            case "Wither Death Clouds" -> "wither_clouds";
            default -> researchName.toLowerCase().replace(' ', '_');
        };
        return new ResourceLocation("reignofnether", newName);
    }
}

