/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.resources;

import com.solegendary.reignofnether.registrars.BlockRegistrar;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.ResourceSource;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;

public class ResourceSources {
    public static final List<Predicate<BlockState>> CLEAR_MATERIALS = List.of(s -> s.m_60819_().m_205070_(FluidTags.f_13131_), s -> s.m_60795_(), s -> s.m_204336_(BlockTags.f_13035_), s -> s.m_60734_() instanceof IPlantable);
    public static final List<Block> GATHERABLE_PLANTS = List.of(Blocks.f_50685_, Blocks.f_50073_, Blocks.f_50072_);
    public static final int TICKS_PER_SECOND = 20;
    public static final int REPLANT_TICKS_MAX = 10;
    public static final ResourceSource GENERIC_LOG_BLOCK = new ResourceSource("Unknown Logs", List.of(), List.of(Items.f_41837_), 240, 15, ResourceName.WOOD);
    public static final ResourceSource GENERIC_LEAVES_BLOCK = new ResourceSource("Unknown Leaves", List.of(), List.of(Items.f_41896_), 8, 1, ResourceName.WOOD);
    public static final List<ResourceSource> FOOD_BLOCKS = List.of(new ResourceSource("Sugar", List.of(), List.of(Items.f_42501_), 0, 1, ResourceName.FOOD), new ResourceSource("Farmland", List.of(Blocks.f_50093_), List.of(), 0, 0, ResourceName.FOOD, bs -> (Integer)bs.m_61143_((Property)BlockStateProperties.f_61423_) == 7), new ResourceSource("Soul Sand", List.of(Blocks.f_50135_), List.of(), 0, 0, ResourceName.FOOD), new ResourceSource("Wheat", List.of(Blocks.f_50092_), List.of(Items.f_42405_), 40, 4, ResourceName.FOOD, bs -> (Integer)bs.m_61143_((Property)BlockStateProperties.f_61409_) == 7), new ResourceSource("Netherwart", List.of(Blocks.f_50200_), List.of(Items.f_42588_), 40, 5, ResourceName.FOOD, bs -> (Integer)bs.m_61143_((Property)BlockStateProperties.f_61407_) == 3), new ResourceSource("Gourds", List.of(Blocks.f_50186_, Blocks.f_50133_, Blocks.f_50143_), List.of(Items.f_42028_, Items.f_42046_, Items.f_42047_), 80, 6, ResourceName.FOOD), new ResourceSource("Carrots", List.of(Blocks.f_50249_), List.of(Items.f_42619_), 40, 5, ResourceName.FOOD, bs -> (Integer)bs.m_61143_((Property)BlockStateProperties.f_61409_) == 7), new ResourceSource("Potatoes", List.of(Blocks.f_50250_), List.of(Items.f_42620_, Items.f_42674_), 40, 6, ResourceName.FOOD, bs -> (Integer)bs.m_61143_((Property)BlockStateProperties.f_61409_) == 7), new ResourceSource("Beetroots", List.of(Blocks.f_50444_), List.of(Items.f_42732_), 40, 5, ResourceName.FOOD, bs -> (Integer)bs.m_61143_((Property)BlockStateProperties.f_61407_) == 3), new ResourceSource("Mushrooms", List.of(Blocks.f_50073_, Blocks.f_50072_), List.of(Items.f_41953_, Items.f_41952_), 100, 22, ResourceName.FOOD), new ResourceSource("Misc. Forageable", List.of(Blocks.f_50130_, Blocks.f_50685_), List.of(Items.f_42780_, Items.f_41909_), 100, 20, ResourceName.FOOD), new ResourceSource("Mushroom Stem", List.of(Blocks.f_50182_), List.of(Items.f_42024_), 200, 10, ResourceName.FOOD), new ResourceSource("Red Mushroom Block", List.of(Blocks.f_50181_), List.of(Items.f_42023_), 200, 10, ResourceName.FOOD), new ResourceSource("Brown Mushroom Block", List.of(Blocks.f_50180_), List.of(Items.f_42022_), 200, 10, ResourceName.FOOD), new ResourceSource("Bee nest", List.of(Blocks.f_50717_), List.of(Items.f_42785_), 200, 100, ResourceName.FOOD), new ResourceSource("Shroomlight", List.of(Blocks.f_50701_), List.of(Items.f_42783_), 200, 120, ResourceName.FOOD), new ResourceSource("Extra large food item", List.of(), List.of(Items.f_42580_, Items.f_42582_, Items.f_42486_, Items.f_42698_, Items.f_42581_, Items.f_42659_, Items.f_42502_, Items.f_42687_, Items.f_42699_, Items.f_42437_), 0, 75, ResourceName.FOOD), new ResourceSource("Large food item", List.of(), List.of(Items.f_42579_, Items.f_42485_, Items.f_42658_, Items.f_42697_, Items.f_42400_, Items.f_42734_, Items.f_42436_, Items.f_42677_), 0, 50, ResourceName.FOOD), new ResourceSource("Medium food item", List.of(), List.of(Items.f_42454_, Items.f_42521_, Items.f_42410_, Items.f_42406_, Items.f_42787_, Items.f_42526_, Items.f_42530_, Items.f_42527_, Items.f_42531_, Items.f_151079_), 0, 25, ResourceName.FOOD), new ResourceSource("Small food item", List.of(), List.of(Items.f_42583_, Items.f_42575_, Items.f_42591_, Items.f_42675_), 0, 5, ResourceName.FOOD));
    public static final List<ResourceSource> WOOD_BLOCKS = List.of(new ResourceSource("Stick", List.of(), List.of(Items.f_42398_), 0, 1, ResourceName.WOOD), new ResourceSource("Saplings", List.of(), List.of(Items.f_41827_, Items.f_42800_, Items.f_42801_, Items.f_42799_, Items.f_42799_, Items.f_41828_, Items.f_41826_), 0, 5, ResourceName.WOOD), new ResourceSource("Logs", List.of(Blocks.f_49999_, Blocks.f_50001_, Blocks.f_50003_, Blocks.f_50004_, Blocks.f_50002_, Blocks.f_220832_, Blocks.f_50000_, (Block)BlockRegistrar.FALLING_OAK_LOG.get(), (Block)BlockRegistrar.FALLING_BIRCH_LOG.get(), (Block)BlockRegistrar.FALLING_ACACIA_LOG.get(), (Block)BlockRegistrar.FALLING_DARK_OAK_LOG.get(), (Block)BlockRegistrar.FALLING_JUNGLE_LOG.get(), (Block)BlockRegistrar.FALLING_MANGROVE_LOG.get(), (Block)BlockRegistrar.FALLING_SPRUCE_LOG.get(), Blocks.f_50011_, Blocks.f_50013_, Blocks.f_50015_, Blocks.f_50043_, Blocks.f_50014_, Blocks.f_220836_, Blocks.f_50012_), List.of(Items.f_41837_, Items.f_41839_, Items.f_41841_, Items.f_41842_, Items.f_41840_, Items.f_220179_, Items.f_41838_, Items.f_41888_, Items.f_41890_, Items.f_41892_, Items.f_41893_, Items.f_41891_, Items.f_220177_, Items.f_41889_), 240, 15, ResourceName.WOOD), new ResourceSource("Roots", List.of(Blocks.f_220834_, Blocks.f_220833_), List.of(Items.f_220181_, Items.f_220180_), 240, 15, ResourceName.WOOD), new ResourceSource("Nether Logs", List.of(Blocks.f_50695_, Blocks.f_50686_, Blocks.f_50697_, Blocks.f_50688_, (Block)BlockRegistrar.FALLING_WARPED_STEM.get(), (Block)BlockRegistrar.FALLING_CRIMSON_STEM.get()), List.of(Items.f_41843_, Items.f_41844_, Items.f_41894_, Items.f_41895_), 240, 17, ResourceName.WOOD), new ResourceSource("Leaves", List.of(Blocks.f_50054_, Blocks.f_152470_, Blocks.f_50052_, Blocks.f_152471_, Blocks.f_50053_, Blocks.f_50055_, Blocks.f_220838_, Blocks.f_50050_, Blocks.f_50051_, (Block)BlockRegistrar.DECAYABLE_NETHER_WART_BLOCK.get(), (Block)BlockRegistrar.DECAYABLE_NETHER_WART_BLOCK.get()), List.of(Items.f_41900_, Items.f_151009_, Items.f_41898_, Items.f_186362_, Items.f_41899_, Items.f_41901_, Items.f_220178_, Items.f_41896_, Items.f_41897_), 8, 1, ResourceName.WOOD));
    public static final List<ResourceSource> ORE_BLOCKS = List.of(new ResourceSource("Stone", List.of(), List.of(Items.f_41905_), 0, 1, ResourceName.ORE), new ResourceSource("Dripstone", List.of(Blocks.f_152588_), List.of(Items.f_151087_), 20, 1, ResourceName.ORE), new ResourceSource("Tier 1 Nether Ores", List.of(Blocks.f_50331_), List.of(Items.f_42692_), 900, 60, ResourceName.ORE), new ResourceSource("Tier 2 Nether Ores", List.of(Blocks.f_49998_), List.of(Items.f_41836_), 900, 78, ResourceName.ORE), new ResourceSource("Tier 3 Nether Ores", List.of(Blocks.f_50706_), List.of(Items.f_42758_), 900, 96, ResourceName.ORE), new ResourceSource("Tier 4 Nether Ores", List.of(Blocks.f_50722_), List.of(Items.f_42792_), 900, 120, ResourceName.ORE), new ResourceSource("Tier 1 Ores", List.of(Blocks.f_49997_, Blocks.f_152469_), List.of(Items.f_42413_), 900, 50, ResourceName.ORE), new ResourceSource("Tier 2 Ores", List.of(Blocks.f_152505_, Blocks.f_152506_, Blocks.f_49996_, Blocks.f_50059_, Blocks.f_50173_, Blocks.f_152468_, Blocks.f_152472_, Blocks.f_152473_), List.of(Items.f_151050_, Items.f_151051_, Items.f_42534_, Items.f_42451_), 900, 65, ResourceName.ORE), new ResourceSource("Tier 3 Ores", List.of(Blocks.f_49995_, Blocks.f_50264_, Blocks.f_152467_, Blocks.f_152479_), List.of(Items.f_151053_, Items.f_42616_), 900, 80, ResourceName.ORE), new ResourceSource("Tier 4 Ores", List.of(Blocks.f_50089_, Blocks.f_152474_), List.of(Items.f_42415_), 900, 100, ResourceName.ORE));

    public static boolean isClearMaterial(BlockState state) {
        for (Predicate<BlockState> predicate : CLEAR_MATERIALS) {
            if (!predicate.test(state)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHuntableAnimal(LivingEntity entity) {
        if (!(entity instanceof Animal)) {
            return false;
        }
        return ResourceSources.getFoodItemsFromAnimal((Animal)entity).size() != 0;
    }

    public static ResourceSource getFromBlockPos(BlockPos bp, Level level) {
        BlockState bs = level.m_8055_(bp);
        Block block = bs.m_60734_();
        for (List<ResourceSource> resourceSources : List.of(FOOD_BLOCKS, WOOD_BLOCKS, ORE_BLOCKS)) {
            for (ResourceSource resourceSource : resourceSources) {
                if (!resourceSource.validBlocks.contains(block)) continue;
                return resourceSource;
            }
        }
        if (bs.m_204343_().collect(Collectors.toSet()).contains(BlockTags.f_13106_)) {
            return GENERIC_LOG_BLOCK;
        }
        if (bs.m_204343_().collect(Collectors.toSet()).contains(BlockTags.f_13035_)) {
            return GENERIC_LEAVES_BLOCK;
        }
        return null;
    }

    public static ResourceSource getFromBlockState(BlockState bs) {
        for (List<ResourceSource> resourceSources : List.of(FOOD_BLOCKS, WOOD_BLOCKS, ORE_BLOCKS)) {
            for (ResourceSource resourceSource : resourceSources) {
                if (!resourceSource.validBlocks.contains(bs.m_60734_())) continue;
                return resourceSource;
            }
        }
        if (bs.m_204343_().collect(Collectors.toSet()).contains(BlockTags.f_13106_)) {
            return GENERIC_LOG_BLOCK;
        }
        if (bs.m_204343_().collect(Collectors.toSet()).contains(BlockTags.f_13035_)) {
            return GENERIC_LEAVES_BLOCK;
        }
        return null;
    }

    public static ResourceName getBlockResourceName(BlockPos bp, Level level) {
        Block block = level.m_8055_(bp).m_60734_();
        if (block == Blocks.f_50093_) {
            return ResourceName.FOOD;
        }
        ResourceSource resBlock = ResourceSources.getFromBlockPos(bp, level);
        if (resBlock != null) {
            return resBlock.resourceName;
        }
        return ResourceName.NONE;
    }

    public static ResourceSource getFromItem(Item item) {
        for (List<ResourceSource> resourceSources : List.of(FOOD_BLOCKS, WOOD_BLOCKS, ORE_BLOCKS)) {
            for (ResourceSource resourceSource : resourceSources) {
                if (!resourceSource.items.contains(item)) continue;
                return resourceSource;
            }
        }
        return null;
    }

    public static List<ItemStack> getFoodItemsFromAnimal(Animal animal) {
        if (animal instanceof PolarBear) {
            return List.of(new ItemStack((ItemLike)Items.f_42527_, 12));
        }
        if (animal instanceof Cow) {
            return List.of(new ItemStack((ItemLike)Items.f_42579_, 2), new ItemStack((ItemLike)Items.f_42454_, 2));
        }
        if (animal instanceof Pig) {
            return List.of(new ItemStack((ItemLike)Items.f_42485_, 3));
        }
        if (animal instanceof Goat) {
            return List.of(new ItemStack((ItemLike)Items.f_42658_, 2), new ItemStack((ItemLike)Items.f_42454_, 2));
        }
        if (animal instanceof Sheep) {
            return List.of(new ItemStack((ItemLike)Items.f_42658_, 2), new ItemStack((ItemLike)Items.f_42454_, 1));
        }
        if (animal instanceof Chicken) {
            return List.of(new ItemStack((ItemLike)Items.f_42581_, 1));
        }
        if (animal instanceof Rabbit) {
            return List.of(new ItemStack((ItemLike)Items.f_42697_, 1));
        }
        if (animal instanceof Horse) {
            return List.of(new ItemStack((ItemLike)Items.f_42454_, 2));
        }
        if (animal instanceof Donkey) {
            return List.of(new ItemStack((ItemLike)Items.f_42454_, 2));
        }
        if (animal instanceof Mule) {
            return List.of(new ItemStack((ItemLike)Items.f_42454_, 2));
        }
        return List.of();
    }
}

