/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.startpos;

import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.startpos.StartPos;
import com.solegendary.reignofnether.startpos.StartPosAction;
import com.solegendary.reignofnether.startpos.StartPosClientboundPacket;
import com.solegendary.reignofnether.startpos.StartPosServerEvents;
import com.solegendary.reignofnether.util.Faction;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class StartPosServerboundPacket {
    StartPosAction action;
    BlockPos blockPos;
    Faction faction;
    String playerName;

    public static void reservePos(BlockPos pos, Faction faction, String playerName) {
        PacketHandler.INSTANCE.sendToServer((Object)new StartPosServerboundPacket(StartPosAction.RESERVE, pos, faction, playerName));
    }

    public static void unreservePos(BlockPos pos) {
        PacketHandler.INSTANCE.sendToServer((Object)new StartPosServerboundPacket(StartPosAction.UNRESERVE, pos, Faction.NONE, ""));
    }

    public StartPosServerboundPacket(StartPosAction action, BlockPos pos, Faction faction, String playerName) {
        this.action = action;
        this.blockPos = pos;
        this.faction = faction;
        this.playerName = playerName;
    }

    public StartPosServerboundPacket(FriendlyByteBuf buffer) {
        this.action = (StartPosAction)buffer.m_130066_(StartPosAction.class);
        this.blockPos = buffer.m_130135_();
        this.faction = (Faction)buffer.m_130066_(Faction.class);
        this.playerName = buffer.m_130277_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.action);
        buffer.m_130064_(this.blockPos);
        buffer.m_130068_((Enum)this.faction);
        buffer.m_130070_(this.playerName);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            block0 : switch (this.action) {
                case RESERVE: {
                    for (StartPos startPos : StartPosServerEvents.startPoses) {
                        if (!startPos.pos.equals((Object)this.blockPos)) continue;
                        startPos.faction = this.faction;
                        startPos.playerName = this.playerName;
                        StartPosClientboundPacket.reservePos(this.blockPos, this.faction, this.playerName);
                        break block0;
                    }
                    break;
                }
                case UNRESERVE: {
                    for (StartPos startPos : StartPosServerEvents.startPoses) {
                        if (!startPos.pos.equals((Object)this.blockPos)) continue;
                        startPos.faction = this.faction;
                        StartPosClientboundPacket.unreservePos(this.blockPos);
                        break block0;
                    }
                    break;
                }
            }
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

