/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit;

import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.MyRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class NonUnitClientEvents {
    private static final Minecraft MC = Minecraft.m_91087_();
    public static boolean isMoveCheckpointGreen = true;

    public static boolean canControlNonUnits() {
        return NonUnitClientEvents.MC.f_91074_ != null && ResearchClient.hasCheat("wouldyoukindly");
    }

    public static boolean canAttack(LivingEntity le) {
        if (le instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)le;
            if (mob.m_21204_().m_22171_(Attributes.f_22281_) || mob.m_21204_().m_22171_(Attributes.f_22283_)) {
                return true;
            }
            for (WrappedGoal wrappedGoal : mob.f_21345_.m_148105_()) {
                if (!(wrappedGoal.m_26015_() instanceof NearestAttackableTargetGoal)) continue;
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent evt) {
        if (NonUnitClientEvents.MC.f_91073_ == null) {
            return;
        }
        if (OrthoviewClientEvents.isEnabled() && evt.getStage() == RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS) {
            for (LivingEntity le : UnitClientEvents.getSelectedUnits()) {
                if (!(le instanceof PathfinderMob)) continue;
                PathfinderMob mob = (PathfinderMob)le;
                if (le instanceof Unit || !le.m_6084_() || le.m_213877_()) continue;
                float entityYOffset = 1.74f - le.m_20192_() - 1.0f;
                Vec3 firstPos = le.m_146892_().m_82520_(0.0, (double)entityYOffset, 0.0);
                if (mob.m_5448_() != null && !mob.m_5448_().m_21224_()) {
                    MyRenderer.drawLine(evt.getPoseStack(), firstPos, mob.m_5448_().m_146892_(), 1.0f, 0.0f, 0.0f, 0.5f);
                    continue;
                }
                if (!mob.m_21573_().m_26571_() && mob.m_21573_().m_26567_() != null) {
                    double dist = Math.sqrt(mob.m_20238_(Vec3.m_82512_((Vec3i)mob.m_21573_().m_26567_())));
                    float a = (float)Math.min(1.0, dist / 4.0) - 0.2f;
                    if (!(a > 0.0f)) continue;
                    BlockPos bp = mob.m_21573_().m_26567_().m_7495_();
                    Vec3 pos = new Vec3((double)((float)bp.m_123341_() + 0.5f), (double)((float)bp.m_123342_() + 1.0f), (double)((float)bp.m_123343_() + 0.5f));
                    MyRenderer.drawLine(evt.getPoseStack(), firstPos, pos, isMoveCheckpointGreen ? 0.0f : 1.0f, isMoveCheckpointGreen ? 1.0f : 0.0f, 0.0f, a);
                    if (NonUnitClientEvents.MC.f_91073_.m_8055_(bp.m_7918_(0, 1, 0)).m_60734_() instanceof SnowLayerBlock) {
                        AABB aabb = new AABB(bp);
                        aabb = aabb.m_165893_(aabb.f_82292_ + (double)0.13f);
                        MyRenderer.drawSolidBox(evt.getPoseStack(), aabb, Direction.UP, isMoveCheckpointGreen ? 0.0f : 1.0f, isMoveCheckpointGreen ? 1.0f : 0.0f, 0.0f, a * 0.5f, new ResourceLocation("forge:textures/white.png"));
                        continue;
                    }
                    MyRenderer.drawBlockFace(evt.getPoseStack(), Direction.UP, bp, isMoveCheckpointGreen ? 0.0f : 1.0f, isMoveCheckpointGreen ? 1.0f : 0.0f, 0.0f, a * 0.5f);
                    continue;
                }
                mob.m_21573_().m_26573_();
                mob.m_6710_(null);
            }
        }
    }
}

