/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.controls;

import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.monster.Slime;

public class SlimeUnitMoveControl
extends MoveControl {
    private float yRot;
    private int jumpDelay;
    private final Slime slime;
    private boolean isAggressive;
    private static final Random RANDOM = new Random();

    public SlimeUnitMoveControl(Slime pSlime) {
        super((Mob)pSlime);
        this.slime = pSlime;
        this.yRot = 180.0f * pSlime.m_146908_() / (float)Math.PI;
    }

    public void setDirection(float pYRot, boolean pAggressive) {
        this.yRot = pYRot;
        this.isAggressive = pAggressive;
    }

    public void setWantedMovement(double pSpeed) {
        this.f_24978_ = pSpeed;
        this.f_24981_ = MoveControl.Operation.MOVE_TO;
    }

    private static int getJumpDelay() {
        return 20;
    }

    private float getSoundVolume() {
        return 0.4f * (float)this.slime.m_33632_();
    }

    private float getSoundPitch() {
        float f = this.slime.m_33633_() ? 1.4f : 0.8f;
        return ((RANDOM.nextFloat() - RANDOM.nextFloat()) * 0.2f + 1.0f) * f;
    }

    protected SoundEvent getJumpSound() {
        return this.slime.m_33633_() ? SoundEvents.f_12469_ : SoundEvents.f_12387_;
    }

    public void m_8126_() {
        this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
        this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
        this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
        if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
            this.f_24974_.m_21564_(0.0f);
        } else {
            this.f_24981_ = MoveControl.Operation.WAIT;
            if (this.f_24974_.m_20096_()) {
                this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                if (this.jumpDelay-- <= 0) {
                    this.jumpDelay = SlimeUnitMoveControl.getJumpDelay();
                    if (this.isAggressive) {
                        this.jumpDelay /= 3;
                    }
                    this.slime.m_21569_().m_24901_();
                    if (this.slime.m_33632_() > 0) {
                        this.slime.m_5496_(this.getJumpSound(), this.getSoundVolume(), this.getSoundPitch());
                    }
                } else {
                    this.slime.f_20900_ = 0.0f;
                    this.slime.f_20902_ = 0.0f;
                    this.f_24974_.m_7910_(0.0f);
                }
            } else {
                this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
            }
        }
        Slime slime = this.slime;
        if (slime instanceof Unit) {
            Unit unit = (Unit)slime;
            BlockPos bp = ((Mob)unit).m_21573_().m_26567_();
            if (bp != null) {
                double d0 = (double)bp.m_123341_() - this.slime.m_20185_();
                double d2 = (double)bp.m_123343_() - this.slime.m_20189_();
                double d1 = (double)bp.m_123342_() - this.slime.m_20188_();
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.slime.m_146922_(this.m_24991_(this.slime.m_146908_(), f, 10.0f));
                this.setDirection(this.slime.m_146908_(), true);
            } else {
                LivingEntity targetEntity = this.slime.m_5448_();
                if (targetEntity != null) {
                    this.slime.m_21391_((Entity)targetEntity, 10.0f, 10.0f);
                }
                this.setDirection(this.slime.m_146908_(), true);
            }
        }
    }
}

