/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.goals;

import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.monsters.SlimeUnit;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;

public abstract class AbstractMeleeAttackUnitGoal
extends Goal {
    protected final Mob mob;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    protected int ticksUntilNextPathRecalculation;
    protected final int tickPathRecalcMax = 5;
    protected int ticksUntilNextAttack;
    private long lastCanUseCheck;

    public AbstractMeleeAttackUnitGoal(Mob mob, boolean followingTargetEvenIfNotSeen) {
        this.mob = mob;
        this.followingTargetEvenIfNotSeen = followingTargetEvenIfNotSeen;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void tickAttackCooldown() {
        if (this.ticksUntilNextAttack > ((AttackerUnit)this.mob).getAttackCooldown()) {
            this.ticksUntilNextAttack = this.getAttackInterval();
        }
        if (this.ticksUntilNextAttack > 0) {
            --this.ticksUntilNextAttack;
        }
    }

    public boolean m_8036_() {
        long i = this.mob.m_9236_().m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
    }

    public boolean m_8045_() {
        boolean canContinue;
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.m_21573_().m_26571_();
        }
        if (!this.mob.m_21444_(livingentity.m_20183_())) {
            return false;
        }
        boolean bl = canContinue = !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
        if (canContinue) {
            this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
            this.mob.m_21573_().m_26536_(this.path, (double)Unit.getSpeedModifier((Unit)this.mob));
        }
        return canContinue;
    }

    public void m_8056_() {
        if (!((Unit)this.mob).getHoldPosition()) {
            this.mob.m_21573_().m_26536_(this.path, (double)Unit.getSpeedModifier((Unit)this.mob));
        }
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (!EntitySelector.f_20406_.test(livingentity)) {
            this.mob.m_6710_(null);
        }
        this.mob.m_21561_(false);
        this.mob.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null) {
            this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            double distSqr = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            if (distSqr < this.getAttackReachSqr(target)) {
                this.mob.m_21573_().m_26573_();
            } else if (!((Unit)this.mob).getHoldPosition()) {
                if (this.ticksUntilNextPathRecalculation <= 0) {
                    Path path = this.mob.m_21573_().m_26524_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 0);
                    this.mob.m_21573_().m_26536_(path, (double)Unit.getSpeedModifier((Unit)this.mob));
                    this.ticksUntilNextPathRecalculation = distSqr < 16.0 ? 5 : (distSqr < 64.0 ? 10 : 20);
                } else {
                    --this.ticksUntilNextPathRecalculation;
                }
            }
            this.checkAndPerformAttack(target, distSqr);
        }
    }

    public void checkAndPerformAttackIgnoreDist(LivingEntity target) {
        this.checkAndPerformAttack(target, 0.0);
    }

    protected void checkAndPerformAttack(LivingEntity target, double distSqr) {
        double d = this.getAttackReachSqr(target);
        if (distSqr <= d && this.ticksUntilNextAttack <= 0) {
            this.ticksUntilNextAttack = this.m_183277_(this.getAttackInterval());
            this.mob.m_6674_(InteractionHand.MAIN_HAND);
            this.mob.m_7327_((Entity)target);
        }
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return this.m_183277_(((AttackerUnit)this.mob).getAttackCooldown());
    }

    protected double getAttackReachSqr(LivingEntity target) {
        float width = this.mob.m_20205_();
        Mob mob = this.mob;
        if (mob instanceof SlimeUnit) {
            SlimeUnit slime = (SlimeUnit)mob;
            width -= 0.3f * (float)(Math.max(2, slime.m_33632_()) - 2);
        }
        float targetWidth = target.m_20205_();
        if (target instanceof SlimeUnit) {
            SlimeUnit targetSlime = (SlimeUnit)target;
            targetWidth += 0.3f * (float)(Math.max(2, targetSlime.m_33632_()) - 2);
        }
        return width * 2.0f * width * 2.0f + targetWidth;
    }
}

