/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.goals;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.AbilityClientboundPacket;
import com.solegendary.reignofnether.unit.UnitAnimationAction;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.packets.UnitAnimationClientboundPacket;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class GenericUntargetedSpellGoal
extends Goal {
    private final LivingEntity mob;
    private Ability ability;
    private int ticksCasting = 0;
    public final int channelTicksMax;
    private boolean isCasting = false;
    private final Runnable onCast;
    private final UnitAnimationAction startAnimation;
    private final UnitAnimationAction stopAnimation;
    private final UnitAnimationAction castAnimation;

    public boolean isCasting() {
        return this.isCasting;
    }

    public GenericUntargetedSpellGoal(LivingEntity mob, int channelTime, Runnable onCast, UnitAnimationAction startAnimation, UnitAnimationAction stopAnimation, UnitAnimationAction castAnimation) {
        this.mob = mob;
        this.channelTicksMax = channelTime;
        this.onCast = onCast;
        this.startAnimation = startAnimation;
        this.stopAnimation = stopAnimation;
        this.castAnimation = castAnimation;
    }

    public GenericUntargetedSpellGoal(LivingEntity mob, int channelTime, Runnable onCast, UnitAnimationAction startAnimation, UnitAnimationAction stopAnimation) {
        this(mob, channelTime, onCast, startAnimation, stopAnimation, null);
    }

    public void setAbility(Ability ability) {
        this.ability = ability;
    }

    public void m_8037_() {
        if (this.isCasting) {
            ++this.ticksCasting;
            if (this.ticksCasting >= this.channelTicksMax) {
                if (!this.mob.m_9236_().m_5776_()) {
                    if (this.castAnimation != null) {
                        UnitAnimationClientboundPacket.sendBasicPacket(this.castAnimation, this.mob);
                    }
                    this.onCast.run();
                }
                if (this.ability != null && !this.mob.m_9236_().m_5776_()) {
                    if (!this.mob.m_9236_().m_5776_()) {
                        AbilityClientboundPacket.sendSetCooldownPacket(this.mob.m_19879_(), this.ability.action, this.ability.cooldownMax);
                    } else {
                        LivingEntity livingEntity = this.mob;
                        if (livingEntity instanceof Unit) {
                            Unit unit = (Unit)livingEntity;
                            this.ability.setToMaxCooldown();
                        }
                    }
                }
                this.ticksCasting = 0;
                this.isCasting = false;
            }
        }
    }

    public boolean m_8036_() {
        return true;
    }

    public void startCasting() {
        this.isCasting = true;
        if (!this.mob.m_9236_().m_5776_()) {
            UnitAnimationClientboundPacket.sendBasicPacket(this.startAnimation, this.mob);
        }
    }

    public void m_8041_() {
        this.ticksCasting = 0;
        this.isCasting = false;
        if (!this.mob.m_9236_().m_5776_()) {
            UnitAnimationClientboundPacket.sendBasicPacket(this.stopAnimation, this.mob);
        }
    }
}

