/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.interfaces;

import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.hero.HeroClientEvents;
import com.solegendary.reignofnether.hero.HeroClientboundPacket;
import com.solegendary.reignofnether.hero.HeroServerEvents;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.sounds.SoundAction;
import com.solegendary.reignofnether.sounds.SoundClientboundPacket;
import com.solegendary.reignofnether.unit.HeroUnitSave;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.jetbrains.annotations.NotNull;

public interface HeroUnit
extends Unit {
    public static final int FOOD_REVIVE_COST_BASE = 100;
    public static final int FOOD_REVIVE_COST_PER_LEVEL = 50;
    public static final int REVIVE_SECONDS_BASE = 30;
    public static final int REVIVE_SECONDS_PER_LEVEL = 5;
    public static final int POP_COST = 5;
    public static final int MAX_HERO_LEVEL = 10;

    public static ResourceCost getReviveCost(int heroLevel) {
        return ResourceCost.Unit(100 + Mth.m_14045_((int)heroLevel, (int)1, (int)10) * 50, 0, 0, 30 + Mth.m_14045_((int)heroLevel, (int)1, (int)10) * 5, 5);
    }

    public static List<HeroUnit> getHeroes(boolean isClientside) {
        ArrayList<LivingEntity> units = isClientside ? UnitClientEvents.getAllUnits() : UnitServerEvents.getAllUnits();
        return units.stream().filter(e -> e instanceof HeroUnit).map(e -> (HeroUnit)e).toList();
    }

    public static List<HeroUnit> getHeroes(boolean isClientside, String ownerName) {
        return HeroUnit.getHeroes(isClientside, ownerName, "");
    }

    public static List<HeroUnit> getHeroes(boolean isClientside, String ownerName, String unitName) {
        ArrayList<LivingEntity> units = isClientside ? UnitClientEvents.getAllUnits() : UnitServerEvents.getAllUnits();
        return units.stream().filter(e -> {
            HeroUnit heroUnit;
            return e instanceof HeroUnit && (heroUnit = (HeroUnit)e).getOwnerName().equals(ownerName) && (e.m_7755_().getString().equals(unitName) || unitName.isBlank());
        }).map(e -> (HeroUnit)e).toList();
    }

    @Nullable
    public static HeroUnitSave getFallenHero(boolean isClientSide, String ownerName, String heroName) {
        ArrayList<HeroUnitSave> heroUnits = isClientSide ? HeroClientEvents.fallenHeroes : HeroServerEvents.fallenHeroes;
        for (HeroUnitSave heroUnit : heroUnits) {
            if (!heroUnit.ownerName.equals(ownerName) || !heroUnit.name.equals(heroName)) continue;
            return heroUnit;
        }
        return null;
    }

    public float getHealthBonusPerLevel();

    public float getAttackBonusPerLevel();

    public float getBaseHealth();

    public float getBaseAttack();

    public int getSkillPoints();

    public void setSkillPoints(int var1);

    public boolean isRankUpMenuOpen();

    public void showRankUpMenu(boolean var1);

    public int getExperience();

    public void setExperience(int var1);

    default public int getChargesForSaveData() {
        return 0;
    }

    default public void setChargesFromSaveData(int charges) {
    }

    default public void setStatsForLevel() {
        this.setStatsForLevel(false);
    }

    default public void setStatsForLevel(boolean heal) {
        AttributeInstance aiAttackDamage;
        AttributeInstance aiMaxHealth = ((LivingEntity)this).m_21051_(Attributes.f_22276_);
        if (aiMaxHealth != null) {
            aiMaxHealth.m_22100_((double)(this.getBaseHealth() + (float)(this.getHeroLevel() - 1) * this.getHealthBonusPerLevel()));
        }
        if ((aiAttackDamage = ((LivingEntity)this).m_21051_(Attributes.f_22281_)) != null) {
            aiAttackDamage.m_22100_((double)(this.getBaseAttack() + (float)(this.getHeroLevel() - 1) * this.getAttackBonusPerLevel()));
        }
        if (heal) {
            ((LivingEntity)this).m_21153_(((LivingEntity)this).m_21233_());
        }
    }

    default public void addExperience(int amount) {
        if (((LivingEntity)this).m_9236_().m_5776_()) {
            return;
        }
        int levelBefore = this.getHeroLevel();
        if (levelBefore >= 10) {
            return;
        }
        this.setExperience(this.getExperience() + amount);
        int levelDiff = this.getHeroLevel() - levelBefore;
        HeroClientboundPacket.setExperience(((LivingEntity)this).m_19879_(), this.getExperience());
        if (levelDiff > 0) {
            this.setSkillPoints(this.getSkillPoints() + levelDiff);
            HeroClientboundPacket.setSkillPoints(((LivingEntity)this).m_19879_(), this.getSkillPoints());
            SoundClientboundPacket.playSoundAtPos(SoundAction.LEVEL_UP, ((LivingEntity)this).m_20097_());
            this.setStatsForLevel();
            ((LivingEntity)this).m_5634_((float)levelDiff * this.getHealthBonusPerLevel());
        }
    }

    default public int getHeroLevel() {
        return HeroUnit.getHeroLevel(this.getExperience());
    }

    public static int getHeroLevel(int exp) {
        int level = 0;
        int expToNextLevel = 200;
        while ((exp -= (expToNextLevel += 100)) > 0 && ++level < 10) {
        }
        return level;
    }

    default public int getExpOnCurrentLevel() {
        if (this.getHeroLevel() >= 10) {
            return 0;
        }
        int expToNextLevel = 200;
        int expCount = 0;
        int exp = this.getExperience();
        while (expCount < exp) {
            if (expCount + expToNextLevel > exp) {
                return exp - expCount;
            }
            expCount += expToNextLevel;
            expToNextLevel += 100;
        }
        return 0;
    }

    default public int getExpToNextlevel() {
        if (this.getHeroLevel() >= 10) {
            return 0;
        }
        return (this.getHeroLevel() + 1) * 100;
    }

    default public List<HeroAbility> getHeroAbilities() {
        return this.getAbilities().stream().filter(a -> a instanceof HeroAbility).map(a -> (HeroAbility)a).toList();
    }

    default public void addHeroUnitSaveData(@NotNull CompoundTag pCompound) {
        pCompound.m_128405_("experience", this.getExperience());
        pCompound.m_128405_("skillPoints", this.getSkillPoints());
        pCompound.m_128405_("charges", this.getChargesForSaveData());
        List<HeroAbility> abls = this.getHeroAbilities();
        pCompound.m_128405_("ability1Rank", abls.size() > 0 ? abls.get((int)0).rank : 0);
        pCompound.m_128405_("ability2Rank", abls.size() > 1 ? abls.get((int)1).rank : 0);
        pCompound.m_128405_("ability3Rank", abls.size() > 2 ? abls.get((int)2).rank : 0);
        pCompound.m_128405_("ability4Rank", abls.size() > 3 ? abls.get((int)3).rank : 0);
    }

    default public void readHeroUnitSaveData(@NotNull CompoundTag pCompound) {
        LivingEntity le = (LivingEntity)this;
        this.setExperience(pCompound.m_128451_("experience"));
        this.setSkillPoints(pCompound.m_128451_("skillPoints"));
        this.setChargesFromSaveData(pCompound.m_128451_("charges"));
        List<HeroAbility> abls = this.getHeroAbilities();
        if (abls.size() > 0) {
            abls.get((int)0).rank = pCompound.m_128451_("ability1Rank");
        }
        if (abls.size() > 1) {
            abls.get((int)1).rank = pCompound.m_128451_("ability2Rank");
        }
        if (abls.size() > 2) {
            abls.get((int)2).rank = pCompound.m_128451_("ability3Rank");
        }
        if (abls.size() > 3) {
            abls.get((int)3).rank = pCompound.m_128451_("ability4Rank");
        }
        for (HeroAbility abl : abls) {
            abl.updateStatsForRank();
        }
    }
}

