/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.monsters;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.abilities.MountSpider;
import com.solegendary.reignofnether.fogofwar.FogOfWarClientboundPacket;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.time.NightUtils;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.goals.GarrisonGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackBuildingGoal;
import com.solegendary.reignofnether.unit.goals.MountGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.RandomLookAroundUnitGoal;
import com.solegendary.reignofnether.unit.goals.ReturnResourcesGoal;
import com.solegendary.reignofnether.unit.goals.SelectedTargetGoal;
import com.solegendary.reignofnether.unit.goals.UnitBowAttackGoal;
import com.solegendary.reignofnether.unit.goals.UsePortalGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.ConvertableUnit;
import com.solegendary.reignofnether.unit.interfaces.RangedAttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SkeletonUnit
extends Skeleton
implements Unit,
AttackerUnit,
RangedAttackerUnit,
ConvertableUnit {
    private BlockPos anchorPos = new BlockPos(0, 0, 0);
    private final ArrayList<Checkpoint> checkpoints = new ArrayList();
    GarrisonGoal garrisonGoal;
    UsePortalGoal usePortalGoal;
    private MoveToTargetBlockGoal moveGoal;
    private SelectedTargetGoal<? extends LivingEntity> targetGoal;
    private ReturnResourcesGoal returnResourcesGoal;
    public MountGoal mountGoal;
    private BlockPos attackMoveTarget = null;
    private LivingEntity followTarget = null;
    private boolean holdPosition = false;
    public static final EntityDataAccessor<String> ownerDataAccessor = SynchedEntityData.m_135353_(SkeletonUnit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private boolean shouldDiscard = false;
    public static final float attackDamage = 4.0f;
    public static final float attacksPerSecond = 0.35f;
    public static final float maxHealth = 30.0f;
    public static final float armorValue = 0.0f;
    public static final float movementSpeed = 0.25f;
    public static final float attackRange = 12.0f;
    public static final float aggroRange = 12.0f;
    public static final boolean willRetaliate = true;
    public static final boolean aggressiveWhenIdle = true;
    public int maxResources = 100;
    public int fogRevealDuration = 0;
    private UnitBowAttackGoal<? extends LivingEntity> attackGoal;
    private MeleeAttackBuildingGoal attackBuildingGoal;
    private final List<AbilityButton> abilityButtons = new ArrayList<AbilityButton>();
    private final List<Ability> abilities = new ArrayList<Ability>();
    private final List<ItemStack> items = new ArrayList<ItemStack>();

    @Override
    public void setAnchor(BlockPos bp) {
        this.anchorPos = bp;
    }

    @Override
    public BlockPos getAnchor() {
        return this.anchorPos;
    }

    @Override
    public ArrayList<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    @Override
    public GarrisonGoal getGarrisonGoal() {
        return this.garrisonGoal;
    }

    @Override
    public boolean canGarrison() {
        return this.getGarrisonGoal() != null;
    }

    @Override
    public UsePortalGoal getUsePortalGoal() {
        return this.usePortalGoal;
    }

    @Override
    public boolean canUsePortal() {
        return this.getUsePortalGoal() != null;
    }

    @Override
    public Faction getFaction() {
        return Faction.MONSTERS;
    }

    @Override
    public List<AbilityButton> getAbilityButtons() {
        return this.abilityButtons;
    }

    @Override
    public List<Ability> getAbilities() {
        return this.abilities;
    }

    @Override
    public List<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public MoveToTargetBlockGoal getMoveGoal() {
        return this.moveGoal;
    }

    public SelectedTargetGoal<? extends LivingEntity> getTargetGoal() {
        return this.targetGoal;
    }

    @Override
    public Goal getAttackBuildingGoal() {
        return this.attackBuildingGoal;
    }

    @Override
    public Goal getAttackGoal() {
        return this.attackGoal;
    }

    @Override
    public ReturnResourcesGoal getReturnResourcesGoal() {
        return this.returnResourcesGoal;
    }

    @Override
    public int getMaxResources() {
        return this.maxResources;
    }

    public MountGoal getMountGoal() {
        return this.mountGoal;
    }

    @Override
    public BlockPos getAttackMoveTarget() {
        return this.attackMoveTarget;
    }

    @Override
    public LivingEntity getFollowTarget() {
        return this.followTarget;
    }

    @Override
    public boolean getHoldPosition() {
        return this.holdPosition;
    }

    @Override
    public void setHoldPosition(boolean holdPosition) {
        this.holdPosition = holdPosition;
    }

    @Override
    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(ownerDataAccessor);
    }

    @Override
    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(ownerDataAccessor, (Object)name);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ownerDataAccessor, (Object)"");
    }

    @Override
    public boolean getWillRetaliate() {
        return true;
    }

    @Override
    public int getAttackCooldown() {
        return 57;
    }

    @Override
    public float getAttacksPerSecond() {
        return 0.35f;
    }

    @Override
    public float getAggroRange() {
        return 12.0f;
    }

    @Override
    public boolean getAggressiveWhenIdle() {
        return !this.m_20160_();
    }

    @Override
    public float getAttackRange() {
        return 12.0f;
    }

    @Override
    public float getMovementSpeed() {
        return 0.25f;
    }

    @Override
    public float getUnitAttackDamage() {
        return 4.0f;
    }

    @Override
    public float getUnitMaxHealth() {
        return 30.0f;
    }

    @Override
    public float getUnitArmorValue() {
        return 0.0f;
    }

    @Override
    @Nullable
    public ResourceCost getCost() {
        return ResourceCosts.SKELETON;
    }

    @Override
    public boolean canAttackBuildings() {
        return this.getAttackBuildingGoal() != null;
    }

    @Override
    public void setAttackMoveTarget(@Nullable BlockPos bp) {
        this.attackMoveTarget = bp;
    }

    @Override
    public void setFollowTarget(@Nullable LivingEntity target) {
        this.followTarget = target;
    }

    @Override
    public boolean shouldDiscard() {
        return this.shouldDiscard;
    }

    @Override
    public void setShouldDiscard(boolean discard) {
        this.shouldDiscard = discard;
    }

    @Override
    public int getFogRevealDuration() {
        return this.fogRevealDuration;
    }

    @Override
    public void setFogRevealDuration(int duration) {
        this.fogRevealDuration = duration;
    }

    public SkeletonUnit(EntityType<? extends Skeleton> entityType, Level level) {
        super(entityType, level);
        this.abilities.add(new MountSpider((LivingEntity)this));
        this.updateAbilityButtons();
    }

    @Override
    public void resetBehaviours() {
        this.mountGoal.m_8041_();
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, (double)Unit.getFollowRange()).m_22268_(Attributes.f_22284_, 0.0);
    }

    public void m_8119_() {
        if (this.shouldDiscard) {
            this.m_146870_();
        } else {
            this.m_21553_(true);
            super.m_8119_();
            Unit.tick(this);
            AttackerUnit.tick(this);
            this.mountGoal.m_8037_();
        }
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.addUnitSaveData(pCompound);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readUnitSaveData(pCompound);
    }

    protected boolean m_21527_() {
        return NightUtils.isSunBurnTick((Mob)this);
    }

    @Override
    public Unit.SunlightEffect getSunlightEffect() {
        return Unit.SunlightEffect.FIRE;
    }

    @Override
    public void initialiseGoals() {
        this.usePortalGoal = new UsePortalGoal((Mob)this);
        this.moveGoal = new MoveToTargetBlockGoal((Mob)this, false, 0);
        this.targetGoal = new SelectedTargetGoal((Mob)this, true, false);
        this.garrisonGoal = new GarrisonGoal((Mob)this);
        this.attackGoal = new UnitBowAttackGoal<SkeletonUnit>(this);
        this.returnResourcesGoal = new ReturnResourcesGoal((Mob)this);
        this.mountGoal = new MountGoal((Mob)this);
    }

    protected void m_8099_() {
        this.initialiseGoals();
        this.f_21345_.m_25352_(2, (Goal)this.usePortalGoal);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, this.attackGoal);
        this.f_21345_.m_25352_(2, (Goal)this.returnResourcesGoal);
        this.f_21345_.m_25352_(2, (Goal)this.mountGoal);
        this.f_21345_.m_25352_(2, (Goal)this.garrisonGoal);
        this.f_21346_.m_25352_(2, this.targetGoal);
        this.f_21345_.m_25352_(3, (Goal)this.moveGoal);
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundUnitGoal((Mob)this));
    }

    @Override
    public void setupEquipmentAndUpgradesServer() {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
    }

    @Override
    public void performUnitRangedAttack(LivingEntity pTarget, float velocity) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrow = this.m_7932_(itemstack, velocity);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrow);
        }
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.3333333333333333) - abstractarrow.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        if (pTarget.m_20192_() <= 1.0f) {
            d1 -= (double)(1.0f - pTarget.m_20192_());
        }
        abstractarrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 0.0f);
        this.m_5496_(SoundEvents.f_12382_, 3.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)abstractarrow);
        if (!this.m_9236_().m_5776_() && pTarget instanceof Unit) {
            Unit unit = (Unit)pTarget;
            FogOfWarClientboundPacket.revealRangedUnit(unit.getOwnerName(), this.m_19879_());
        }
    }
}

