/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.monsters;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.abilities.ConsumeSlime;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.controls.SlimeUnitMoveControl;
import com.solegendary.reignofnether.unit.goals.GarrisonGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackBuildingGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackSlimeUnitGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockSlimeGoal;
import com.solegendary.reignofnether.unit.goals.RandomLookAroundUnitGoal;
import com.solegendary.reignofnether.unit.goals.ReturnResourcesGoal;
import com.solegendary.reignofnether.unit.goals.SelectedTargetGoal;
import com.solegendary.reignofnether.unit.goals.UsePortalGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.piglins.MagmaCubeUnit;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;

public class SlimeUnit
extends Slime
implements Unit,
AttackerUnit {
    private BlockPos anchorPos = new BlockPos(0, 0, 0);
    private final ArrayList<Checkpoint> checkpoints = new ArrayList();
    GarrisonGoal garrisonGoal;
    UsePortalGoal usePortalGoal;
    protected MoveToTargetBlockGoal moveGoal;
    protected SelectedTargetGoal<? extends LivingEntity> targetGoal;
    protected ReturnResourcesGoal returnResourcesGoal;
    private BlockPos attackMoveTarget = null;
    private LivingEntity followTarget = null;
    private boolean holdPosition = false;
    public static final EntityDataAccessor<String> ownerDataAccessor = SynchedEntityData.m_135353_(SlimeUnit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public final int STARTING_SIZE = 2;
    public final int f_149845_ = 6;
    public static final float attackDamagePerSize = 2.0f;
    public static final float attacksPerSecond = 0.5f;
    public static final float armorValue = 0.0f;
    public static final float movementSpeed = 0.6f;
    public static final float aggroRange = 10.0f;
    public static final boolean willRetaliate = true;
    public static final boolean aggressiveWhenIdle = true;
    protected boolean forceTiny = false;
    public boolean shouldSpawnSlimes = true;
    public int maxResources = 0;
    private MeleeAttackSlimeUnitGoal attackGoal;
    private MeleeAttackBuildingGoal attackBuildingGoal;
    private final List<AbilityButton> abilityButtons = new ArrayList<AbilityButton>();
    private final List<Ability> abilities = new ArrayList<Ability>();
    private final List<ItemStack> items = new ArrayList<ItemStack>();
    public SlimeUnit consumeTarget = null;
    public final int PUSH_ATTACK_CD_MAX = this.getAttackCooldown();
    public int pushAttackCd = 0;
    private double lastDistToMoveTargetSqr = 9999.0;
    private BlockPos lastMoveTarget = null;
    private static final int CONVERT_DEBUFF_DURATION_SECONDS = 10;

    @Override
    public void setAnchor(BlockPos bp) {
        this.anchorPos = bp;
    }

    @Override
    public BlockPos getAnchor() {
        return this.anchorPos;
    }

    @Override
    public ArrayList<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    @Override
    public GarrisonGoal getGarrisonGoal() {
        return this.garrisonGoal;
    }

    @Override
    public boolean canGarrison() {
        return this.getGarrisonGoal() != null;
    }

    @Override
    public UsePortalGoal getUsePortalGoal() {
        return this.usePortalGoal;
    }

    @Override
    public boolean canUsePortal() {
        return this.getUsePortalGoal() != null;
    }

    @Override
    public Faction getFaction() {
        return Faction.MONSTERS;
    }

    @Override
    public List<AbilityButton> getAbilityButtons() {
        return this.abilityButtons;
    }

    @Override
    public List<Ability> getAbilities() {
        return this.abilities;
    }

    @Override
    public List<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public MoveToTargetBlockGoal getMoveGoal() {
        return this.moveGoal;
    }

    public SelectedTargetGoal<? extends LivingEntity> getTargetGoal() {
        return this.targetGoal;
    }

    @Override
    public Goal getAttackBuildingGoal() {
        return this.attackBuildingGoal;
    }

    @Override
    public Goal getAttackGoal() {
        return this.attackGoal;
    }

    @Override
    public ReturnResourcesGoal getReturnResourcesGoal() {
        return this.returnResourcesGoal;
    }

    @Override
    public int getMaxResources() {
        return this.maxResources;
    }

    @Override
    public BlockPos getAttackMoveTarget() {
        return this.attackMoveTarget;
    }

    @Override
    public LivingEntity getFollowTarget() {
        return this.followTarget;
    }

    @Override
    public boolean getHoldPosition() {
        return this.holdPosition;
    }

    @Override
    public void setHoldPosition(boolean holdPosition) {
        this.holdPosition = holdPosition;
    }

    @Override
    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(ownerDataAccessor);
    }

    @Override
    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(ownerDataAccessor, (Object)name);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ownerDataAccessor, (Object)"");
    }

    @Override
    public boolean getWillRetaliate() {
        return true;
    }

    @Override
    public int getAttackCooldown() {
        return 40;
    }

    @Override
    public float getAttacksPerSecond() {
        return 0.5f;
    }

    @Override
    public float getAggroRange() {
        return 10.0f;
    }

    @Override
    public boolean getAggressiveWhenIdle() {
        return !this.m_20160_();
    }

    @Override
    public float getAttackRange() {
        return (float)(this.m_33632_() + 1) * 0.5f;
    }

    @Override
    public float getMovementSpeed() {
        return 0.6f;
    }

    @Override
    public float getUnitArmorValue() {
        return 0.0f;
    }

    @Override
    public ResourceCost getCost() {
        int popCost = this.m_33632_();
        if (this.m_33632_() == 1) {
            popCost = 0;
        }
        ResourceCost cost = ResourceCosts.SLIME;
        cost.population = popCost;
        return cost;
    }

    @Override
    public boolean canAttackBuildings() {
        return this.getAttackBuildingGoal() != null;
    }

    @Override
    public void setAttackMoveTarget(@Nullable BlockPos bp) {
        this.attackMoveTarget = bp;
    }

    @Override
    public void setFollowTarget(@Nullable LivingEntity target) {
        this.followTarget = target;
    }

    public SlimeUnit(EntityType<? extends Slime> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new SlimeUnitMoveControl(this);
        this.abilities.add(new ConsumeSlime(this));
        this.updateAbilityButtons();
    }

    public boolean m_6094_() {
        return this.m_6084_() && !this.m_5833_() && !this.m_6147_() && this.m_20096_();
    }

    public void m_7334_(Entity pEntity) {
        super.m_7334_(pEntity);
        if (this.getTargetGoal().getTarget() == pEntity && !this.m_20096_() && !this.m_9236_().m_5776_() && this.pushAttackCd <= 0) {
            this.m_7327_(pEntity);
            this.pushAttackCd = this.PUSH_ATTACK_CD_MAX;
        }
    }

    public int m_33632_() {
        if (this.forceTiny) {
            return 1;
        }
        return super.m_33632_();
    }

    public void m_6074_() {
        this.shouldSpawnSlimes = false;
        super.m_6074_();
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        this.forceTiny = true;
        super.m_142687_(pReason);
        this.forceTiny = false;
    }

    protected float m_6515_(DamageSource pSource, float pDamage) {
        pDamage = super.m_6515_(pSource, pDamage);
        if (pSource.m_269533_(DamageTypeTags.f_268731_)) {
            pDamage *= 0.5f;
        }
        return pDamage;
    }

    protected void spawnTinySlime() {
        float f = (float)this.m_33632_() / 4.0f;
        float f1 = -0.5f * f;
        Slime slime = (Slime)this.m_6095_().m_20615_(this.m_9236_());
        if (slime != null) {
            if (this.m_21532_()) {
                slime.m_21530_();
            }
            slime.m_6593_(this.m_7770_());
            slime.m_21557_(this.m_21525_());
            slime.m_20331_(this.m_20147_());
            slime.m_7839_(1, true);
            slime.m_7678_(this.m_20185_() + (double)f1, this.m_20186_() + 0.5, this.m_20189_() + (double)f1, this.f_19796_.m_188501_() * 360.0f, 0.0f);
            if (slime instanceof Unit) {
                Unit unit = (Unit)slime;
                unit.setOwnerName(this.getOwnerName());
            }
            this.m_9236_().m_7967_((Entity)slime);
        }
    }

    public boolean autocastingConsume() {
        for (Ability ability : this.abilities) {
            if (!(ability instanceof ConsumeSlime)) continue;
            ConsumeSlime consume = (ConsumeSlime)ability;
            return consume.getAutocast();
        }
        return false;
    }

    @Override
    public float getUnitAttackDamage() {
        return 2.0f * (float)this.m_33632_();
    }

    @Override
    public float getUnitMaxHealth() {
        return this.getMaxHealthForSize(this.m_33632_());
    }

    public float getKnockbackResistance() {
        return (float)this.m_33632_() * 0.16666667f;
    }

    @Override
    public void resetBehaviours() {
        this.consumeTarget = null;
        for (Ability ability : this.abilities) {
            if (!(ability instanceof ConsumeSlime)) continue;
            ConsumeSlime consume = (ConsumeSlime)ability;
            consume.setAutocast(false);
        }
    }

    public void m_7839_(int pSize, boolean pResetHealth) {
        int i = Mth.m_14045_((int)pSize, (int)1, (int)6);
        this.f_19804_.m_135381_(f_33582_, (Object)i);
        this.m_20090_();
        this.m_6210_();
        this.m_21051_(Attributes.f_22276_).m_22100_((double)this.getUnitMaxHealth());
        this.m_21051_(Attributes.f_22279_).m_22100_((double)this.getMovementSpeed());
        this.m_21051_(Attributes.f_22281_).m_22100_((double)this.getUnitAttackDamage());
        this.m_21051_(Attributes.f_22278_).m_22100_((double)this.getKnockbackResistance());
        if (pResetHealth) {
            this.m_21153_(this.m_21233_());
        }
    }

    protected int getSizeForHealth(float health) {
        if (health >= (float)this.getMaxHealthForSize(5)) {
            return 6;
        }
        if (health > (float)this.getMaxHealthForSize(4)) {
            return 5;
        }
        if (health > (float)this.getMaxHealthForSize(3)) {
            return 4;
        }
        if (health > (float)this.getMaxHealthForSize(2)) {
            return 3;
        }
        if (health > (float)this.getMaxHealthForSize(1)) {
            return 2;
        }
        return 1;
    }

    protected int getMaxHealthForSize(int size) {
        if (size >= 6) {
            return 200;
        }
        if (size == 5) {
            return 160;
        }
        if (size == 4) {
            return 120;
        }
        if (size == 3) {
            return 80;
        }
        if (size == 2) {
            return 45;
        }
        return 15;
    }

    public boolean m_6785_(double d) {
        return false;
    }

    protected boolean m_7483_() {
        return true;
    }

    protected int m_7549_() {
        return super.m_7549_() * 4;
    }

    protected void m_7480_() {
        this.f_33581_ *= 0.9f;
    }

    public void m_6135_() {
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_, this.m_6118_() + (float)this.m_33632_() * 0.1f, vec3.f_82481_);
        this.f_19812_ = true;
        ForgeHooks.onLivingJump((LivingEntity)this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.6f).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22277_, (double)Unit.getFollowRange());
    }

    public void m_8119_() {
        this.m_21553_(true);
        super.m_8119_();
        Unit.tick(this);
        AttackerUnit.tick(this);
        if (this.pushAttackCd > 0) {
            --this.pushAttackCd;
        }
        if (this.autocastingConsume() && this.m_33632_() < 6 && this.getTargetGoal().getTarget() == null) {
            Vector3d unitPosition = new Vector3d(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_);
            List<SlimeUnit> nearbyEntities = MiscUtil.getEntitiesWithinRange(unitPosition, 10.0f, SlimeUnit.class, this.m_9236_());
            double closestDist = 10.0;
            SlimeUnit closestTarget = null;
            for (SlimeUnit slime : nearbyEntities) {
                double dist;
                if (!slime.getOwnerName().equals(this.getOwnerName()) || slime == this || slime.m_33632_() > this.m_33632_() || slime.m_33633_() || !((dist = this.m_20182_().m_82554_(slime.m_20182_())) < closestDist)) continue;
                closestDist = dist;
                closestTarget = slime;
            }
            if (closestTarget != null) {
                this.consumeTarget = closestTarget;
                this.setUnitAttackTarget((LivingEntity)closestTarget);
            }
        }
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.addUnitSaveData(pCompound);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readUnitSaveData(pCompound);
    }

    @Override
    public Unit.SunlightEffect getSunlightEffect() {
        return Unit.SunlightEffect.MOVEMENT_SLOWDOWN;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_() && this.m_33632_() >= 2 && (this.f_19862_ || this.f_19863_)) {
            boolean flag = false;
            AABB aabb = this.m_20191_().m_82400_(0.2);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (!(block instanceof LeavesBlock)) continue;
                flag = this.m_9236_().m_46953_(blockpos, false, (Entity)this) || flag;
            }
        }
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
        if (!this.m_9236_().m_5776_() && pOnGround && !this.f_33583_) {
            this.attackGoal.landedJump();
            BlockPos moveTarget = this.getMoveGoal().getMoveTarget();
            if (moveTarget != null) {
                double distToMoveTargetSqr = this.m_20238_(Vec3.m_82512_((Vec3i)moveTarget));
                if (distToMoveTargetSqr > this.lastDistToMoveTargetSqr && distToMoveTargetSqr < 9.0 && moveTarget.equals((Object)this.lastMoveTarget)) {
                    this.getMoveGoal().stopMoving();
                }
                this.lastDistToMoveTargetSqr = distToMoveTargetSqr;
                this.lastMoveTarget = moveTarget;
            }
        }
    }

    @Override
    public void initialiseGoals() {
        this.usePortalGoal = new UsePortalGoal((Mob)this);
        this.moveGoal = new MoveToTargetBlockSlimeGoal((Mob)this, false, 0);
        this.targetGoal = new SelectedTargetGoal((Mob)this, true, true);
        this.attackGoal = new MeleeAttackSlimeUnitGoal((Mob)this, false);
        this.attackBuildingGoal = new MeleeAttackBuildingGoal((Mob)this);
    }

    protected void m_8099_() {
        this.initialiseGoals();
        this.f_21345_.m_25352_(2, (Goal)this.usePortalGoal);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)this.attackGoal);
        this.f_21345_.m_25352_(2, (Goal)this.attackBuildingGoal);
        this.f_21346_.m_25352_(2, this.targetGoal);
        this.f_21346_.m_25352_(3, (Goal)this.moveGoal);
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundUnitGoal((Mob)this));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_7839_(2, true);
        return pSpawnData;
    }

    public boolean m_7327_(@NotNull Entity pEntity) {
        boolean result = super.m_7327_(pEntity);
        if (result && pEntity == this.consumeTarget) {
            this.m_7839_(Math.min(6, this.m_33632_() + this.consumeTarget.m_33632_() / 2), false);
            if (this.consumeTarget.m_33632_() != 1) {
                this.m_5634_(this.consumeTarget.getUnitMaxHealth() / 2.0f + 15.0f);
            } else {
                this.m_5634_(this.consumeTarget.getUnitMaxHealth() / 2.0f);
            }
            pEntity.m_6074_();
            this.consumeTarget = null;
            return true;
        }
        if (result && this.m_33632_() >= 2 && pEntity instanceof LivingEntity && !(this instanceof MagmaCubeUnit) && !this.m_9236_().m_5776_() && ResearchServerEvents.playerHasResearch(this.getOwnerName(), ProductionItems.RESEARCH_SLIME_CONVERSION)) {
            ((LivingEntity)pEntity).m_147207_(new MobEffectInstance(MobEffects.f_19604_, 200, 0), (Entity)this);
        }
        return result;
    }

    protected void m_33637_(LivingEntity pLivingEntity) {
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        boolean result = super.m_6469_(pSource, pAmount);
        int newSize = this.getSizeForHealth(this.m_21223_());
        if (newSize < this.m_33632_() && this.shouldSpawnSlimes) {
            if (this.m_33632_() >= 2) {
                this.spawnTinySlime();
            }
            if (this.m_33632_() >= 4) {
                this.spawnTinySlime();
            }
            if (this.m_33632_() >= 6) {
                this.spawnTinySlime();
            }
        }
        if (newSize != this.m_33632_()) {
            this.m_7839_(newSize, false);
        }
        return result;
    }
}

