/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.piglins;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.buildings.piglins.BasaltSprings;
import com.solegendary.reignofnether.building.buildings.piglins.FlameSanctuary;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.goals.AbstractMeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.BuildRepairGoal;
import com.solegendary.reignofnether.unit.goals.GarrisonGoal;
import com.solegendary.reignofnether.unit.goals.GatherResourcesGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.RandomLookAroundUnitGoal;
import com.solegendary.reignofnether.unit.goals.ReturnResourcesGoal;
import com.solegendary.reignofnether.unit.goals.SelectedTargetGoal;
import com.solegendary.reignofnether.unit.goals.UsePortalGoal;
import com.solegendary.reignofnether.unit.interfaces.ArmSwingingUnit;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class GruntUnit
extends Piglin
implements Unit,
WorkerUnit,
AttackerUnit,
ArmSwingingUnit {
    private BlockPos anchorPos = new BlockPos(0, 0, 0);
    private final ArrayList<Checkpoint> checkpoints = new ArrayList();
    GarrisonGoal garrisonGoal;
    UsePortalGoal usePortalGoal;
    private MoveToTargetBlockGoal moveGoal;
    private SelectedTargetGoal<? extends LivingEntity> targetGoal;
    public BuildRepairGoal buildRepairGoal;
    public GatherResourcesGoal gatherResourcesGoal;
    private ReturnResourcesGoal returnResourcesGoal;
    private AbstractMeleeAttackUnitGoal attackGoal;
    private LivingEntity followTarget = null;
    private boolean holdPosition = false;
    private BlockPos attackMoveTarget = null;
    public static final EntityDataAccessor<String> ownerDataAccessor = SynchedEntityData.m_135353_(GruntUnit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final float attackDamage = 1.0f;
    public static final float attacksPerSecond = 0.5f;
    public static final float attackRange = 2.0f;
    public static final float aggroRange = 0.0f;
    public static final boolean willRetaliate = false;
    public static final boolean aggressiveWhenIdle = false;
    public static final float maxHealth = 25.0f;
    public static final float armorValue = 0.0f;
    public static final float movementSpeed = 0.25f;
    public int maxResources = 100;
    private final List<AbilityButton> abilityButtons = new ArrayList<AbilityButton>();
    private final List<Ability> abilities = new ArrayList<Ability>();
    private final List<ItemStack> items = new ArrayList<ItemStack>();
    private boolean isSwingingArmOnce = false;
    private int swingTime = 0;

    @Override
    public void setAnchor(BlockPos bp) {
        this.anchorPos = bp;
    }

    @Override
    public BlockPos getAnchor() {
        return this.anchorPos;
    }

    @Override
    public ArrayList<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    @Override
    public GarrisonGoal getGarrisonGoal() {
        return this.garrisonGoal;
    }

    @Override
    public boolean canGarrison() {
        return this.getGarrisonGoal() != null;
    }

    @Override
    public UsePortalGoal getUsePortalGoal() {
        return this.usePortalGoal;
    }

    @Override
    public boolean canUsePortal() {
        return this.getUsePortalGoal() != null;
    }

    @Override
    public Faction getFaction() {
        return Faction.PIGLINS;
    }

    @Override
    public List<AbilityButton> getAbilityButtons() {
        return this.abilityButtons;
    }

    @Override
    public List<Ability> getAbilities() {
        return this.abilities;
    }

    @Override
    public List<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public MoveToTargetBlockGoal getMoveGoal() {
        return this.moveGoal;
    }

    public SelectedTargetGoal<? extends LivingEntity> getTargetGoal() {
        return this.targetGoal;
    }

    @Override
    public BuildRepairGoal getBuildRepairGoal() {
        return this.buildRepairGoal;
    }

    @Override
    public GatherResourcesGoal getGatherResourceGoal() {
        return this.gatherResourcesGoal;
    }

    @Override
    public ReturnResourcesGoal getReturnResourcesGoal() {
        return this.returnResourcesGoal;
    }

    @Override
    public int getMaxResources() {
        return this.maxResources;
    }

    @Override
    public LivingEntity getFollowTarget() {
        return this.followTarget;
    }

    @Override
    public boolean getHoldPosition() {
        return this.holdPosition;
    }

    @Override
    public void setHoldPosition(boolean holdPosition) {
        this.holdPosition = holdPosition;
    }

    @Override
    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(ownerDataAccessor);
    }

    @Override
    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(ownerDataAccessor, (Object)name);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ownerDataAccessor, (Object)"");
    }

    @Override
    public float getMovementSpeed() {
        return 0.25f;
    }

    @Override
    public float getUnitMaxHealth() {
        return 25.0f;
    }

    @Override
    public float getUnitArmorValue() {
        return 0.0f;
    }

    @Override
    @Nullable
    public ResourceCost getCost() {
        return ResourceCosts.GRUNT;
    }

    @Override
    public boolean getWillRetaliate() {
        return false;
    }

    @Override
    public int getAttackCooldown() {
        return 40;
    }

    @Override
    public float getAttacksPerSecond() {
        return 0.5f;
    }

    @Override
    public float getAggroRange() {
        return 0.0f;
    }

    @Override
    public boolean getAggressiveWhenIdle() {
        return false;
    }

    @Override
    public float getAttackRange() {
        return 2.0f;
    }

    @Override
    public float getUnitAttackDamage() {
        return 1.0f;
    }

    @Override
    public BlockPos getAttackMoveTarget() {
        return this.attackMoveTarget;
    }

    @Override
    public boolean canAttackBuildings() {
        return this.getAttackBuildingGoal() != null;
    }

    @Override
    public Goal getAttackGoal() {
        return this.attackGoal;
    }

    @Override
    public Goal getAttackBuildingGoal() {
        return null;
    }

    @Override
    public void setAttackMoveTarget(@Nullable BlockPos bp) {
        this.attackMoveTarget = bp;
    }

    @Override
    public void setFollowTarget(@Nullable LivingEntity target) {
        this.followTarget = target;
    }

    @Override
    public BlockState getReplantBlockState() {
        return Blocks.f_50200_.m_49966_();
    }

    @Override
    public int getSwingTime() {
        return this.swingTime;
    }

    @Override
    public void setSwingTime(int time) {
        this.swingTime = time;
    }

    @Override
    public boolean isSwingingArmOnce() {
        return this.isSwingingArmOnce;
    }

    @Override
    public void setSwingingArmOnce(boolean swing) {
        this.isSwingingArmOnce = swing;
    }

    @Override
    public boolean isSwingingArmRepeatedly() {
        return this.getGatherResourceGoal() != null && this.getGatherResourceGoal().isGathering() || this.getBuildRepairGoal() != null && this.getBuildRepairGoal().isBuilding();
    }

    public static List<AbilityButton> getBuildingButtons() {
        return List.of(Buildings.CENTRAL_PORTAL.getBuildButton(Keybindings.keyQ), Buildings.PORTAL_BASIC.getBuildButton(Keybindings.keyW), Buildings.NETHERWART_FARM.getBuildButton(Keybindings.keyE), Buildings.BASTION.getBuildButton(Keybindings.keyR), Buildings.HOGLIN_STABLES.getBuildButton(Keybindings.keyT), Buildings.FLAME_SANCTUARY.getBuildButton(Keybindings.keyY), Buildings.WITHER_SHRINE.getBuildButton(Keybindings.keyU), Buildings.BASALT_SPRINGS.getBuildButton(Keybindings.keyI), Buildings.FORTRESS.getBuildButton(Keybindings.keyO), Buildings.INFERNAL_PORTAL.getBuildButton(Keybindings.keyF), Buildings.BLACKSTONE_BRIDGE.getBuildButton(Keybindings.keyC), Buildings.BEACON.getBuildButton(null));
    }

    public GruntUnit(EntityType<? extends Piglin> entityType, Level level) {
        super(entityType, level);
        this.updateAbilityButtons();
    }

    @Override
    public void updateAbilityButtons() {
        if (this.m_9236_().m_5776_()) {
            this.abilityButtons.clear();
            this.abilityButtons.addAll(GruntUnit.getBuildingButtons());
        }
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22277_, (double)Unit.getFollowRange()).m_22268_(Attributes.f_22284_, 0.0);
    }

    public boolean m_21526_() {
        return false;
    }

    protected void m_7581_(ItemEntity pItemEntity) {
    }

    public boolean m_34666_() {
        return false;
    }

    protected void m_8024_() {
    }

    public LivingEntity m_5448_() {
        return this.targetGoal.getTarget();
    }

    public void m_8119_() {
        this.m_21553_(true);
        super.m_8119_();
        Unit.tick(this);
        AttackerUnit.tick(this);
        WorkerUnit.tick(this);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.addUnitSaveData(pCompound);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readUnitSaveData(pCompound);
    }

    @Override
    public void initialiseGoals() {
        this.usePortalGoal = new UsePortalGoal((Mob)this);
        this.moveGoal = new MoveToTargetBlockGoal((Mob)this, false, 0);
        this.targetGoal = new SelectedTargetGoal((Mob)this, true, true);
        this.garrisonGoal = new GarrisonGoal((Mob)this);
        this.attackGoal = new MeleeAttackUnitGoal((Mob)this, false);
        this.buildRepairGoal = new BuildRepairGoal((Mob)this);
        this.gatherResourcesGoal = new GatherResourcesGoal((Mob)this);
        this.returnResourcesGoal = new ReturnResourcesGoal((Mob)this);
    }

    protected void m_8099_() {
        this.initialiseGoals();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)this.usePortalGoal);
        this.f_21345_.m_25352_(2, (Goal)this.attackGoal);
        this.f_21345_.m_25352_(2, (Goal)this.buildRepairGoal);
        this.f_21345_.m_25352_(2, (Goal)this.gatherResourcesGoal);
        this.f_21345_.m_25352_(2, (Goal)this.returnResourcesGoal);
        this.f_21345_.m_25352_(2, (Goal)this.garrisonGoal);
        this.f_21346_.m_25352_(2, this.targetGoal);
        this.f_21345_.m_25352_(3, (Goal)this.moveGoal);
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundUnitGoal((Mob)this));
    }

    @Override
    public void setupEquipmentAndUpgradesClient() {
        if (ResearchClient.hasResearch(ProductionItems.RESEARCH_RESOURCE_CAPACITY)) {
            this.maxResources = 200;
        }
    }

    @Override
    public void setupEquipmentAndUpgradesServer() {
        if (ResearchServerEvents.playerHasResearch(this.getOwnerName(), ProductionItems.RESEARCH_RESOURCE_CAPACITY)) {
            this.maxResources = 200;
        }
    }

    public boolean m_5825_() {
        BuildingPlacement bpl = BuildingUtils.findBuilding(this.m_9236_().m_5776_(), this.m_20097_());
        return super.m_5825_() || bpl != null && (bpl.getBuilding() instanceof FlameSanctuary || bpl.getBuilding() instanceof BasaltSprings);
    }
}

