/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.time.TimeClientEvents;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.monsters.NecromancerUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class AbilityClientboundPacket {
    private final int unitId;
    private final boolean isSettingCooldown;
    private final UnitAction unitAction;
    private final float value;

    private static void setServersideCooldown(int unitId, UnitAction unitAction, float cooldown) {
        for (LivingEntity entity : UnitServerEvents.getAllUnits()) {
            if (entity.m_19879_() != unitId || !(entity instanceof Unit)) continue;
            Unit unit = (Unit)entity;
            for (Ability ability : unit.getAbilities().get()) {
                if (ability.action != unitAction) continue;
                ability.setCooldown(cooldown, unit);
                return;
            }
        }
    }

    public static void sendSetCooldownPacket(int unitId, UnitAction unitAction, float cooldown) {
        AbilityClientboundPacket.setServersideCooldown(unitId, unitAction, cooldown);
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new AbilityClientboundPacket(unitId, true, unitAction, cooldown));
    }

    public static void doAbility(int unitId, UnitAction unitAction, float value) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new AbilityClientboundPacket(unitId, false, unitAction, value));
    }

    public AbilityClientboundPacket(int unitId, boolean isSettingCooldown, UnitAction unitAction, float value) {
        this.unitId = unitId;
        this.isSettingCooldown = isSettingCooldown;
        this.unitAction = unitAction;
        this.value = value;
    }

    public AbilityClientboundPacket(FriendlyByteBuf buffer) {
        this.unitId = buffer.readInt();
        this.isSettingCooldown = buffer.readBoolean();
        this.unitAction = (UnitAction)buffer.m_130066_(UnitAction.class);
        this.value = buffer.readFloat();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.unitId);
        buffer.writeBoolean(this.isSettingCooldown);
        buffer.m_130068_((Enum)this.unitAction);
        buffer.writeFloat(this.value);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Unit unit = null;
            for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
                if (entity.m_19879_() != this.unitId || !(entity instanceof Unit)) continue;
                unit = (Unit)entity;
                break;
            }
            if (this.isSettingCooldown && unit != null) {
                for (Ability ability : unit.getAbilities().get()) {
                    if (ability.action != this.unitAction) continue;
                    ability.setCooldown(this.value, unit);
                    return;
                }
            }
            if (this.unitAction == UnitAction.BLOOD_MOON) {
                TimeClientEvents.setBloodMoonTicks((int)this.value, unit == null ? "" : unit.getOwnerName());
            } else if (this.unitAction == UnitAction.SOUL_SIPHON_UPDATE && unit instanceof NecromancerUnit) {
                NecromancerUnit necromancer = (NecromancerUnit)unit;
                necromancer.souls = (int)this.value;
                necromancer.updateAbilityButtons();
            }
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

