/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.heroAbilities.monster;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.goals.GenericUntargetedSpellGoal;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.monsters.NecromancerUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class RaiseDead
extends HeroAbility {
    public static final int CHANNEL_TICKS = 40;
    private static final int CD_MAX_SECONDS = 1500;
    public static final int ZOMBIE_TICKS_BEFORE_DECAY = 1200;

    public RaiseDead() {
        super(3, 75, UnitAction.RAISE_DEAD, 1500, 0.0f, 0.0f, false);
    }

    @Override
    public boolean isCasting(Unit unit) {
        NecromancerUnit necromancerUnit;
        GenericUntargetedSpellGoal goal;
        if (unit instanceof NecromancerUnit && (goal = (necromancerUnit = (NecromancerUnit)unit).getCastRaiseDeadGoal()) != null) {
            return goal.isCasting();
        }
        return false;
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey, Unit unit) {
        if (!(unit instanceof HeroUnit)) {
            return null;
        }
        HeroUnit hero = (HeroUnit)unit;
        return new AbilityButton("Raise Dead", ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/zombie.png"), hotkey, () -> false, () -> this.getRank(hero) <= 0, () -> true, () -> UnitClientEvents.sendUnitCommand(UnitAction.RAISE_DEAD), null, this.getTooltipLines(hero), (Ability)this, hero);
    }

    @Override
    public Button getRankUpButton(HeroUnit hero) {
        return super.getRankUpButtonProtected("Raise Dead", ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/zombie.png"), hero);
    }

    @Override
    public List<FormattedCharSequence> getTooltipLines(HeroUnit hero) {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.raise_dead", (Object[])new Object[0]) + " " + this.rankString(hero), true), MiscUtil.fcsIcons(I18n.m_118938_((String)"abilities.reignofnether.raise_dead.stats", (Object[])new Object[]{75, this.manaCost})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.raise_dead.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.raise_dead.tooltip2", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.raise_dead.tooltip3", (Object[])new Object[]{60})));
    }

    @Override
    public List<FormattedCharSequence> getRankUpTooltipLines(HeroUnit hero) {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.raise_dead", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.level_req", (Object[])new Object[]{this.getLevelRequirement(hero)}), this.getLevelReqStyle(hero)), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.raise_dead.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.raise_dead.tooltip2", (Object[])new Object[0])), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.raise_dead.rank1", (Object[])new Object[0]), this.getRank(hero) == 0), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.raise_dead.rank2", (Object[])new Object[0]), this.getRank(hero) == 1), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.raise_dead.rank3", (Object[])new Object[0]), this.getRank(hero) == 2));
    }

    @Override
    public void use(Level level, Unit unitUsing, BlockPos targetBp) {
        ((NecromancerUnit)unitUsing).getCastRaiseDeadGoal().setAbility(this);
        ((NecromancerUnit)unitUsing).getCastRaiseDeadGoal().startCasting();
    }

    @Override
    public void use(Level level, Unit unitUsing, LivingEntity targetEntity) {
        ((NecromancerUnit)unitUsing).getCastRaiseDeadGoal().setAbility(this);
        ((NecromancerUnit)unitUsing).getCastRaiseDeadGoal().startCasting();
    }
}

