/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.heroAbilities.monster;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.AbilityClientboundPacket;
import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitAnimationAction;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.packets.UnitAnimationClientboundPacket;
import com.solegendary.reignofnether.unit.units.monsters.NecromancerUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class SoulSiphonPassive
extends HeroAbility {
    public static int RANGE = 16;
    public int soulsPerCast = 0;
    public int soulsMax = 0;
    public int soulsConsumedForHealth = 10;
    public float healthPerSoul = 1.5f;

    public SoulSiphonPassive() {
        super(3, 0, UnitAction.SOUL_SIPHON_HEAL, 0, 0.0f, 0.0f, false);
        this.autocastEnableAction = UnitAction.ENABLE_SOUL_SIPHON_PASSIVE;
        this.autocastDisableAction = UnitAction.DISBLE_SOUL_SIPHON_PASSIVE;
        this.setDefaultAutocast(true);
    }

    @Override
    public boolean rankUp(HeroUnit hero) {
        if (super.rankUp(hero)) {
            this.updateStatsForRank(hero);
            return true;
        }
        return false;
    }

    @Override
    public void updateStatsForRank(HeroUnit hero) {
        if (this.getRank(hero) == 1) {
            this.soulsPerCast = 4;
            this.soulsMax = 20;
        } else if (this.getRank(hero) == 2) {
            this.soulsPerCast = 7;
            this.soulsMax = 30;
        } else if (this.getRank(hero) == 3) {
            this.soulsPerCast = 10;
            this.soulsMax = 40;
        }
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey, Unit unit) {
        if (!(unit instanceof NecromancerUnit)) {
            return null;
        }
        NecromancerUnit necro = (NecromancerUnit)unit;
        AbilityButton button = new AbilityButton("Soul Siphon", ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/portal.png"), hotkey, () -> this.isAutocasting(necro), () -> this.getRank(necro) == 0, () -> true, () -> this.toggleAutocast(necro), () -> UnitClientEvents.sendUnitCommand(UnitAction.SOUL_SIPHON_HEAL), this.getTooltipLines(necro), (Ability)this, necro);
        button.extraLabel = String.valueOf(necro.souls);
        if (necro.souls <= 0) {
            button.extraLabelColour = 0xFF0000;
        } else if (necro.souls >= this.soulsMax) {
            button.extraLabelColour = 65280;
        } else if (necro.souls <= this.soulsPerCast) {
            button.extraLabelColour = 0xFFFF00;
        }
        return button;
    }

    @Override
    public Button getRankUpButton(HeroUnit hero) {
        return super.getRankUpButtonProtected("Soul Siphon", ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/portal.png"), hero);
    }

    @Override
    public List<FormattedCharSequence> getTooltipLines(HeroUnit hero) {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon", (Object[])new Object[0]) + " " + this.rankString(hero), true), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon.tooltip2", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon.tooltip3", (Object[])new Object[]{this.soulsPerCast, this.soulsMax})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon.tooltip4", (Object[])new Object[]{this.soulsConsumedForHealth, Float.valueOf(this.healthPerSoul)})), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon.tooltip5", (Object[])new Object[0])));
    }

    @Override
    public List<FormattedCharSequence> getRankUpTooltipLines(HeroUnit hero) {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.level_req", (Object[])new Object[]{this.getLevelRequirement(hero)}), this.getLevelReqStyle(hero)), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon.tooltip2", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon.tooltip3", (Object[])new Object[]{this.soulsPerCast, this.soulsMax})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.can_be_toggled", (Object[])new Object[0])), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon.rank1", (Object[])new Object[0]), this.getRank(hero) == 0), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon.rank2", (Object[])new Object[0]), this.getRank(hero) == 1), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon.rank3", (Object[])new Object[0]), this.getRank(hero) == 2));
    }

    public boolean consumeSoulsForCast(NecromancerUnit hero) {
        if (this.isAutocasting(hero) && hero.souls >= this.soulsPerCast) {
            hero.souls -= this.soulsPerCast;
            if (!hero.m_9236_().m_5776_()) {
                AbilityClientboundPacket.doAbility(hero.m_19879_(), UnitAction.SOUL_SIPHON_UPDATE, hero.souls);
            }
            this.addUnitPoofs(this.soulsPerCast * 3, hero);
            return true;
        }
        return false;
    }

    @Override
    public void use(Level level, Unit hero, BlockPos targetBp) {
        if (!(hero instanceof NecromancerUnit)) {
            return;
        }
        NecromancerUnit necro = (NecromancerUnit)hero;
        int soulsConsumed = Math.min(necro.souls, this.soulsConsumedForHealth);
        if (soulsConsumed > 0) {
            LivingEntity entity = (LivingEntity)hero;
            necro.souls -= soulsConsumed;
            if (!level.m_5776_()) {
                AbilityClientboundPacket.doAbility(entity.m_19879_(), UnitAction.SOUL_SIPHON_UPDATE, necro.souls);
                UnitAnimationClientboundPacket.sendBasicPacket(UnitAnimationAction.CAST_SPELL, entity);
            }
            entity.m_5634_((float)soulsConsumed * this.healthPerSoul);
            this.addUnitPoofs(soulsConsumed * 3, hero);
        }
    }

    private void addUnitPoofs(int amount, Unit hero) {
        MiscUtil.addParticleExplosion(ParticleTypes.f_123771_, amount, ((Entity)hero).m_9236_(), ((Entity)hero).m_146892_());
    }

    public void checkAndGainSouls(LivingEntity entityKilled, int splitAmount, NecromancerUnit necro) {
        Unit unit;
        if (this.soulsMax > 0 && entityKilled instanceof Unit && !(unit = (Unit)entityKilled).getOwnerName().equals(necro.getOwnerName())) {
            necro.souls += unit.getCost().population / splitAmount;
        }
        if (necro.souls > this.soulsMax) {
            necro.souls = this.soulsMax;
        }
        if (necro.m_9236_().m_5776_()) {
            necro.updateAbilityButtons();
        }
    }
}

