/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingSave;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.buildings.placements.PortalPlacement;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;

public class BuildingSaveData
extends SavedData {
    public final ArrayList<BuildingSave> buildings = new ArrayList();

    private static BuildingSaveData create() {
        return new BuildingSaveData();
    }

    @Nonnull
    public static BuildingSaveData getInstance(LevelAccessor level) {
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return BuildingSaveData.create();
        }
        return (BuildingSaveData)server.m_129783_().m_8895_().m_164861_(BuildingSaveData::load, BuildingSaveData::create, "saved-building-data");
    }

    public static BuildingSaveData load(CompoundTag tag) {
        ReignOfNether.LOGGER.info("BuildingSaveData.load");
        BuildingSaveData data = BuildingSaveData.create();
        ListTag ltag = (ListTag)tag.m_128423_("buildings");
        if (ltag != null) {
            for (Tag ctag : ltag) {
                CompoundTag btag = (CompoundTag)ctag;
                BlockPos pos = new BlockPos(btag.m_128451_("x"), btag.m_128451_("y"), btag.m_128451_("z"));
                ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_);
                Building building = btag.m_128441_("buildingKey") ? (Building)ReignOfNetherRegistries.BUILDING.m_7745_(ResourceLocation.m_135820_((String)btag.m_128461_("buildingKey"))) : BuildingSaveData.getOldBuilding(btag.m_128461_("buildingName"));
                String ownerName = btag.m_128461_("ownerName");
                Rotation rotation = Rotation.valueOf((String)btag.m_128461_("rotation"));
                BlockPos rallyPoint = new BlockPos(btag.m_128451_("rallyX"), btag.m_128451_("rallyY"), btag.m_128451_("rallyZ"));
                boolean isDiagonalBridge = btag.m_128471_("isDiagonalBridge");
                boolean isBuilt = btag.m_128471_("isBuilt");
                int upgradeLevel = btag.m_128451_("upgradeLevel");
                PortalPlacement.PortalType portalType = PortalPlacement.PortalType.valueOf(btag.m_128461_("portalType"));
                BlockPos portalDestination = new BlockPos(btag.m_128451_("xp"), btag.m_128451_("yp"), btag.m_128451_("zp"));
                data.buildings.add(new BuildingSave(pos, (Level)level, building, ownerName, rotation, rallyPoint, isDiagonalBridge, isBuilt, upgradeLevel, portalType, portalDestination));
                ReignOfNether.LOGGER.info("BuildingSaveData.load: " + ownerName + "|" + ReignOfNetherRegistries.BUILDING.m_7981_((Object)building).toString());
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        this.buildings.forEach(b -> {
            String buildingName = ReignOfNetherRegistries.BUILDING.m_7981_((Object)b.building).toString();
            CompoundTag cTag = new CompoundTag();
            cTag.m_128359_("buildingKey", buildingName);
            cTag.m_128405_("x", b.originPos.m_123341_());
            cTag.m_128405_("y", b.originPos.m_123342_());
            cTag.m_128405_("z", b.originPos.m_123343_());
            cTag.m_128359_("rotation", b.rotation.name());
            cTag.m_128405_("rallyX", b.rallyPoint != null ? b.rallyPoint.m_123341_() : b.originPos.m_123341_());
            cTag.m_128405_("rallyY", b.rallyPoint != null ? b.rallyPoint.m_123342_() : b.originPos.m_123342_());
            cTag.m_128405_("rallyZ", b.rallyPoint != null ? b.rallyPoint.m_123343_() : b.originPos.m_123343_());
            cTag.m_128359_("ownerName", b.ownerName);
            cTag.m_128379_("isDiagonalBridge", b.isDiagonalBridge);
            cTag.m_128379_("isBuilt", b.isBuilt);
            cTag.m_128405_("upgradeLevel", b.upgradeLevel);
            cTag.m_128359_("portalType", b.portalType != null ? b.portalType.name() : PortalPlacement.PortalType.BASIC.name());
            cTag.m_128405_("xp", b.portalDestination != null ? b.portalDestination.m_123341_() : 0);
            cTag.m_128405_("yp", b.portalDestination != null ? b.portalDestination.m_123342_() : 0);
            cTag.m_128405_("zp", b.portalDestination != null ? b.portalDestination.m_123343_() : 0);
            list.add((Object)cTag);
        });
        tag.m_128365_("buildings", (Tag)list);
        return tag;
    }

    public void save() {
        this.m_77762_();
    }

    private static Building getOldBuilding(String name) {
        Building building = null;
        switch (name) {
            case "Oak Bridge": {
                building = Buildings.OAK_BRIDGE;
                break;
            }
            case "Spruce Bridge": {
                building = Buildings.SPRUCE_BRIDGE;
                break;
            }
            case "Blackstone Bridge": {
                building = Buildings.BLACKSTONE_BRIDGE;
                break;
            }
            case "Stockpile": {
                building = Buildings.OAK_STOCKPILE;
                break;
            }
            case "Dark Stockpile": {
                building = Buildings.SPRUCE_STOCKPILE;
                break;
            }
            case "Villager House": {
                building = Buildings.VILLAGER_HOUSE;
                break;
            }
            case "Graveyard": {
                building = Buildings.GRAVEYARD;
                break;
            }
            case "Wheat Farm": {
                building = Buildings.WHEAT_FARM;
                break;
            }
            case "Laboratory": {
                building = Buildings.LABORATORY;
                break;
            }
            case "Barracks": {
                building = Buildings.BARRACKS;
                break;
            }
            case "Pumpkin Farm": {
                building = Buildings.PUMPKIN_FARM;
                break;
            }
            case "Haunted House": {
                building = Buildings.HAUNTED_HOUSE;
                break;
            }
            case "Blacksmith": {
                building = Buildings.BLACKSMITH;
                break;
            }
            case "Town Centre": {
                building = Buildings.TOWN_CENTRE;
                break;
            }
            case "Iron Golem": {
                building = Buildings.IRON_GOLEM_BUILDING;
                break;
            }
            case "Mausoleum": {
                building = Buildings.MAUSOLEUM;
                break;
            }
            case "Sculk Catalyst": {
                building = Buildings.SCULK_CATALYST;
                break;
            }
            case "Spider Lair": {
                building = Buildings.SPIDER_LAIR;
                break;
            }
            case "Slime Pit": {
                building = Buildings.SLIME_PIT;
                break;
            }
            case "Arcane Tower": {
                building = Buildings.ARCANE_TOWER;
                break;
            }
            case "Library": {
                building = Buildings.LIBRARY;
                break;
            }
            case "Dungeon": {
                building = Buildings.DUNGEON;
                break;
            }
            case "Watchtower": {
                building = Buildings.WATCHTOWER;
                break;
            }
            case "Dark Watchtower": {
                building = Buildings.DARK_WATCHTOWER;
                break;
            }
            case "Castle": {
                building = Buildings.CASTLE;
                break;
            }
            case "Stronghold": {
                building = Buildings.STRONGHOLD;
                break;
            }
            case "Central Portal": {
                building = Buildings.CENTRAL_PORTAL;
                break;
            }
            case "Basic Portal": {
                building = Buildings.PORTAL_BASIC;
                break;
            }
            case "Civilian Portal": {
                building = Buildings.PORTAL_CIVILIAN;
                break;
            }
            case "Military Portal": {
                building = Buildings.PORTAL_MILITARY;
                break;
            }
            case "Transport Portal": {
                building = Buildings.PORTAL_TRANSPORT;
                break;
            }
            case "Netherwart Farm": {
                building = Buildings.NETHERWART_FARM;
                break;
            }
            case "Bastion": {
                building = Buildings.BASTION;
                break;
            }
            case "Hoglin Stables": {
                building = Buildings.HOGLIN_STABLES;
                break;
            }
            case "Flame Sanctuary": {
                building = Buildings.FLAME_SANCTUARY;
                break;
            }
            case "Wither Shrine": {
                building = Buildings.WITHER_SHRINE;
                break;
            }
            case "Basalt Springs": {
                building = Buildings.BASALT_SPRINGS;
                break;
            }
            case "Fortress": {
                building = Buildings.FORTRESS;
                break;
            }
            case "Beacon": {
                building = Buildings.BEACON;
                break;
            }
            case "The Beacon": {
                building = Buildings.CAPTURABLE_BEACON;
                break;
            }
            case "End Portal": {
                building = Buildings.END_PORTAL;
                break;
            }
            case "Healing Fountain": {
                building = Buildings.HEALING_FOUNTAIN;
                break;
            }
            case "Neutral Transport Portal": {
                building = Buildings.NEUTRAL_TRANSPORT_PORTAL;
            }
        }
        return building;
    }
}

