/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.monsters;

import com.solegendary.reignofnether.ability.abilities.CallLightning;
import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlaceButton;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.buildings.placements.RangeIndicatorProductionPlacement;
import com.solegendary.reignofnether.building.production.ProductionBuilding;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.util.Faction;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class Laboratory
extends ProductionBuilding {
    public static final String buildingName = "Laboratory";
    public static final String structureName = "laboratory";
    public static final String upgradedStructureName = "laboratory_lightning";
    public static final ResourceCost cost = ResourceCosts.LABORATORY;
    private final Set<BlockPos> lightningBorderBps = new HashSet<BlockPos>();

    public Laboratory() {
        super(structureName, cost, false);
        this.name = buildingName;
        this.portraitBlock = Blocks.f_50255_;
        this.icon = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/brewing_stand.png");
        this.buildTimeModifier = 0.85f;
        this.canSetRallyPoint = false;
        this.startingBlockTypes.add(Blocks.f_50741_);
        this.startingBlockTypes.add(Blocks.f_50730_);
        this.abilities.add(new CallLightning(), Keybindings.keyL);
        this.productions.add(ProductionItems.RESEARCH_HUSKS, Keybindings.keyQ);
        this.productions.add(ProductionItems.RESEARCH_DROWNED, Keybindings.keyW);
        this.productions.add(ProductionItems.RESEARCH_STRAYS, Keybindings.keyE);
        this.productions.add(ProductionItems.RESEARCH_SPIDER_JOCKEYS, Keybindings.keyR);
        this.productions.add(ProductionItems.RESEARCH_POISON_SPIDERS, Keybindings.keyT);
        this.productions.add(ProductionItems.RESEARCH_SPIDER_WEBS, Keybindings.keyY);
        this.productions.add(ProductionItems.RESEARCH_SLIME_CONVERSION, Keybindings.keyU);
        this.productions.add(ProductionItems.RESEARCH_LAB_LIGHTNING_ROD, Keybindings.keyI);
        this.productions.add(ProductionItems.RESEARCH_SILVERFISH, Keybindings.keyO);
        this.productions.add(ProductionItems.RESEARCH_SCULK_AMPLIFIERS, Keybindings.keyP);
    }

    @Override
    public Faction getFaction() {
        return Faction.MONSTERS;
    }

    public BlockPos getLightningRodPos(BuildingPlacement placement) {
        for (BuildingBlock block : placement.getBlocks()) {
            if (placement.getLevel().m_8055_(block.getBlockPos()).m_60734_() != Blocks.f_152587_ || placement.getLevel().m_8055_(block.getBlockPos().m_7495_()).m_60734_() != Blocks.f_152571_) continue;
            return block.getBlockPos();
        }
        return null;
    }

    @Override
    public int getUpgradeLevel(BuildingPlacement placement) {
        for (BuildingBlock block : placement.getBlocks()) {
            if (block.getBlockState().m_60734_() != Blocks.f_152587_) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public BuildingPlacement createBuildingPlacement(Level level, BlockPos pos, Rotation rotation, String ownerName) {
        return new RangeIndicatorProductionPlacement(this, level, pos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(this.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, pos, rotation), false, 25, true, true);
    }

    @Override
    public BuildingPlaceButton getBuildButton(Keybinding hotkey) {
        ResourceLocation key = ReignOfNetherRegistries.BUILDING.m_7981_((Object)this);
        String name = I18n.m_118938_((String)("buildings." + this.getFaction().name().toLowerCase() + "." + key.m_135827_() + "." + key.m_135815_()), (Object[])new Object[0]);
        return new BuildingPlaceButton(name, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/brewing_stand.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Buildings.LABORATORY, () -> false, () -> BuildingClientEvents.hasFinishedBuilding(Buildings.MAUSOLEUM) && BuildingClientEvents.hasFinishedBuilding(Buildings.GRAVEYARD) || ResearchClient.hasCheat("modifythephasevariance"), List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.laboratory", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.laboratory.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.laboratory.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.laboratory.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)), this);
    }
}

