/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.placements;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingPlacement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public class BridgePlacement
extends BuildingPlacement {
    boolean diagonal;

    public BridgePlacement(Building building, Level level, BlockPos originPos, Rotation rotation, String ownerName, ArrayList<BuildingBlock> blocks, boolean isCapitol, boolean diagonal) {
        super(building, level, originPos, rotation, ownerName, blocks, isCapitol);
        this.diagonal = diagonal;
    }

    @Override
    public void onBlockBreak(ServerLevel level, BlockPos pos, boolean breakBlocks) {
        BlockState bs = level.m_8055_(pos);
        super.onBlockBreak(level, pos, breakBlocks);
        this.replaceWithLiquidBelow(pos, bs);
    }

    @Override
    public void destroy(ServerLevel serverLevel) {
        super.destroy(serverLevel);
        for (BuildingBlock bb : this.blocks) {
            if (bb.getBlockState().m_60734_() instanceof FenceBlock || bb.getBlockState().m_60734_() instanceof AirBlock) continue;
            this.replaceWithLiquidBelow(bb.getBlockPos(), bb.getBlockState());
        }
    }

    private void replaceWithLiquidBelow(BlockPos bp, BlockState bs) {
        if (!(bs.m_60734_() instanceof FenceBlock)) {
            for (BlockPos bpAdj : List.of(bp.m_7495_(), bp.m_122012_(), bp.m_122019_(), bp.m_122029_(), bp.m_122024_())) {
                BlockState bsAdj = this.level.m_8055_(bpAdj);
                if (bsAdj.m_60819_().m_76178_()) continue;
                this.level.m_46597_(bp, bsAdj);
            }
        }
    }

    public boolean isDiagonal() {
        return this.diagonal;
    }
}

