/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.placements;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.ResourceSource;
import com.solegendary.reignofnether.resources.ResourceSources;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesClientboundPacket;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class StockpilePlacement
extends ProductionPlacement {
    public ResourceName mostAbundantNearbyResource = ResourceName.NONE;

    public StockpilePlacement(Building building, Level level, BlockPos originPos, Rotation rotation, String ownerName, ArrayList<BuildingBlock> blocks, boolean isCapitol) {
        super(building, level, originPos, rotation, ownerName, blocks, isCapitol);
        this.findMostAbundantNearbyResource();
        this.findMostAbundantNearbyResource();
    }

    public void findMostAbundantNearbyResource() {
        int nearbyFoodBlocks = 0;
        int nearbyWoodBlocks = 0;
        int nearbyOreBlocks = 0;
        for (ResourceName resourceName : List.of(ResourceName.FOOD, ResourceName.WOOD, ResourceName.ORE)) {
            Predicate<BlockPos> BLOCK_CONDITION = bp -> {
                BlockState bs = this.getLevel().m_8055_(bp);
                BlockState bsAbove = this.getLevel().m_8055_(bp.m_7494_());
                ResourceSource resBlock = ResourceSources.getFromBlockPos(bp, this.getLevel());
                if (resBlock == null || resBlock.resourceName != resourceName || resBlock.name.equals("Farmland") || resBlock.name.equals("Soul Sand")) {
                    return false;
                }
                if (!resBlock.blockStateTest.test(bs)) {
                    return false;
                }
                if (BuildingUtils.isPosInsideAnyBuilding(this.getLevel().m_5776_(), bp)) {
                    return false;
                }
                boolean hasClearNeighbour = false;
                for (BlockPos adjBp : List.of(bp.m_122012_(), bp.m_122019_(), bp.m_122029_(), bp.m_122024_(), bp.m_7494_(), bp.m_7495_())) {
                    if (!ResourceSources.isClearMaterial(this.getLevel().m_8055_(adjBp))) continue;
                    hasClearNeighbour = true;
                }
                return hasClearNeighbour;
            };
            for (BlockPos bp2 : BlockPos.m_121925_((BlockPos)this.centrePos, (int)10, (int)5, (int)10)) {
                if (!BLOCK_CONDITION.test(bp2)) continue;
                switch (resourceName) {
                    case FOOD: {
                        ++nearbyFoodBlocks;
                        break;
                    }
                    case WOOD: {
                        ++nearbyWoodBlocks;
                        break;
                    }
                    case ORE: {
                        ++nearbyOreBlocks;
                    }
                }
            }
        }
        if (nearbyFoodBlocks > 0 && nearbyFoodBlocks >= nearbyWoodBlocks && nearbyFoodBlocks >= nearbyOreBlocks) {
            this.mostAbundantNearbyResource = ResourceName.FOOD;
        }
        if (nearbyWoodBlocks > 0 && nearbyWoodBlocks >= nearbyFoodBlocks && nearbyWoodBlocks >= nearbyOreBlocks) {
            this.mostAbundantNearbyResource = ResourceName.WOOD;
        }
        if (nearbyOreBlocks > 0 && nearbyOreBlocks >= nearbyFoodBlocks && nearbyOreBlocks >= nearbyWoodBlocks) {
            this.mostAbundantNearbyResource = ResourceName.ORE;
        }
    }

    public void checkAndConsumeChestItems() {
        if (!this.getLevel().m_5776_()) {
            BlockPos textPos = null;
            int food = 0;
            int wood = 0;
            int ore = 0;
            for (BuildingBlock block : this.getBlocks()) {
                BlockEntity blockEntity;
                if (block.getBlockState().m_60734_() != Blocks.f_50087_ || !((blockEntity = this.getLevel().m_7702_(block.getBlockPos())) instanceof ChestBlockEntity)) continue;
                ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                for (int i = 0; i < chest.f_59073_.size(); ++i) {
                    ResourceSource resource = ResourceSources.getFromItem(chest.m_8020_(i).m_41720_());
                    if (resource == null) continue;
                    int numItems = chest.m_8020_(i).m_41613_();
                    food += resource.resourceName == ResourceName.FOOD ? resource.resourceValue * numItems : 0;
                    wood += resource.resourceName == ResourceName.WOOD ? resource.resourceValue * numItems : 0;
                    ore += resource.resourceName == ResourceName.ORE ? resource.resourceValue * numItems : 0;
                    chest.m_7407_(i, numItems);
                    textPos = block.getBlockPos().m_7918_(0, -2, 0);
                }
            }
            if (food > 0 || wood > 0 || ore > 0) {
                Resources res = new Resources(this.ownerName, food, wood, ore);
                ResourcesServerEvents.addSubtractResources(res);
                ResourcesClientboundPacket.showFloatingText(res, textPos);
            }
        }
    }
}

