/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.shared;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.placements.BridgePlacement;
import com.solegendary.reignofnether.resources.ResourceCost;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;

public abstract class AbstractBridge
extends Building {
    public final float MELEE_DAMAGE_MULTIPLIER = 0.05f;

    public AbstractBridge(ResourceCost cost) {
        super("", cost, false);
    }

    @Override
    public float getMeleeDamageMult() {
        return 0.05f;
    }

    public ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level, boolean diagonal) {
        return BuildingBlockData.getBuildingBlocksFromNbt(diagonal ? this.getDiagonalStructureName() : this.getOrthogonalStructureName(), level);
    }

    @Override
    public BuildingPlacement createBuildingPlacement(Level level, BlockPos pos, Rotation rotation, String ownerName) {
        return this.createBuildingPlacement(level, pos, rotation, ownerName, false);
    }

    public BuildingPlacement createBuildingPlacement(Level level, BlockPos pos, Rotation rotation, String ownerName, boolean diagonal) {
        return new BridgePlacement(this, level, pos, rotation, "", AbstractBridge.getCulledBlocks(BuildingUtils.getAbsoluteBlockData(this.getRelativeBlockData((LevelAccessor)level, diagonal), (LevelAccessor)level, pos, rotation), level), this.isCapitol, diagonal);
    }

    public abstract String getDiagonalStructureName();

    public abstract String getOrthogonalStructureName();
}

