/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.custombuilding;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.blocks.RTSStructureBlockEntity;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.custombuilding.CustomBuilding;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CustomBuildingClientEvents {
    private static final ArrayList<CustomBuilding> customBuildings = new ArrayList();
    public static final ArrayList<BlockPos> rtsStructuresToRenderBB = new ArrayList();
    private static final Minecraft MC = Minecraft.m_91087_();

    public static Building findCustomBuilding(ResourceLocation rl) {
        for (CustomBuilding customBuilding : customBuildings) {
            if (!customBuilding.structureName.equals(rl.toString())) continue;
            return customBuilding;
        }
        return null;
    }

    public static void registerCustomBuilding(String name, BlockPos originPos, BlockPos structurePos, Vec3i structureSize) {
        boolean buildingExists = false;
        for (BuildingPlacement existingPlacement : BuildingClientEvents.getBuildings()) {
            if (!existingPlacement.originPos.equals((Object)originPos)) continue;
            buildingExists = true;
            break;
        }
        if (!buildingExists) {
            ArrayList<BuildingBlock> blocks = BuildingBlockData.getBuildingBlocksFromWorld((Level)CustomBuildingClientEvents.MC.f_91073_, originPos, structurePos, structureSize);
            int numSolidBlocks = 0;
            Block portraitBlock = Blocks.f_50272_;
            for (BuildingBlock bb : blocks) {
                BlockState bs = bb.getBlockState();
                if (bs.m_60795_() || !bs.m_60819_().m_76178_()) continue;
                ++numSolidBlocks;
                portraitBlock = bs.m_60734_();
            }
            if (numSolidBlocks == 0) {
                ReignOfNether.LOGGER.error("ERROR (server): cannot register custom building with no solid blocks");
            } else {
                CustomBuilding building = new CustomBuilding(name, structurePos, structureSize, portraitBlock);
                customBuildings.add(building);
                BuildingPlacement placement = new BuildingPlacement(building, (Level)CustomBuildingClientEvents.MC.f_91073_, originPos, Rotation.NONE, "", blocks, false);
                BuildingClientEvents.getBuildings().add(placement);
            }
        } else if (CustomBuildingClientEvents.MC.f_91074_ != null) {
            CustomBuildingClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)"ERROR: cannot register custom building at same origin as another building"));
        }
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent evt) throws NoSuchFieldException {
        if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS || CustomBuildingClientEvents.MC.f_91073_ == null) {
            return;
        }
        for (BlockPos bp : rtsStructuresToRenderBB) {
            BlockEntity blockEntity = CustomBuildingClientEvents.MC.f_91073_.m_7702_(bp);
            if (!(blockEntity instanceof RTSStructureBlockEntity)) continue;
            RTSStructureBlockEntity be = (RTSStructureBlockEntity)blockEntity;
            BlockPos pos = be.m_59902_();
            Vec3i size = be.m_155805_();
            MyRenderer.drawLineBox(evt.getPoseStack(), new AABB((double)(bp.m_123341_() + pos.m_123341_()), (double)(bp.m_123342_() + pos.m_123342_()), (double)(bp.m_123343_() + pos.m_123343_()), (double)(bp.m_123341_() + pos.m_123341_() + size.m_123341_()), (double)(bp.m_123342_() + pos.m_123342_() + size.m_123342_()), (double)(bp.m_123343_() + pos.m_123343_() + size.m_123343_())), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

