/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.config.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import com.solegendary.reignofnether.player.PlayerColors;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class ConfigColorButton
implements Renderable,
GuiEventListener,
NarratableEntry {
    protected static final Minecraft MC = Minecraft.m_91087_();
    private final ForgeConfigSpec.ConfigValue<Integer> configValue;
    private final String label;
    private int x = 0;
    private int y = 0;
    private int w = 10;
    private int h = 10;
    private boolean focused = false;

    public ConfigColorButton(ForgeConfigSpec.ConfigValue<Integer> configValue, String label) {
        this.configValue = configValue;
        this.label = label;
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        boolean hovering = this.m_5953_(pMouseX, pMouseY);
        ResourceLocation texture = PlayerColors.getColorIcon((Integer)this.configValue.get());
        if (!hovering && PlayerColors.isUsingPlayerColors()) {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
        }
        guiGraphics.m_280398_(texture, this.x, this.y + this.h / 2, 0, 0.0f, 0.0f, this.w, this.h / 2, this.w, this.h / 2);
        if (hovering) {
            MyRenderer.renderFrameWithBg(guiGraphics, this.x, this.y + this.h / 2, this.w, this.h / 2, 0);
            Font font = ConfigColorButton.MC.f_91062_;
            String string = (Integer)this.configValue.get() + 1 + "/" + PlayerColors.colors.length;
            int n = this.x + this.w / 2;
            int n2 = this.y + 3 * this.h / 4;
            Objects.requireNonNull(ConfigColorButton.MC.f_91062_);
            guiGraphics.m_280137_(font, string, n, n2 - 9 / 2, -1711276033);
        }
        Font font = ConfigColorButton.MC.f_91062_;
        int n = this.x + this.w / 2;
        int n3 = this.y + this.h / 4;
        Objects.requireNonNull(ConfigColorButton.MC.f_91062_);
        guiGraphics.m_280137_(font, this.label, n, n3 - 9 / 2, -1);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 2 || !this.m_5953_(pMouseX, pMouseY)) {
            return false;
        }
        if (pButton == 0) {
            this.configValue.set((Object)(((Integer)this.configValue.get() + 1) % PlayerColors.PLAYER_COLOR_TOTAL_COUNT));
        } else if (pButton == 1) {
            this.configValue.set((Object)(((Integer)this.configValue.get() + PlayerColors.PLAYER_COLOR_TOTAL_COUNT - 1) % PlayerColors.PLAYER_COLOR_TOTAL_COUNT));
        }
        return true;
    }

    public boolean m_5953_(double pMouseX, double pMouseY) {
        return !(pMouseX < (double)this.x || pMouseY < (double)this.y || pMouseX > (double)(this.x + this.w) || pMouseY > (double)(this.y + this.h));
    }

    public void m_93692_(boolean focused) {
        this.focused = focused;
    }

    public boolean m_93696_() {
        return this.focused;
    }

    @NotNull
    public ScreenRectangle m_264198_() {
        return new ScreenRectangle(this.x, this.y, this.w, this.h);
    }

    @NotNull
    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.HOVERED;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.HINT, (Component)Component.m_237113_((String)this.label));
    }

    public ConfigColorButton pos(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public ConfigColorButton size(int w, int h) {
        this.w = w;
        this.h = h;
        return this;
    }
}

