/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.fogofwar;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import com.solegendary.reignofnether.fogofwar.FogOfWarClientboundPacket;
import com.solegendary.reignofnether.fogofwar.FrozenChunkClientboundPacket;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FogOfWarServerEvents {
    private static boolean enabled = false;
    private static ServerLevel serverLevel = null;

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        FogOfWarServerEvents.syncClientFog();
    }

    public static void setEnabled(boolean value) {
        enabled = value;
        if (enabled) {
            PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.enabled_fog_of_war", true, new Object[0]);
        } else {
            PlayerServerEvents.sendMessageToAllPlayers("server.reignofnether.disabled_fog_of_war", true, new Object[0]);
        }
        FogOfWarServerEvents.syncClientFog();
    }

    public static boolean isEnabled() {
        return enabled;
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END || evt.level.m_5776_() || evt.level.m_46472_() != Level.f_46428_) {
            return;
        }
        serverLevel = (ServerLevel)evt.level;
    }

    @SubscribeEvent
    public static void onRegisterCommand(RegisterCommandsEvent evt) {
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-fog").then(Commands.m_82127_((String)"enable").executes(command -> {
            FogOfWarServerEvents.setEnabled(true);
            return 1;
        })));
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-fog").then(Commands.m_82127_((String)"disable").executes(command -> {
            FogOfWarServerEvents.setEnabled(false);
            return 1;
        })));
    }

    private static void syncClientFog() {
        FogOfWarClientboundPacket.setEnabled(enabled);
    }

    /*
     * WARNING - void declaration
     */
    public static void syncClientBlocks(BlockPos renderChunkOrigin) {
        BlockState bs;
        BlockPos bp;
        int z;
        if (serverLevel == null) {
            return;
        }
        ArrayList<Object> plants = new ArrayList<Object>();
        for (int x = 0; x < 16; ++x) {
            for (int i = 0; i < 16; ++i) {
                for (z = 0; z < 16; ++z) {
                    bp = renderChunkOrigin.m_7918_(x, i, z);
                    bs = serverLevel.m_8055_(bp);
                    if (!bs.m_204336_(BlockTags.f_278411_) && !(bs.m_60734_() instanceof IPlantable)) continue;
                    plants.add(new Pair((Object)bp, (Object)bs));
                }
            }
        }
        for (Pair pair : plants) {
            serverLevel.m_46597_((BlockPos)pair.getFirst(), Blocks.f_50016_.m_49966_());
        }
        for (int x = 0; x < 16; ++x) {
            void var3_10;
            boolean bl = false;
            while (var3_10 < 16) {
                for (z = 0; z < 16; ++z) {
                    bp = renderChunkOrigin.m_7918_(x, (int)var3_10, z);
                    bs = serverLevel.m_8055_(bp);
                    serverLevel.m_46597_(bp, Blocks.f_50752_.m_49966_());
                    serverLevel.m_46597_(bp, bs);
                }
                ++var3_10;
            }
        }
        plants.sort(Comparator.comparing(p -> ((BlockPos)((Pair)p).getFirst()).m_123342_()).reversed());
        for (Pair pair : plants) {
            serverLevel.m_46597_((BlockPos)pair.getFirst(), (BlockState)pair.getSecond());
        }
        FrozenChunkClientboundPacket.unmuteChunks();
    }
}

