/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.fogofwar;

import com.solegendary.reignofnether.fogofwar.FogOfWarClientEvents;
import com.solegendary.reignofnether.fogofwar.FrozenChunkAction;
import com.solegendary.reignofnether.registrars.PacketHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class FrozenChunkClientboundPacket {
    FrozenChunkAction action;
    BlockPos blockPos;

    public static void setBuildingDestroyedServerside(BlockPos buildingOrigin) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new FrozenChunkClientboundPacket(FrozenChunkAction.SET_BUILDING_DESTROYED, buildingOrigin));
    }

    public static void setBuildingBuiltServerside(BlockPos buildingOrigin) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new FrozenChunkClientboundPacket(FrozenChunkAction.SET_BUILDING_BUILT, buildingOrigin));
    }

    public static void unmuteChunks() {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new FrozenChunkClientboundPacket(FrozenChunkAction.UNMUTE, new BlockPos(0, 0, 0)));
    }

    public FrozenChunkClientboundPacket(FrozenChunkAction action, BlockPos blockPos) {
        this.action = action;
        this.blockPos = blockPos;
    }

    public FrozenChunkClientboundPacket(FriendlyByteBuf buffer) {
        this.action = (FrozenChunkAction)buffer.m_130066_(FrozenChunkAction.class);
        this.blockPos = buffer.m_130135_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.action);
        buffer.m_130064_(this.blockPos);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            switch (this.action) {
                case SET_BUILDING_DESTROYED: {
                    FogOfWarClientEvents.setBuildingDestroyedServerside(this.blockPos);
                    break;
                }
                case SET_BUILDING_BUILT: {
                    FogOfWarClientEvents.setBuildingBuiltServerside(this.blockPos);
                    break;
                }
                case UNMUTE: {
                    FogOfWarClientEvents.unmuteChunks();
                }
            }
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

