/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.gamemode;

import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.placements.BeaconPlacement;
import com.solegendary.reignofnether.gamemode.GameMode;
import com.solegendary.reignofnether.gamerules.GameruleClient;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.startpos.StartPosClientEvents;
import com.solegendary.reignofnether.startpos.StartPosServerboundPacket;
import com.solegendary.reignofnether.survival.SurvivalClientEvents;
import com.solegendary.reignofnether.survival.WaveDifficulty;
import com.solegendary.reignofnether.util.Faction;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ClientGameModeHelper {
    public static GameMode DEFAULT_GAMEMODE;
    public static GameMode gameMode;
    public static boolean gameModeLocked;

    public static void cycleGameMode() {
        if (gameModeLocked || GameruleClient.pvpModesOnly) {
            return;
        }
        if (StartPosClientEvents.hasReservedPos()) {
            StartPosClientEvents.selectedFaction = Faction.NONE;
            StartPosServerboundPacket.unreservePos(StartPosClientEvents.getPos().pos);
        }
        switch (gameMode) {
            case CLASSIC: {
                gameMode = GameMode.SURVIVAL;
                break;
            }
            case SURVIVAL: {
                gameMode = GameMode.SANDBOX;
                break;
            }
            default: {
                gameMode = GameMode.CLASSIC;
            }
        }
    }

    public static void cycleWaveDifficulty() {
        switch (SurvivalClientEvents.difficulty) {
            case BEGINNER: {
                SurvivalClientEvents.difficulty = WaveDifficulty.EASY;
                break;
            }
            case EASY: {
                SurvivalClientEvents.difficulty = WaveDifficulty.MEDIUM;
                break;
            }
            case MEDIUM: {
                SurvivalClientEvents.difficulty = WaveDifficulty.HARD;
                break;
            }
            case HARD: {
                SurvivalClientEvents.difficulty = WaveDifficulty.EXTREME;
                break;
            }
            case EXTREME: {
                SurvivalClientEvents.difficulty = WaveDifficulty.BEGINNER;
            }
        }
    }

    private static String getLockedString() {
        return gameModeLocked || GameruleClient.pvpModesOnly ? " " + I18n.m_118938_((String)"hud.gamemode.reignofnether.locked", (Object[])new Object[0]) : "";
    }

    private static boolean isKotB() {
        BeaconPlacement beacon = BuildingUtils.getBeacon(true);
        return beacon != null && beacon.getBuilding().capturable;
    }

    private static Button getClassicButton() {
        return new Button("Classic", Button.itemIconSize, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/grass_block_side.png"), (Keybinding)null, () -> false, () -> false, () -> !gameModeLocked && !GameruleClient.pvpModesOnly, null, ClientGameModeHelper::cycleGameMode, List.of(FormattedCharSequence.m_13714_((String)(I18n.m_118938_((String)"hud.gamemode.reignofnether.classic1", (Object[])new Object[0]) + ClientGameModeHelper.getLockedString()), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.gamemode.reignofnether.classic2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.gamemode.reignofnether.classic3", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.gamemode.reignofnether.changemode", (Object[])new Object[0]), (Style)Style.f_131099_)));
    }

    private static Button getKotbButton() {
        return new Button("King of the Beacon", Button.itemIconSize, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/nether_star.png"), (Keybinding)null, () -> false, () -> false, () -> !gameModeLocked && !GameruleClient.pvpModesOnly, null, ClientGameModeHelper::cycleGameMode, List.of(FormattedCharSequence.m_13714_((String)(I18n.m_118938_((String)"hud.gamemode.reignofnether.kotb1", (Object[])new Object[0]) + ClientGameModeHelper.getLockedString()), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.gamemode.reignofnether.kotb2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.gamemode.reignofnether.kotb3", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.gamemode.reignofnether.changemode", (Object[])new Object[0]), (Style)Style.f_131099_)));
    }

    public static Button getButton() {
        Button button;
        switch (gameMode) {
            case CLASSIC: {
                Button button2;
                if (ClientGameModeHelper.isKotB()) {
                    button2 = ClientGameModeHelper.getKotbButton();
                    break;
                }
                button2 = ClientGameModeHelper.getClassicButton();
                break;
            }
            case SURVIVAL: {
                Button button2 = new Button("Survival", Button.itemIconSize, switch (SurvivalClientEvents.difficulty) {
                    default -> throw new IncompatibleClassChangeError();
                    case WaveDifficulty.BEGINNER -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/wooden_sword.png");
                    case WaveDifficulty.EASY -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/stone_sword.png");
                    case WaveDifficulty.MEDIUM -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/iron_sword.png");
                    case WaveDifficulty.HARD -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/diamond_sword.png");
                    case WaveDifficulty.EXTREME -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/netherite_sword.png");
                }, (Keybinding)null, () -> false, () -> false, () -> !gameModeLocked && !GameruleClient.pvpModesOnly, ClientGameModeHelper::cycleWaveDifficulty, ClientGameModeHelper::cycleGameMode, List.of(FormattedCharSequence.m_13714_((String)(I18n.m_118938_((String)"hud.gamemode.reignofnether.survival1", (Object[])new Object[0]) + ClientGameModeHelper.getLockedString()), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.gamemode.reignofnether.survival5", (Object[])new Object[]{SurvivalClientEvents.difficulty, SurvivalClientEvents.getMinutesPerDay()}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.gamemode.reignofnether.survival2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.gamemode.reignofnether.survival3", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.gamemode.reignofnether.survival4", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.gamemode.reignofnether.survival6", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.gamemode.reignofnether.changemode", (Object[])new Object[0]), (Style)Style.f_131099_)));
                break;
            }
            case SANDBOX: {
                Button button2 = new Button("Sandbox", Button.itemIconSize, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/crafting_table_front.png"), (Keybinding)null, () -> false, () -> false, () -> !gameModeLocked && !GameruleClient.pvpModesOnly, null, ClientGameModeHelper::cycleGameMode, List.of(FormattedCharSequence.m_13714_((String)(I18n.m_118938_((String)"hud.gamemode.reignofnether.sandbox1", (Object[])new Object[0]) + ClientGameModeHelper.getLockedString()), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.gamemode.reignofnether.sandbox2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.gamemode.reignofnether.sandbox3", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.gamemode.reignofnether.sandbox4", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.gamemode.reignofnether.changemode", (Object[])new Object[0]), (Style)Style.f_131099_)));
                break;
            }
            default: {
                Button button2 = button = null;
            }
        }
        if (button != null) {
            button.tooltipOffsetY = 15;
        }
        return button;
    }

    static {
        gameMode = DEFAULT_GAMEMODE = GameMode.CLASSIC;
        gameModeLocked = false;
    }
}

