/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hud;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class AbilityButton
extends Button {
    public Ability ability;
    public String extraLabel = "";
    public int extraLabelColour = 0xFFFFFF;
    @Nullable
    private Unit unit;
    @Nullable
    private BuildingPlacement placement;

    public AbilityButton(String name, ResourceLocation rl, Keybinding hotkey, Supplier<Boolean> isSelected, Supplier<Boolean> isHidden, Supplier<Boolean> isEnabled, Runnable onLeftClick, Runnable onRightClick, List<FormattedCharSequence> tooltipLines, @Nullable Ability ability, Unit unit) {
        super(name, Button.itemIconSize, rl, hotkey, isSelected, isHidden, isEnabled, onLeftClick, onRightClick, tooltipLines);
        this.ability = ability;
        Runnable originalOnLeftClick = this.onLeftClick;
        this.onLeftClick = () -> {
            if (this.ability != null && this.ability.getCooldown(unit) > 0.0f && !this.ability.canBypassCooldown(unit)) {
                HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"hud.buttons.reignofnether.on_cooldown", (Object[])new Object[0]));
                return;
            }
            Ability patt2184$temp = this.ability;
            if (patt2184$temp instanceof HeroAbility) {
                HeroUnit hero;
                HeroAbility heroAbility = (HeroAbility)patt2184$temp;
                if (heroAbility.manaCost > 0 && unit instanceof HeroUnit && (hero = (HeroUnit)unit).getMana() < (float)heroAbility.manaCost) {
                    HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"hud.buttons.reignofnether.not_enough_mana", (Object[])new Object[0]));
                    return;
                }
            }
            if (originalOnLeftClick == null) return;
            originalOnLeftClick.run();
        };
        this.unit = unit;
    }

    public AbilityButton(String name, ResourceLocation rl, Keybinding hotkey, Supplier<Boolean> isSelected, Supplier<Boolean> isHidden, Supplier<Boolean> isEnabled, Runnable onLeftClick, Runnable onRightClick, List<FormattedCharSequence> tooltipLines, @Nullable Ability ability, BuildingPlacement placement) {
        super(name, Button.itemIconSize, rl, hotkey, isSelected, isHidden, isEnabled, onLeftClick, onRightClick, tooltipLines);
        this.ability = ability;
        Runnable originalOnLeftClick = this.onLeftClick;
        this.onLeftClick = () -> {
            if (this.ability != null && this.ability.getCooldown(placement) > 0.0f && !this.ability.canBypassCooldown(this.building)) {
                HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"hud.buttons.reignofnether.on_cooldown", (Object[])new Object[0]));
            } else if (originalOnLeftClick != null) {
                originalOnLeftClick.run();
            }
        };
        this.placement = placement;
    }

    @Override
    protected void renderHotkey(GuiGraphics guiGraphics, int x, int y) {
        if (this.ability == null || !this.ability.usesCharges()) {
            super.renderHotkey(guiGraphics, x, y);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (this.ability != null && this.ability.cooldownMax > 0.0f) {
            float cooldown = this.unit != null ? this.ability.getCooldown(this.unit) : this.ability.getCooldown(this.placement);
            this.greyPercent = 1.0f - cooldown / this.ability.cooldownMax;
        }
        super.render(guiGraphics, x, y, mouseX, mouseY);
        if (this.ability != null && this.ability.usesCharges()) {
            String chargeStr = String.valueOf(this.unit != null ? this.unit.getCharges(this.ability) : this.building.getCharges(this.ability));
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 2.0f);
            int colour = 0xFFFFFF;
            if ((this.unit != null ? this.unit.getCharges(this.ability) : this.building.getCharges(this.ability)) >= this.ability.maxCharges) {
                colour = 65280;
            } else if ((this.unit != null ? this.unit.getCharges(this.ability) : this.building.getCharges(this.ability)) <= 0) {
                colour = 0xFF0000;
            } else if ((this.unit != null ? this.unit.getCharges(this.ability) : this.building.getCharges(this.ability)) == 1) {
                colour = 0xFFFF00;
            }
            guiGraphics.m_280137_(this.MC.f_91062_, chargeStr, x + this.iconSize - 5 - chargeStr.length() * 4, y + this.iconSize - 1, colour);
            super.renderHotkey(guiGraphics, x, y);
        } else if (this.ability != null && !this.extraLabel.isBlank()) {
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 2.0f);
            guiGraphics.m_280137_(this.MC.f_91062_, this.extraLabel, x + this.iconSize - 7 - (this.extraLabel.length() >= 1 ? 0 : 5), y + this.iconSize - 1, this.extraLabelColour);
        }
    }
}

