/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hud.playerdisplay;

import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.RectZone;
import com.solegendary.reignofnether.hud.playerdisplay.DiplomacyPlayerDisplay;
import com.solegendary.reignofnether.player.PlayerColors;
import com.solegendary.reignofnether.player.RTSPlayer;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MyRenderer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractPlayerDisplay {
    private static final Minecraft MC = Minecraft.m_91087_();
    public final String playerName;
    public final Faction faction;
    @Nullable
    public final AbstractClientPlayer player;
    private int color;
    private int backgroundColor;
    public static final int PLAYER_FRAME_WIDTH = Button.DEFAULT_ICON_FRAME_SIZE * 6;
    public static final ResourceLocation defaultIconLocation = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/command_block_back.png");
    public static final ResourceLocation factionVillagerIconLocation = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/villager.png");
    public static final ResourceLocation factionMonsterIconLocation = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/creeper.png");
    public static final ResourceLocation factionPiglinIconLocation = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/grunt.png");

    public AbstractPlayerDisplay(RTSPlayer rtsPlayer) {
        ServerData server = MC.m_91089_();
        this.player = server != null ? (AbstractClientPlayer)AbstractPlayerDisplay.MC.f_91073_.m_6907_().stream().filter(p -> p.m_7755_().getString().equals(rtsPlayer.name)).findFirst().orElse(null) : (AbstractPlayerDisplay.MC.f_91074_.m_7755_().getString().equals(rtsPlayer.name) ? AbstractPlayerDisplay.MC.f_91074_ : null);
        this.faction = rtsPlayer.faction;
        this.playerName = rtsPlayer.name;
    }

    public AbstractPlayerDisplay(AbstractClientPlayer clientPlayer) {
        this.player = clientPlayer;
        this.playerName = clientPlayer.m_7755_().getString();
        this.faction = Faction.NONE;
    }

    public boolean isPlayerLoggedIn() {
        return MC.m_91403_() != null && MC.m_91403_().m_104938_(this.playerName) != null;
    }

    private void renderPlayer(GuiGraphics guiGraphics, int x, int y) {
        MyRenderer.renderFrameWithBg(guiGraphics, x, y, PLAYER_FRAME_WIDTH, Button.DEFAULT_ICON_FRAME_SIZE, this.backgroundColor);
        ResourceLocation factionIcon = switch (this.faction) {
            case Faction.VILLAGERS -> factionVillagerIconLocation;
            case Faction.MONSTERS -> factionMonsterIconLocation;
            case Faction.PIGLINS -> factionPiglinIconLocation;
            default -> null;
        };
        if (factionIcon != null) {
            MyRenderer.renderIcon(guiGraphics, factionIcon, x + 4, y + 4, Button.DEFAULT_ICON_SIZE);
        }
        if (this.player != null && this.player.m_108559_()) {
            ResourceLocation iconLocation = this.player.m_108560_();
            guiGraphics.m_280411_(iconLocation, x + Button.DEFAULT_ICON_FRAME_SIZE, y + 4, Button.DEFAULT_ICON_SIZE, Button.DEFAULT_ICON_SIZE, 8.0f, 8.0f, 8, 8, 64, 64);
            guiGraphics.m_280411_(iconLocation, x + Button.DEFAULT_ICON_FRAME_SIZE, y + 4, Button.DEFAULT_ICON_SIZE, Button.DEFAULT_ICON_SIZE, 40.0f, 8.0f, 8, 8, 64, 64);
        } else {
            MyRenderer.renderIcon(guiGraphics, defaultIconLocation, x + Button.DEFAULT_ICON_FRAME_SIZE, y + 4, Button.DEFAULT_ICON_SIZE);
        }
        guiGraphics.m_280488_(AbstractPlayerDisplay.MC.f_91062_, this.playerName, x + Button.DEFAULT_ICON_FRAME_SIZE * 2, y + Button.DEFAULT_ICON_SIZE / 2 + 1, 0xFFFFFF);
        if (!this.isPlayerLoggedIn()) {
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
            guiGraphics.m_280509_(x, y, x + PLAYER_FRAME_WIDTH, y + Button.DEFAULT_ICON_FRAME_SIZE, -1728053248);
        }
    }

    public void render(GuiGraphics guiGraphics, int x, int y) {
        DiplomacyPlayerDisplay dpd;
        int playerColorHex = PlayerColors.getPlayerColorHex(this.playerName);
        this.color = 0xFF000000 | playerColorHex;
        this.backgroundColor = 0xA0000000 | playerColorHex;
        AbstractPlayerDisplay abstractPlayerDisplay = this;
        if (abstractPlayerDisplay instanceof DiplomacyPlayerDisplay && !(dpd = (DiplomacyPlayerDisplay)abstractPlayerDisplay).isRTSPlayer()) {
            this.backgroundColor = -1728053248;
        }
        this.renderPlayer(guiGraphics, x, y);
    }

    public RectZone getRectZone(int blitX, int blitY, int borderWidth) {
        return new RectZone(blitX, blitY, blitX, blitY);
    }
}

