/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hud.playerdisplay;

import com.solegendary.reignofnether.alliance.AllianceAction;
import com.solegendary.reignofnether.alliance.AllianceServerboundPacket;
import com.solegendary.reignofnether.alliance.AlliancesClient;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.RectZone;
import com.solegendary.reignofnether.hud.playerdisplay.AbstractPlayerDisplay;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.player.PlayerClientEvents;
import com.solegendary.reignofnether.player.PlayerColors;
import com.solegendary.reignofnether.player.RTSPlayer;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesClientEvents;
import com.solegendary.reignofnether.resources.ResourcesServerboundPacket;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class DiplomacyPlayerDisplay
extends AbstractPlayerDisplay {
    private static final Minecraft MC = Minecraft.m_91087_();
    private Resources resourcesToSend = new Resources("", 0, 0, 0);
    private static final int RESOURCE_FRAME_WIDTH = Button.DEFAULT_ICON_FRAME_SIZE * 2;
    private static final int ALLIANCE_FRAME_WIDTH = Button.DEFAULT_ICON_FRAME_SIZE * 4;
    public static final int DISPLAY_WIDTH = PLAYER_FRAME_WIDTH + RESOURCE_FRAME_WIDTH * 4 + (int)((float)Button.DEFAULT_ICON_FRAME_SIZE * 2.5f) + ALLIANCE_FRAME_WIDTH;
    private final Button gotoFpvPlayerButton = new Button("Go to player", Button.DEFAULT_ICON_SIZE, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/map.png"), (Keybinding)null, () -> false, () -> false, this::isAllied, () -> {
        if (this.player != null) {
            OrthoviewClientEvents.centreCameraOnPos(this.player.m_20182_());
        }
    }, null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"alliances.reignofnether.tooltip.goto_player", (Object[])new Object[0]), (Style)Style.f_131099_)));

    public DiplomacyPlayerDisplay(RTSPlayer rtsPlayer) {
        super(rtsPlayer);
        this.resourcesToSend = new Resources(rtsPlayer.name, 0, 0, 0);
    }

    public DiplomacyPlayerDisplay(AbstractClientPlayer player) {
        super(player);
    }

    private boolean isAllied() {
        return DiplomacyPlayerDisplay.MC.f_91074_ != null && AlliancesClient.isAllied(DiplomacyPlayerDisplay.MC.f_91074_.m_7755_().getString(), this.playerName);
    }

    protected boolean isRTSPlayer() {
        return PlayerClientEvents.isRTSPlayer(this.playerName);
    }

    private boolean allianceRequested() {
        return AlliancesClient.outboundPendingAlliances.contains(this.playerName);
    }

    private boolean allianceReceived() {
        return AlliancesClient.inboundPendingAlliances.contains(this.playerName);
    }

    private Button renderTradeResources(GuiGraphics guiGraphics, ResourceName resourceName, int x, int y, int mouseX, int mouseY) {
        String value;
        String iconPath;
        int color = switch (resourceName) {
            case ResourceName.FOOD -> {
                iconPath = "textures/icons/items/wheat.png";
                value = String.valueOf(this.resourcesToSend.food);
                yield 15252575;
            }
            case ResourceName.WOOD -> {
                iconPath = "textures/icons/items/wood.png";
                value = String.valueOf(this.resourcesToSend.wood);
                yield 10712379;
            }
            default -> {
                iconPath = "textures/icons/items/iron_ore.png";
                value = String.valueOf(this.resourcesToSend.ore);
                yield 16774381;
            }
        };
        MyRenderer.renderFrameWithBg(guiGraphics, x, y, RESOURCE_FRAME_WIDTH, Button.DEFAULT_ICON_FRAME_SIZE, -1610612736);
        guiGraphics.m_280488_(DiplomacyPlayerDisplay.MC.f_91062_, value, x + Button.DEFAULT_ICON_SIZE / 2 + 1, y + Button.DEFAULT_ICON_SIZE / 2 + 1, color);
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/corner_plus.png");
        Keybinding keybinding = null;
        Supplier<Boolean> supplier = () -> false;
        Supplier<Boolean> supplier2 = () -> false;
        Supplier<Boolean> supplier3 = this::isPlayerLoggedIn;
        Runnable runnable = () -> {
            switch (resourceName) {
                case FOOD: {
                    this.resourcesToSend.food = this.resourcesToSend.food + (Keybindings.shiftMod.isDown() ? 1000 : 100);
                    break;
                }
                case WOOD: {
                    this.resourcesToSend.wood = this.resourcesToSend.wood + (Keybindings.shiftMod.isDown() ? 1000 : 100);
                    break;
                }
                default: {
                    this.resourcesToSend.ore = this.resourcesToSend.ore + (Keybindings.shiftMod.isDown() ? 1000 : 100);
                }
            }
            Resources res = ResourcesClientEvents.getOwnResources();
            if (res != null) {
                this.resourcesToSend.food = Math.min(this.resourcesToSend.food, res.food);
                this.resourcesToSend.wood = Math.min(this.resourcesToSend.wood, res.wood);
                this.resourcesToSend.ore = Math.min(this.resourcesToSend.ore, res.ore);
            }
        };
        Runnable runnable2 = () -> {
            switch (resourceName) {
                case FOOD: {
                    this.resourcesToSend.food = this.resourcesToSend.food - (Keybindings.shiftMod.isDown() ? 1000 : 100);
                    break;
                }
                case WOOD: {
                    this.resourcesToSend.wood = this.resourcesToSend.wood - (Keybindings.shiftMod.isDown() ? 1000 : 100);
                    break;
                }
                default: {
                    this.resourcesToSend.ore = this.resourcesToSend.ore - (Keybindings.shiftMod.isDown() ? 1000 : 100);
                }
            }
            this.resourcesToSend.food = Math.max(this.resourcesToSend.food, 0);
            this.resourcesToSend.wood = Math.max(this.resourcesToSend.wood, 0);
            this.resourcesToSend.ore = Math.max(this.resourcesToSend.ore, 0);
        };
        Button changeResourceButton = new Button("Change resources", Button.DEFAULT_ICON_SIZE, resourceLocation, keybinding, supplier, supplier2, supplier3, runnable, runnable2, switch (resourceName) {
            default -> throw new IncompatibleClassChangeError();
            case ResourceName.FOOD -> List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"alliances.reignofnether.tooltip.send_food", (Object[])new Object[0]), (Style)Style.f_131099_));
            case ResourceName.WOOD -> List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"alliances.reignofnether.tooltip.send_wood", (Object[])new Object[0]), (Style)Style.f_131099_));
            case ResourceName.ORE -> List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"alliances.reignofnether.tooltip.send_ore", (Object[])new Object[0]), (Style)Style.f_131099_));
            case ResourceName.NONE -> null;
        });
        changeResourceButton.bgIconResource = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)iconPath);
        changeResourceButton.render(guiGraphics, x + RESOURCE_FRAME_WIDTH, y, mouseX, mouseY);
        if (!this.isPlayerLoggedIn()) {
            guiGraphics.m_280509_(x, y, x + RESOURCE_FRAME_WIDTH, y + Button.DEFAULT_ICON_FRAME_SIZE, -1728053248);
        }
        return changeResourceButton;
    }

    private List<Button> renderTradeConfirms(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        Button confirmButton = new Button("Confirm trade", Button.DEFAULT_ICON_SIZE, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/tick.png"), (Keybinding)null, () -> false, () -> false, () -> this.resourcesToSend.getTotalValue() > 0 && this.isPlayerLoggedIn(), this::sendResources, null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"alliances.reignofnether.tooltip.confirm_send_resources", (Object[])new Object[0]), (Style)Style.f_131099_)));
        confirmButton.render(guiGraphics, x, y, mouseX, mouseY);
        Button cancelButton = new Button("Cancel trade", Button.DEFAULT_ICON_SIZE, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/cross.png"), (Keybinding)null, () -> false, () -> false, () -> this.resourcesToSend.getTotalValue() > 0, this::resetResources, null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"alliances.reignofnether.tooltip.cancel_send_resources", (Object[])new Object[0]), (Style)Style.f_131099_)));
        cancelButton.render(guiGraphics, x + Button.DEFAULT_ICON_FRAME_SIZE, y, mouseX, mouseY);
        return List.of(confirmButton, cancelButton);
    }

    private Button renderAllianceButton(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        Button renderedButton;
        Object allianceStatusStr;
        Button allyRequestButton = new Button("Request Alliance", Button.DEFAULT_ICON_SIZE, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/sweet_berries.png"), (Keybinding)null, () -> false, () -> false, this::isPlayerLoggedIn, this::requestAlliance, null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"alliances.reignofnether.tooltip.request_alliance", (Object[])new Object[0]), (Style)Style.f_131099_)));
        Button allyCancelRequestButton = new Button("Cancel Request Alliance", Button.DEFAULT_ICON_SIZE, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/cross.png"), (Keybinding)null, () -> false, () -> false, () -> true, this::cancelAllianceRequest, null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"alliances.reignofnether.tooltip.cancel_request_alliance", (Object[])new Object[0]), (Style)Style.f_131099_)));
        allyCancelRequestButton.bgIconResource = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/sweet_berries.png");
        Button allyConfirmButton = new Button("Accept Alliance", Button.DEFAULT_ICON_SIZE, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/tick.png"), (Keybinding)null, () -> false, () -> false, () -> true, this::acceptAllianceRequest, null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"alliances.reignofnether.tooltip.accept_alliance", (Object[])new Object[0]), (Style)Style.f_131099_)));
        Button disbandButton = new Button("Disband Alliance", Button.DEFAULT_ICON_SIZE, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/crossed_swords.png"), (Keybinding)null, () -> false, () -> false, this::isAllied, this::disbandAlliance, null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"alliances.reignofnether.tooltip.disband_alliance", (Object[])new Object[0]), (Style)Style.f_131099_)));
        int frameBgColour = 0xA0000000 | PlayerColors.getPlayerAllianceColorHex(this.playerName);
        int frameWidth = 50;
        if (!(this.isAllied() || this.allianceRequested() || this.allianceReceived())) {
            allianceStatusStr = "Enemy";
            allyRequestButton.render(guiGraphics, x, y, mouseX, mouseY);
            renderedButton = allyRequestButton;
            frameWidth = 46;
        } else if (!this.isAllied() && this.allianceRequested()) {
            allianceStatusStr = "Requested";
            allyCancelRequestButton.render(guiGraphics, x, y, mouseX, mouseY);
            renderedButton = allyCancelRequestButton;
            frameWidth = 67;
        } else if (!this.isAllied() && this.allianceReceived()) {
            allianceStatusStr = "Accept?";
            allyConfirmButton.render(guiGraphics, x, y, mouseX, mouseY);
            renderedButton = allyConfirmButton;
            frameWidth = 55;
        } else {
            allianceStatusStr = "Allied";
            disbandButton.render(guiGraphics, x, y, mouseX, mouseY);
            renderedButton = disbandButton;
            frameWidth = 41;
            if (AlliancesClient.canControlAlly(this.playerName)) {
                allianceStatusStr = (String)allianceStatusStr + " (s)";
                frameWidth = 58;
            }
        }
        MyRenderer.renderFrameWithBg(guiGraphics, x + Button.DEFAULT_ICON_FRAME_SIZE, y, frameWidth, Button.DEFAULT_ICON_FRAME_SIZE, frameBgColour);
        guiGraphics.m_280488_(DiplomacyPlayerDisplay.MC.f_91062_, (String)allianceStatusStr, x + Button.DEFAULT_ICON_FRAME_SIZE + Button.DEFAULT_ICON_SIZE / 2 + 1, y + Button.DEFAULT_ICON_SIZE / 2 + 1, 0xFFFFFF);
        if (!this.isPlayerLoggedIn()) {
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
            guiGraphics.m_280509_(x + Button.DEFAULT_ICON_FRAME_SIZE, y, x + Button.DEFAULT_ICON_FRAME_SIZE * 2 + 4 + ((String)allianceStatusStr).length() * 4, y + Button.DEFAULT_ICON_FRAME_SIZE, -1728053248);
        }
        return renderedButton;
    }

    private void sendResources() {
        if (DiplomacyPlayerDisplay.MC.f_91074_ != null) {
            ResourcesServerboundPacket.sendResources(this.resourcesToSend, DiplomacyPlayerDisplay.MC.f_91074_.m_7755_().getString());
            this.resetResources();
        }
    }

    private void resetResources() {
        this.resourcesToSend.food = 0;
        this.resourcesToSend.wood = 0;
        this.resourcesToSend.ore = 0;
    }

    private void requestAlliance() {
        AllianceServerboundPacket.doAllianceAction(AllianceAction.REQUEST, this.playerName);
        AlliancesClient.outboundPendingAlliances.add(this.playerName);
    }

    private void cancelAllianceRequest() {
        AllianceServerboundPacket.doAllianceAction(AllianceAction.CANCEL_REQUEST, this.playerName);
        AlliancesClient.outboundPendingAlliances.removeIf(p -> p.equals(this.playerName));
    }

    private void acceptAllianceRequest() {
        AllianceServerboundPacket.doAllianceAction(AllianceAction.ACCEPT_REQUEST, this.playerName);
    }

    private void disbandAlliance() {
        AllianceServerboundPacket.doAllianceAction(AllianceAction.DISBAND, this.playerName);
    }

    public ArrayList<Button> render(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        super.render(guiGraphics, x, y);
        ArrayList<Button> renderedButtons = new ArrayList<Button>();
        x += PLAYER_FRAME_WIDTH;
        if (this.isRTSPlayer()) {
            renderedButtons.add(this.renderTradeResources(guiGraphics, ResourceName.FOOD, x, y, mouseX, mouseY));
            renderedButtons.add(this.renderTradeResources(guiGraphics, ResourceName.WOOD, x += RESOURCE_FRAME_WIDTH + Button.DEFAULT_ICON_FRAME_SIZE, y, mouseX, mouseY));
            renderedButtons.add(this.renderTradeResources(guiGraphics, ResourceName.ORE, x += RESOURCE_FRAME_WIDTH + Button.DEFAULT_ICON_FRAME_SIZE, y, mouseX, mouseY));
            x = (int)((float)x + ((float)RESOURCE_FRAME_WIDTH + (float)Button.DEFAULT_ICON_FRAME_SIZE * 1.25f));
            renderedButtons.addAll(this.renderTradeConfirms(guiGraphics, x, y, mouseX, mouseY));
            x = (int)((float)x + (float)Button.DEFAULT_ICON_FRAME_SIZE * 2.25f);
        } else {
            this.gotoFpvPlayerButton.render(guiGraphics, x, y, mouseX, mouseY);
            renderedButtons.add(this.gotoFpvPlayerButton);
            x = (int)((float)x + (float)Button.DEFAULT_ICON_FRAME_SIZE * 1.25f);
        }
        renderedButtons.add(this.renderAllianceButton(guiGraphics, x, y, mouseX, mouseY));
        return renderedButtons;
    }

    @Override
    public RectZone getRectZone(int blitX, int blitY, int borderWidth) {
        return new RectZone(blitX - borderWidth, blitY - borderWidth, blitX + DISPLAY_WIDTH + borderWidth, blitY + Button.DEFAULT_ICON_FRAME_SIZE + borderWidth);
    }
}

