/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hud.playerdisplay;

import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.RectZone;
import com.solegendary.reignofnether.hud.playerdisplay.AbstractPlayerDisplay;
import com.solegendary.reignofnether.player.PlayerColors;
import com.solegendary.reignofnether.player.RTSPlayer;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesClientEvents;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.util.MyRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class ObserverPlayerDisplay
extends AbstractPlayerDisplay {
    private static final Minecraft MC = Minecraft.m_91087_();
    public final Resources resources;
    private static final int RESOURCE_FRAME_WIDTH = Button.DEFAULT_ICON_FRAME_SIZE * 3;
    private static final int SUPPLY_DETAIL_FRAME_WIDTH = Button.DEFAULT_ICON_FRAME_SIZE * 4;
    public static final int DISPLAY_WIDTH = PLAYER_FRAME_WIDTH + RESOURCE_FRAME_WIDTH * 4 + SUPPLY_DETAIL_FRAME_WIDTH;
    private static final int frameBgColour = -1610612736;

    public ObserverPlayerDisplay(RTSPlayer rtsPlayer) {
        super(rtsPlayer);
        this.resources = ResourcesClientEvents.getResources(rtsPlayer.name);
    }

    private void renderResource(GuiGraphics guiGraphics, int x, int y, ResourceName resource) {
        Object value;
        ResourceLocation icon;
        int color = 0xFFFFFF;
        switch (resource) {
            case FOOD: {
                icon = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/wheat.png");
                value = String.valueOf(this.resources.food);
                color = 15252575;
                break;
            }
            case WOOD: {
                icon = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/wood.png");
                value = String.valueOf(this.resources.wood);
                color = 10712379;
                break;
            }
            case ORE: {
                icon = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/iron_ore.png");
                value = String.valueOf(this.resources.ore);
                color = 16774381;
                break;
            }
            default: {
                icon = PlayerColors.getPlayerColorBedIcon(this.playerName);
                int used = UnitClientEvents.getCurrentPopulation(this.playerName);
                int produced = BuildingClientEvents.getTotalPopulationSupply(this.playerName);
                value = used + "/" + produced;
                color = used > produced ? 0xFF0000 : 0xFFFFFF;
            }
        }
        MyRenderer.renderFrameWithBg(guiGraphics, x, y, RESOURCE_FRAME_WIDTH, Button.DEFAULT_ICON_FRAME_SIZE, -1610612736);
        MyRenderer.renderIcon(guiGraphics, icon, x + 4, y + 4, Button.DEFAULT_ICON_SIZE);
        guiGraphics.m_280488_(ObserverPlayerDisplay.MC.f_91062_, (String)value, x + Button.DEFAULT_ICON_FRAME_SIZE, y + Button.DEFAULT_ICON_SIZE / 2 + 1, color);
        if (!this.isPlayerLoggedIn()) {
            guiGraphics.m_280509_(x, y, x + RESOURCE_FRAME_WIDTH, y + Button.DEFAULT_ICON_FRAME_SIZE, -1728053248);
        }
    }

    private void renderSupplyDetail(GuiGraphics guiGraphics, int x, int y) {
        int civilianSupply = 0;
        int militarySupply = 0;
        for (LivingEntity entities : UnitClientEvents.getAllUnits()) {
            Unit unit;
            if (!(entities instanceof Unit) || !this.playerName.equals((unit = (Unit)entities).getOwnerName())) continue;
            if (unit instanceof WorkerUnit) {
                civilianSupply += unit.getCost().population;
                continue;
            }
            militarySupply += unit.getCost().population;
        }
        MyRenderer.renderFrameWithBg(guiGraphics, x, y, SUPPLY_DETAIL_FRAME_WIDTH, Button.DEFAULT_ICON_FRAME_SIZE, -1610612736);
        MyRenderer.renderIcon(guiGraphics, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/shovel.png"), x + 4, y + 4, Button.DEFAULT_ICON_SIZE);
        guiGraphics.m_280488_(ObserverPlayerDisplay.MC.f_91062_, "" + civilianSupply, x + Button.DEFAULT_ICON_FRAME_SIZE, y + Button.DEFAULT_ICON_SIZE / 2 + 1, 0xFFFFFF);
        MyRenderer.renderIcon(guiGraphics, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/sword_and_bow.png"), x + SUPPLY_DETAIL_FRAME_WIDTH / 2 + 4, y + 4, Button.DEFAULT_ICON_SIZE);
        guiGraphics.m_280488_(ObserverPlayerDisplay.MC.f_91062_, "" + militarySupply, x + SUPPLY_DETAIL_FRAME_WIDTH / 2 + Button.DEFAULT_ICON_FRAME_SIZE, y + Button.DEFAULT_ICON_SIZE / 2 + 1, 0xFFFFFF);
        if (!this.isPlayerLoggedIn()) {
            guiGraphics.m_280509_(x, y, x + SUPPLY_DETAIL_FRAME_WIDTH, y + Button.DEFAULT_ICON_FRAME_SIZE, -1728053248);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y) {
        super.render(guiGraphics, x, y);
        this.renderResource(guiGraphics, x += PLAYER_FRAME_WIDTH, y, ResourceName.FOOD);
        this.renderResource(guiGraphics, x += RESOURCE_FRAME_WIDTH, y, ResourceName.WOOD);
        this.renderResource(guiGraphics, x += RESOURCE_FRAME_WIDTH, y, ResourceName.ORE);
        this.renderResource(guiGraphics, x += RESOURCE_FRAME_WIDTH, y, ResourceName.NONE);
        this.renderSupplyDetail(guiGraphics, x += RESOURCE_FRAME_WIDTH, y);
    }

    @Override
    public RectZone getRectZone(int blitX, int blitY, int borderWidth) {
        return new RectZone(blitX - borderWidth, blitY - borderWidth, blitX + DISPLAY_WIDTH + borderWidth, blitY + Button.DEFAULT_ICON_FRAME_SIZE + borderWidth);
    }
}

