/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.resources;

import com.solegendary.reignofnether.resources.ResourceSource;
import com.solegendary.reignofnether.resources.ResourceSources;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class Resources {
    public String ownerName;
    public int food;
    public int wood;
    public int ore;
    public int foodToAdd = 0;
    public int woodToAdd = 0;
    public int oreToAdd = 0;

    public Resources(String ownerName, int food, int wood, int ore) {
        this.ownerName = ownerName;
        this.food = food;
        this.wood = wood;
        this.ore = ore;
    }

    public int getTotalValue() {
        return this.food + this.foodToAdd + this.wood + this.woodToAdd + this.ore + this.oreToAdd;
    }

    public void changeOverTime(int food, int wood, int ore) {
        this.foodToAdd += food;
        this.woodToAdd += wood;
        this.oreToAdd += ore;
    }

    public void changeInstantly(int food, int wood, int ore) {
        this.food += food;
        this.wood += wood;
        this.ore += ore;
    }

    public void tick() {
        this.food += this.getDrainPerTick(this.foodToAdd);
        this.foodToAdd -= this.getDrainPerTick(this.foodToAdd);
        this.wood += this.getDrainPerTick(this.woodToAdd);
        this.woodToAdd -= this.getDrainPerTick(this.woodToAdd);
        this.ore += this.getDrainPerTick(this.oreToAdd);
        this.oreToAdd -= this.getDrainPerTick(this.oreToAdd);
    }

    private int getDrainPerTick(int totalToAdd) {
        int absVal = Math.abs(totalToAdd);
        int retVal = 0;
        if (absVal > 10) {
            retVal = Math.round((float)absVal / 10.0f);
        } else if (absVal > 0) {
            retVal = 1;
        }
        return (int)Math.signum(totalToAdd) * retVal;
    }

    public static Resources getTotalResourcesFromItems(List<ItemStack> itemStacks) {
        Resources resources = new Resources("", 0, 0, 0);
        for (ItemStack itemStack : itemStacks) {
            ResourceSource source = ResourceSources.getFromItem(itemStack.m_41720_());
            if (source == null) continue;
            int value = source.resourceValue * itemStack.m_41613_();
            switch (source.resourceName) {
                case FOOD: {
                    resources.changeInstantly(value, 0, 0);
                    break;
                }
                case WOOD: {
                    resources.changeInstantly(0, value, 0);
                    break;
                }
                case ORE: {
                    resources.changeInstantly(0, 0, value);
                }
            }
        }
        return resources;
    }
}

