/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.resources;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.ResourceSource;
import com.solegendary.reignofnether.resources.ResourceSources;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ResourcesClientEvents {
    public static ArrayList<Resources> resourcesList = new ArrayList();
    private static final Minecraft MC = Minecraft.m_91087_();
    public static final List<FloatingText> floatingTexts = new ArrayList<FloatingText>();
    public static final int FLOATING_TEXT_MAX_AGE = 200;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        for (Resources resources : resourcesList) {
            resources.tick();
        }
    }

    @SubscribeEvent
    public static void onClientTick(ScreenEvent.Render evt) {
        BlockPos preSelBp;
        ResourceSource res;
        WorkerUnit workerUnit;
        LivingEntity livingEntity = HudClientEvents.hudSelectedEntity;
        if (livingEntity instanceof WorkerUnit && UnitClientEvents.getPlayerToEntityRelationship((LivingEntity)(workerUnit = (WorkerUnit)livingEntity)) == Relationship.OWNED && ResourcesClientEvents.MC.f_91073_ != null && (res = ResourceSources.getFromBlockPos(preSelBp = CursorClientEvents.getPreselectedBlockPos(), (Level)ResourcesClientEvents.MC.f_91073_)) != null && res.resourceValue > 0 && !BuildingUtils.isPosInsideAnyBuilding(true, preSelBp)) {
            String str = switch (res.resourceName) {
                default -> throw new IncompatibleClassChangeError();
                case ResourceName.FOOD -> "\ue000  " + res.resourceValue;
                case ResourceName.WOOD -> "\ue001  " + res.resourceValue;
                case ResourceName.ORE -> "\ue002  " + res.resourceValue;
                case ResourceName.NONE -> "";
            };
            MyRenderer.renderTooltip(evt.getGuiGraphics(), List.of(FormattedCharSequence.m_13714_((String)str, (Style)MyRenderer.iconStyle)), evt.getMouseX(), evt.getMouseY());
        }
    }

    public static void syncResources(Resources serverResources) {
        resourcesList.removeIf(resources -> resources.ownerName.equals(serverResources.ownerName));
        resourcesList.add(serverResources);
    }

    public static void addSubtractResources(Resources serverResources) {
        for (Resources resources : resourcesList) {
            if (!resources.ownerName.equals(serverResources.ownerName)) continue;
            resources.changeOverTime(serverResources.food, serverResources.wood, serverResources.ore);
        }
    }

    public static void addSubtractResourcesInstantly(Resources serverResources) {
        for (Resources resources : resourcesList) {
            if (!resources.ownerName.equals(serverResources.ownerName)) continue;
            resources.changeInstantly(serverResources.food, serverResources.wood, serverResources.ore);
        }
    }

    public static Resources getOwnResources() {
        Minecraft MC = Minecraft.m_91087_();
        if (MC.f_91074_ != null) {
            return ResourcesClientEvents.getResources(MC.f_91074_.m_7755_().getString());
        }
        return null;
    }

    public static Resources getResources(String playerName) {
        for (Resources resources : resourcesList) {
            if (!resources.ownerName.equals(playerName)) continue;
            return resources;
        }
        return null;
    }

    public static void showWarning(String ownerName, String msg) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_7755_().getString().equals(ownerName)) {
            String loc = I18n.m_118938_((String)msg, (Object[])new Object[0]);
            HudClientEvents.showTemporaryMessage(loc);
            if (msg.contains("not_enough")) {
                for (LivingEntity entity : UnitClientEvents.getSelectedUnits()) {
                    Unit unit;
                    if (!(entity instanceof Unit) || !((Entity)(unit = (Unit)entity)).m_9236_().m_5776_() || Keybindings.shiftMod.isDown()) continue;
                    unit.getCheckpoints().clear();
                }
            }
        }
    }

    public static void addFloatingTextsFromResources(Resources res, BlockPos pos) {
        if (!OrthoviewClientEvents.isEnabled()) {
            return;
        }
        if (!Minecraft.m_91087_().f_91074_.m_7755_().getString().equals(res.ownerName)) {
            return;
        }
        int tickAge = 0;
        if (res.food > 0) {
            floatingTexts.add(new FloatingText("+" + res.food + "  \ue000", pos, tickAge));
            tickAge -= 25;
        }
        if (res.wood > 0) {
            floatingTexts.add(new FloatingText("+" + res.wood + "  \ue001", pos, tickAge));
            tickAge -= 25;
        }
        if (res.ore > 0) {
            floatingTexts.add(new FloatingText("+" + res.ore + "  \ue002", pos, tickAge));
        }
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent evt) {
        if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        for (FloatingText floatingText : floatingTexts) {
            if (floatingText.tickAge > 0) {
                Minecraft MC = Minecraft.m_91087_();
                MutableComponent component = Component.m_237113_((String)floatingText.text).m_130948_(MyRenderer.iconStyle);
                PoseStack poseStack = evt.getPoseStack();
                Camera camera = MC.m_91290_().f_114358_;
                Vec3 camPos = camera.m_90583_();
                poseStack.m_85836_();
                poseStack.m_85837_((double)floatingText.pos.m_123341_() - camPos.m_7096_(), (double)floatingText.pos.m_123342_() - camPos.m_7098_() + 2.5 + (double)((float)floatingText.tickAge / 20.0f), (double)floatingText.pos.m_123343_() - camPos.m_7094_());
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-camera.m_90590_()));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(camera.m_90589_()));
                if (OrthoviewClientEvents.isEnabled()) {
                    poseStack.m_85841_(-0.075f, -0.075f, 0.075f);
                } else {
                    poseStack.m_85841_(-0.05f, -0.05f, 0.05f);
                }
                Font font = MC.f_91062_;
                float f2 = -font.m_92852_((FormattedText)component) / 2;
                float f1 = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
                float alphaPercent = (float)(200 - floatingText.tickAge) * 1.5f / 200.0f;
                if ((double)alphaPercent < 0.05) {
                    alphaPercent = 0.05f;
                }
                if (alphaPercent > 1.0f) {
                    alphaPercent = 1.0f;
                }
                int textCol = 0xFFFFFF + ((int)(255.0f * alphaPercent) << 24);
                int bgCol = (int)(f1 * 255.0f * alphaPercent) << 24;
                font.m_272077_((Component)component, f2, 0.0f, textCol, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)MC.m_91269_().m_110104_(), Font.DisplayMode.NORMAL, bgCol, 255);
                poseStack.m_85849_();
            }
            ++floatingText.tickAge;
        }
        floatingTexts.removeIf(t -> t.tickAge > 200);
    }

    private static class FloatingText {
        String text;
        BlockPos pos;
        int tickAge;

        public FloatingText(String text, BlockPos pos, int tickAge) {
            this.text = text;
            this.pos = pos;
            this.tickAge = tickAge;
        }
    }
}

