/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.resources;

import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesAction;
import com.solegendary.reignofnether.resources.ResourcesClientEvents;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ResourcesClientboundPacket {
    ResourcesAction action;
    public String ownerName;
    public int food;
    public int wood;
    public int ore;
    public BlockPos pos;
    public String msg;

    public static void syncResources(ArrayList<Resources> resourcesList) {
        for (Resources resources : resourcesList) {
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ResourcesClientboundPacket(ResourcesAction.SYNC, resources.ownerName, resources.food, resources.wood, resources.ore, new BlockPos(0, 0, 0), ""));
        }
    }

    public static void addSubtractResources(Resources resources) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ResourcesClientboundPacket(ResourcesAction.ADD_SUBTRACT, resources.ownerName, resources.food, resources.wood, resources.ore, new BlockPos(0, 0, 0), ""));
    }

    public static void addSubtractResourcesInstantly(Resources resources) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ResourcesClientboundPacket(ResourcesAction.ADD_SUBTRACT_INSTANT, resources.ownerName, resources.food, resources.wood, resources.ore, new BlockPos(0, 0, 0), ""));
    }

    public static void warnInsufficientResources(String ownerName, boolean foodBool, boolean woodBool, boolean oreBool) {
        for (Player player : PlayerServerEvents.players) {
            if (!player.m_7755_().getString().equals(ownerName)) continue;
            String msg = null;
            if (!foodBool) {
                msg = "server.resources.reignofnether.not_enough_food";
            }
            if (!woodBool) {
                msg = "server.resources.reignofnether.not_enough_wood";
            }
            if (!oreBool) {
                msg = "server.resources.reignofnether.not_enough_ore";
            }
            assert (msg != null);
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ResourcesClientboundPacket(ResourcesAction.SHOW_WARNING, ownerName, 0, 0, 0, new BlockPos(0, 0, 0), msg));
        }
    }

    public static void warnInsufficientPopulation(String ownerName) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ResourcesClientboundPacket(ResourcesAction.SHOW_WARNING, ownerName, 0, 0, 0, new BlockPos(0, 0, 0), "server.resources.reignofnether.not_enough_pop"));
    }

    public static void warnMaxPopulation(String ownerName) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ResourcesClientboundPacket(ResourcesAction.SHOW_WARNING, ownerName, 0, 0, 0, new BlockPos(0, 0, 0), "server.resources.reignofnether.max_pop"));
    }

    public static void showFloatingText(Resources res, BlockPos pos) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ResourcesClientboundPacket(ResourcesAction.SHOW_FLOATING_TEXT, res.ownerName, res.food, res.wood, res.ore, pos, ""));
    }

    public ResourcesClientboundPacket(ResourcesAction action, String ownerName, int food, int wood, int ore, BlockPos pos, String msg) {
        this.action = action;
        this.ownerName = ownerName;
        this.food = food;
        this.wood = wood;
        this.ore = ore;
        this.pos = pos;
        this.msg = msg;
    }

    public ResourcesClientboundPacket(FriendlyByteBuf buffer) {
        this.action = (ResourcesAction)buffer.m_130066_(ResourcesAction.class);
        this.ownerName = buffer.m_130277_();
        this.food = buffer.readInt();
        this.wood = buffer.readInt();
        this.ore = buffer.readInt();
        this.pos = buffer.m_130135_();
        this.msg = buffer.m_130277_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.action);
        buffer.m_130070_(this.ownerName);
        buffer.writeInt(this.food);
        buffer.writeInt(this.wood);
        buffer.writeInt(this.ore);
        buffer.m_130064_(this.pos);
        buffer.m_130070_(this.msg);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            switch (this.action) {
                case SYNC: {
                    ResourcesClientEvents.syncResources(new Resources(this.ownerName, this.food, this.wood, this.ore));
                    break;
                }
                case ADD_SUBTRACT: {
                    ResourcesClientEvents.addSubtractResources(new Resources(this.ownerName, this.food, this.wood, this.ore));
                    break;
                }
                case ADD_SUBTRACT_INSTANT: {
                    ResourcesClientEvents.addSubtractResourcesInstantly(new Resources(this.ownerName, this.food, this.wood, this.ore));
                    break;
                }
                case SHOW_WARNING: {
                    ResourcesClientEvents.showWarning(this.ownerName, this.msg);
                    break;
                }
                case SHOW_FLOATING_TEXT: {
                    ResourcesClientEvents.addFloatingTextsFromResources(new Resources(this.ownerName, this.food, this.wood, this.ore), this.pos);
                }
            }
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

