/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.survival;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.survival.WaveDifficulty;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;

public class SurvivalSaveData
extends SavedData {
    public boolean isEnabled;
    public int waveNumber;
    public WaveDifficulty difficulty;
    public long randomSeed;

    private static SurvivalSaveData create() {
        return new SurvivalSaveData();
    }

    @Nonnull
    public static SurvivalSaveData getInstance(LevelAccessor level) {
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return SurvivalSaveData.create();
        }
        return (SurvivalSaveData)server.m_129783_().m_8895_().m_164861_(SurvivalSaveData::load, SurvivalSaveData::create, "saved-survival-data");
    }

    public static SurvivalSaveData load(CompoundTag tag) {
        SurvivalSaveData data = SurvivalSaveData.create();
        data.isEnabled = tag.m_128471_("isEnabled");
        data.waveNumber = tag.m_128451_("waveNumber");
        data.difficulty = WaveDifficulty.valueOf(tag.m_128461_("difficulty"));
        data.randomSeed = tag.m_128454_("randomSeed");
        ReignOfNether.LOGGER.info("SurvivalSaveData.load: wave number: " + data.waveNumber);
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128379_("isEnabled", this.isEnabled);
        tag.m_128405_("waveNumber", this.waveNumber);
        tag.m_128359_("difficulty", this.difficulty.name());
        tag.m_128356_("randomSeed", this.randomSeed);
        return tag;
    }

    public void save() {
        this.m_77762_();
    }
}

