/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.survival;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.alliance.AlliancesServerEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.placements.PortalPlacement;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.player.RTSPlayer;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.sounds.SoundAction;
import com.solegendary.reignofnether.sounds.SoundClientboundPacket;
import com.solegendary.reignofnether.survival.SurvivalClientboundPacket;
import com.solegendary.reignofnether.survival.SurvivalSaveData;
import com.solegendary.reignofnether.survival.Wave;
import com.solegendary.reignofnether.survival.WaveDifficulty;
import com.solegendary.reignofnether.survival.WaveEnemy;
import com.solegendary.reignofnether.survival.WavePortal;
import com.solegendary.reignofnether.time.TimeUtils;
import com.solegendary.reignofnether.tutorial.TutorialServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SurvivalServerEvents {
    private static boolean isEnabled = false;
    @Nullable
    public static Wave currentWave = null;
    public static Wave nextWave = Wave.getWave(1);
    private static WaveDifficulty difficulty = WaveDifficulty.BEGINNER;
    private static final ArrayList<WaveEnemy> enemies = new ArrayList();
    public static final String ENEMY_OWNER_NAME = "Enemy";
    private static final Random random = new Random();
    public static Faction lastFaction = Faction.NONE;
    public static final ArrayList<WavePortal> portals = new ArrayList();
    public static final long TICK_INTERVAL = 10L;
    private static long lastTime = -1L;
    private static long lastEnemyCount = 0L;
    private static long ticks = 0L;
    private static ArrayList<BuildingPlacement> lastPortals = new ArrayList();
    private static ServerLevel serverLevel = null;

    public static WaveDifficulty getDifficulty() {
        return difficulty;
    }

    public static void saveData(ServerLevel level) {
        SurvivalSaveData survivalData = SurvivalSaveData.getInstance((LevelAccessor)level);
        survivalData.isEnabled = isEnabled;
        survivalData.waveNumber = SurvivalServerEvents.nextWave.number;
        survivalData.difficulty = difficulty;
        survivalData.randomSeed = Wave.randomSeed;
        survivalData.save();
        level.m_8895_().m_78151_();
    }

    @SubscribeEvent
    public static void loadWaveData(ServerStartedEvent evt) {
        ServerLevel level = evt.getServer().m_129880_(Level.f_46428_);
        if (level != null) {
            SurvivalSaveData survivalData = SurvivalSaveData.getInstance((LevelAccessor)level);
            isEnabled = survivalData.isEnabled;
            nextWave = Wave.getWave(survivalData.waveNumber);
            Wave.randomSeed = survivalData.randomSeed;
            Wave.reseedWaves();
            difficulty = survivalData.difficulty;
            if (SurvivalServerEvents.isEnabled()) {
                SurvivalClientboundPacket.enableAndSetDifficulty(difficulty);
                SurvivalClientboundPacket.setWaveNumber(SurvivalServerEvents.nextWave.number);
            }
            ReignOfNether.LOGGER.info("loaded survival data: isEnabled: " + SurvivalServerEvents.isEnabled());
            ReignOfNether.LOGGER.info("loaded survival data: nextWave: " + SurvivalServerEvents.nextWave.number);
            ReignOfNether.LOGGER.info("loaded survival data: difficulty: " + difficulty);
        }
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent evt) {
        int enemyCount;
        if (evt.phase != TickEvent.Phase.END || evt.level.m_5776_() || evt.level.m_46472_() != Level.f_46428_) {
            return;
        }
        serverLevel = (ServerLevel)evt.level;
        if (!SurvivalServerEvents.isEnabled()) {
            return;
        }
        if (++ticks % 10L != 0L) {
            return;
        }
        long time = evt.level.m_46468_();
        long normTime = TimeUtils.normaliseTime(evt.level.m_46468_());
        if (!SurvivalServerEvents.isStarted()) {
            SurvivalServerEvents.setToGameStartTime();
            return;
        }
        if (lastTime >= 0L) {
            if (lastTime <= 11900L && normTime > 11900L) {
                PlayerServerEvents.sendMessageToAllPlayers("survival.reignofnether.dusksoon", true, new Object[0]);
                SoundClientboundPacket.playSoundForAllPlayers(SoundAction.RANDOM_CAVE_AMBIENCE);
            }
            if (lastTime <= 12500L && normTime > 12500L) {
                PlayerServerEvents.sendMessageToAllPlayers("survival.reignofnether.dusk", true, new Object[0]);
                SoundClientboundPacket.playSoundForAllPlayers(SoundAction.RANDOM_CAVE_AMBIENCE);
                SurvivalServerEvents.setToStartingNightTime();
            }
            if (lastTime <= 12500L + TimeUtils.getWaveSurvivalTimeModifier(difficulty) + 50L && normTime > 12500L + TimeUtils.getWaveSurvivalTimeModifier(difficulty) + 50L) {
                SurvivalServerEvents.startNextWave((ServerLevel)evt.level);
            }
            if (lastTime <= 500L && normTime > 500L) {
                PlayerServerEvents.sendMessageToAllPlayers("survival.reignofnether.dawn", true, new Object[0]);
                SurvivalServerEvents.setToStartingDayTime();
            }
        }
        if ((long)(enemyCount = SurvivalServerEvents.getCurrentEnemies().size() + portals.size()) < lastEnemyCount && enemyCount <= 3) {
            if (enemyCount == 0) {
                SurvivalServerEvents.waveCleared((ServerLevel)evt.level);
            } else if (enemyCount == 1) {
                PlayerServerEvents.sendMessageToAllPlayers("survival.reignofnether.remaining_enemies_one");
            } else {
                PlayerServerEvents.sendMessageToAllPlayers("survival.reignofnether.remaining_enemies", false, enemyCount);
            }
        }
        for (WaveEnemy enemy : enemies) {
            enemy.tick(10L);
        }
        List<BuildingPlacement> currentPortals = BuildingServerEvents.getBuildings().stream().filter(b -> ENEMY_OWNER_NAME.equals(b.ownerName) && !b.ownerName.isBlank() && b instanceof PortalPlacement).toList();
        for (BuildingPlacement buildingPlacement : currentPortals) {
            if (lastPortals.contains(buildingPlacement)) continue;
            portals.add(new WavePortal((PortalPlacement)buildingPlacement, currentWave != null ? currentWave : nextWave));
        }
        portals.removeIf(p -> !currentPortals.contains(p.getPortal()));
        lastPortals.clear();
        lastPortals.addAll(currentPortals);
        for (WavePortal wavePortal : portals) {
            wavePortal.tick(10L);
        }
        lastTime = normTime;
        lastEnemyCount = enemyCount;
    }

    @SubscribeEvent
    public static void onRegisterCommand(RegisterCommandsEvent evt) {
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"debug-end-wave").executes(command -> {
            String name;
            if (((CommandSourceStack)command.getSource()).m_230896_() != null && !ResearchServerEvents.playerHasCheat(name = ((CommandSourceStack)command.getSource()).m_230896_().m_7755_().getString(), "thereisnospoon")) {
                return 0;
            }
            return SurvivalServerEvents.endCurrentWave();
        }));
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"debug-next-night").executes(command -> {
            String name;
            if (((CommandSourceStack)command.getSource()).m_230896_() != null && !ResearchServerEvents.playerHasCheat(name = ((CommandSourceStack)command.getSource()).m_230896_().m_7755_().getString(), "thereisnospoon")) {
                return 0;
            }
            if (!SurvivalServerEvents.isEnabled()) {
                return 0;
            }
            PlayerServerEvents.sendMessageToAllPlayers("Advancing to next night and wave");
            serverLevel.m_8615_(12450L);
            return 1;
        }));
    }

    public static int endCurrentWave() {
        if (!SurvivalServerEvents.isEnabled()) {
            return 0;
        }
        PlayerServerEvents.sendMessageToAllPlayers("Ending current wave");
        ArrayList<WaveEnemy> enemiesCopy = new ArrayList<WaveEnemy>(enemies);
        for (WaveEnemy enemy : enemiesCopy) {
            enemy.getEntity().m_6074_();
        }
        ArrayList<WavePortal> portalsCopy = new ArrayList<WavePortal>(portals);
        for (WavePortal portal : portalsCopy) {
            portal.portal.destroy(serverLevel);
        }
        return 1;
    }

    public static void enable(WaveDifficulty diff) {
        if (TutorialServerEvents.isEnabled()) {
            return;
        }
        if (!SurvivalServerEvents.isEnabled()) {
            SurvivalServerEvents.reset();
            lastEnemyCount = 0L;
            difficulty = diff;
            isEnabled = true;
            SurvivalClientboundPacket.enableAndSetDifficulty(difficulty);
            if (serverLevel != null) {
                SurvivalServerEvents.saveData(serverLevel);
            }
        }
    }

    public static void reset() {
        for (WaveEnemy enemy : enemies) {
            enemy.getEntity().m_6074_();
        }
        ArrayList<WavePortal> portalsCopy = new ArrayList<WavePortal>(portals);
        for (WavePortal portal : portalsCopy) {
            portal.portal.destroy(serverLevel);
        }
        difficulty = WaveDifficulty.EASY;
        isEnabled = false;
        portals.clear();
        enemies.clear();
        Wave.randomSeed = System.currentTimeMillis();
        Wave.reseedWaves();
        nextWave = Wave.getWave(1);
        SurvivalClientboundPacket.setWaveRandomSeed(Wave.randomSeed);
        lastTime = -1L;
        if (serverLevel != null) {
            SurvivalServerEvents.saveData(serverLevel);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        if (SurvivalServerEvents.isEnabled()) {
            SurvivalClientboundPacket.enableAndSetDifficulty(difficulty);
            SurvivalClientboundPacket.setWaveNumber(SurvivalServerEvents.nextWave.number);
            SurvivalClientboundPacket.setWaveRandomSeed(Wave.randomSeed);
            for (RTSPlayer rtsPlayer : PlayerServerEvents.rtsPlayers) {
                AlliancesServerEvents.addAlliance(rtsPlayer.name, evt.getEntity().m_7755_().getString());
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent evt) {
        Entity entity = evt.getEntity();
        if (entity instanceof Unit) {
            Unit unit = (Unit)entity;
            entity = evt.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity;
                if (!evt.getLevel().f_46443_ && SurvivalServerEvents.isEnabled() && ENEMY_OWNER_NAME.equals(unit.getOwnerName())) {
                    enemies.add(new WaveEnemy(unit));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityLeave(EntityLeaveLevelEvent evt) {
        Entity entity = evt.getEntity();
        if (entity instanceof Unit) {
            Unit unit = (Unit)entity;
            entity = evt.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity;
                if (!evt.getLevel().f_46443_ && ENEMY_OWNER_NAME.equals(unit.getOwnerName())) {
                    enemies.removeIf(e -> e.getEntity().m_19879_() == entity2.m_19879_());
                }
            }
        }
    }

    public static long getDayLength() {
        return 12000L - TimeUtils.getWaveSurvivalTimeModifier(difficulty);
    }

    public static void setToStartingDayTime() {
        serverLevel.m_8615_(500L + TimeUtils.getWaveSurvivalTimeModifier(difficulty));
    }

    public static void setToStartingNightTime() {
        serverLevel.m_8615_(12500L + TimeUtils.getWaveSurvivalTimeModifier(difficulty));
    }

    public static void setToGameStartTime() {
        serverLevel.m_8615_(12500L + TimeUtils.getWaveSurvivalTimeModifier(difficulty) + 60L);
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static boolean isStarted() {
        for (RTSPlayer player : PlayerServerEvents.rtsPlayers) {
            if (BuildingUtils.getTotalCompletedBuildingsOwned(false, player.name) <= 0) continue;
            return true;
        }
        return false;
    }

    public static List<WaveEnemy> getCurrentEnemies() {
        return enemies;
    }

    public static int getTotalEnemyPopulation() {
        int pop = 0;
        for (WaveEnemy waveEnemy : SurvivalServerEvents.getCurrentEnemies()) {
            pop += waveEnemy.unit.getCost().population;
        }
        return pop;
    }

    public static boolean isWaveInProgress() {
        return !SurvivalServerEvents.getCurrentEnemies().isEmpty();
    }

    public static void startNextWave(ServerLevel level) {
        SurvivalServerEvents.saveData(level);
        currentWave = nextWave;
        System.out.println("starting wave: " + SurvivalServerEvents.nextWave.faction.name());
        nextWave.start(level);
        nextWave = Wave.getWave(SurvivalServerEvents.nextWave.number + 1);
        System.out.println("next wave: " + SurvivalServerEvents.nextWave.faction.name());
        SurvivalClientboundPacket.setWaveNumber(SurvivalServerEvents.nextWave.number);
    }

    public static void waveCleared(ServerLevel level) {
        PlayerServerEvents.sendMessageToAllPlayers("survival.reignofnether.wave_cleared", true, new Object[0]);
        SoundClientboundPacket.playSoundForAllPlayers(SoundAction.ALLY);
        currentWave = null;
    }

    public static void setWaveNumber(int waveNumber) {
        nextWave = Wave.getWave(waveNumber);
        SurvivalClientboundPacket.setWaveNumber(SurvivalServerEvents.nextWave.number);
    }
}

