/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.survival.spawners;

import com.solegendary.reignofnether.ability.abilities.EnchantMaiming;
import com.solegendary.reignofnether.ability.abilities.EnchantMultishot;
import com.solegendary.reignofnether.ability.abilities.EnchantQuickCharge;
import com.solegendary.reignofnether.ability.abilities.EnchantSharpness;
import com.solegendary.reignofnether.ability.abilities.EnchantVigor;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.survival.SurvivalServerEvents;
import com.solegendary.reignofnether.survival.Wave;
import com.solegendary.reignofnether.survival.spawners.WaveSpawner;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.villagers.EvokerUnit;
import com.solegendary.reignofnether.unit.units.villagers.PillagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.RavagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.VindicatorUnit;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class IllagerWaveSpawner {
    private static final Random random = new Random();
    private static final Map<Integer, List<EntityType<? extends Mob>>> ILLAGER_UNITS = new HashMap<Integer, List<EntityType<? extends Mob>>>();

    public static EntityType<? extends Mob> getRandomUnitOfTier(int tier) {
        List<EntityType<? extends Mob>> units = ILLAGER_UNITS.get(tier);
        return units.get(random.nextInt(units.size()));
    }

    public static void checkAndApplyUpgrades(int tier) {
        if (tier >= 6 && !ResearchServerEvents.playerHasResearch("Enemy", ProductionItems.RESEARCH_EVOKER_VEXES)) {
            ResearchServerEvents.addResearch("Enemy", ProductionItems.RESEARCH_EVOKER_VEXES);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void checkAndApplyEnchants(LivingEntity entity, int tier) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        enchantment = null;
                        if (!(entity instanceof VindicatorUnit)) break block5;
                        vUnit = (VindicatorUnit)entity;
                        if (tier != 2 && tier != 3) break block5;
                        enchantment = EnchantMaiming.actualEnchantment;
                        break block6;
                    }
                    if (!(entity instanceof VindicatorUnit)) break block7;
                    vUnit = (VindicatorUnit)entity;
                    if (tier != 4 && tier != 5) break block7;
                    enchantment = EnchantSharpness.actualEnchantment;
                    break block6;
                }
                if (!(entity instanceof PillagerUnit)) break block8;
                vUnit = (PillagerUnit)entity;
                if (tier != 3 && tier != 4) break block8;
                enchantment = EnchantQuickCharge.actualEnchantment;
                break block6;
            }
            if (!(entity instanceof PillagerUnit)) ** GOTO lbl-1000
            vUnit = (PillagerUnit)entity;
            if (tier == 5 || tier == 6) {
                enchantment = EnchantMultishot.actualEnchantment;
            } else if (entity instanceof EvokerUnit) {
                vUnit = (EvokerUnit)entity;
                if (tier >= 6) {
                    enchantment = EnchantVigor.actualEnchantment;
                }
            }
        }
        item = entity.m_6844_(EquipmentSlot.MAINHAND);
        if (enchantment != null && item != ItemStack.f_41583_) {
            EnchantmentHelper.m_44865_(new HashMap<K, V>(), (ItemStack)item);
            item.m_41663_(enchantment, enchantment == Enchantments.f_44977_ ? 2 : 1);
        }
    }

    public static void spawnIllagerBase(ServerLevel level, Wave wave) {
        List<BlockPos> spawnBps = WaveSpawner.getValidSpawnPoints(1, (Level)level, false, 16);
        if (spawnBps.isEmpty()) {
            IllagerWaveSpawner.spawnIllagerWave(level, wave);
        }
        boolean flipCoords = random.nextBoolean();
        for (BlockPos bp : spawnBps) {
            BuildingPlacement building = WaveSpawner.spawnBuilding(Buildings.BARRACKS, bp.m_7494_());
            if (building == null) continue;
            BlockPos bp2 = new BlockPos(building.centrePos.m_123341_() - 2, building.minCorner.m_123342_(), building.centrePos.m_123343_());
            WaveSpawner.spawnBuilding(Buildings.WATCHTOWER, bp2.m_121955_((Vec3i)new BlockPos(flipCoords ? 10 : 0, -1, flipCoords ? 0 : 10)));
            WaveSpawner.spawnBuilding(Buildings.WATCHTOWER, bp2.m_121955_((Vec3i)new BlockPos(flipCoords ? -10 : 0, -1, flipCoords ? 0 : -10)));
        }
    }

    public static void spawnIllagerWave(ServerLevel level, Wave wave) {
        IllagerWaveSpawner.checkAndApplyUpgrades(wave.highestUnitTier);
        int pop = wave.population * PlayerServerEvents.rtsPlayers.size();
        int remainingPop = wave.population * PlayerServerEvents.rtsPlayers.size();
        List<BlockPos> spawnBps = WaveSpawner.getValidSpawnPoints(remainingPop, (Level)level, true, 6);
        int spawnsThisDir = 0;
        int spawnUntilNextTurn = -2;
        if (!spawnBps.isEmpty()) {
            BlockPos bp = spawnBps.get(0).m_7494_();
            ArrayList<Entity> entities = new ArrayList<Entity>();
            while (remainingPop > 0) {
                EntityType<? extends Mob> mobType = IllagerWaveSpawner.getRandomUnitOfTier(wave.highestUnitTier);
                Entity entity = UnitServerEvents.spawnMob(mobType, level, (Vec3i)bp.m_7494_(), "Enemy");
                entities.add(entity);
                if (random.nextBoolean() && wave.highestUnitTier >= 6 && entity instanceof RavagerUnit) {
                    RavagerUnit ravagerUnit = (RavagerUnit)entity;
                    Entity entityPassenger = UnitServerEvents.spawnMob((EntityType<? extends Mob>)((EntityType)EntityRegistrar.PILLAGER_UNIT.get()), level, (Vec3i)bp.m_7494_(), "Enemy");
                    if (entityPassenger instanceof Unit) {
                        Unit unit = (Unit)entityPassenger;
                        entityPassenger.m_8061_(EquipmentSlot.HEAD, Raid.m_37779_());
                        entityPassenger.m_20329_((Entity)ravagerUnit);
                        remainingPop -= WaveSpawner.getModifiedPopCost(unit);
                    }
                }
                if (!(entity instanceof Unit)) continue;
                Unit unit = (Unit)entity;
                IllagerWaveSpawner.checkAndApplyEnchants((LivingEntity)unit, wave.highestUnitTier);
                WaveSpawner.placeIceOrMagma(bp, (Level)level);
                remainingPop -= WaveSpawner.getModifiedPopCost(unit);
                ++spawnsThisDir;
            }
            int sqrLen = (int)Math.ceil(Math.sqrt(entities.size()));
            ArrayList<BlockPos> bps = new ArrayList<BlockPos>();
            for (int x = bp.m_123341_() - sqrLen / 2; x <= bp.m_123341_() + sqrLen / 2; ++x) {
                for (int z = bp.m_123343_() - sqrLen / 2; z <= bp.m_123343_() + sqrLen / 2; ++z) {
                    bps.add(new BlockPos(x, 0, z));
                }
            }
            int j = Math.min(entities.size(), bps.size());
            for (int i = 0; i < j; ++i) {
                ((Entity)entities.get(i)).m_6027_((double)((BlockPos)bps.get(i)).m_123341_(), ((Entity)entities.get(i)).m_20186_() + 0.5, (double)((BlockPos)bps.get(i)).m_123343_());
            }
        }
        if (remainingPop > 0) {
            PlayerServerEvents.sendMessageToAllPlayers("Failed to spawn " + remainingPop + "/" + pop + " population worth of villager units");
        }
        SurvivalServerEvents.lastFaction = Faction.VILLAGERS;
    }

    static {
        ILLAGER_UNITS.put(1, List.of((EntityType)EntityRegistrar.MILITIA_UNIT.get(), (EntityType)EntityRegistrar.VINDICATOR_UNIT.get(), (EntityType)EntityRegistrar.PILLAGER_UNIT.get()));
        ILLAGER_UNITS.put(2, List.of((EntityType)EntityRegistrar.MILITIA_UNIT.get(), (EntityType)EntityRegistrar.VINDICATOR_UNIT.get(), (EntityType)EntityRegistrar.PILLAGER_UNIT.get()));
        ILLAGER_UNITS.put(3, List.of((EntityType)EntityRegistrar.MILITIA_UNIT.get(), (EntityType)EntityRegistrar.VINDICATOR_UNIT.get(), (EntityType)EntityRegistrar.PILLAGER_UNIT.get(), (EntityType)EntityRegistrar.IRON_GOLEM_UNIT.get()));
        ILLAGER_UNITS.put(4, List.of((EntityType)EntityRegistrar.MILITIA_UNIT.get(), (EntityType)EntityRegistrar.VINDICATOR_UNIT.get(), (EntityType)EntityRegistrar.PILLAGER_UNIT.get(), (EntityType)EntityRegistrar.IRON_GOLEM_UNIT.get(), (EntityType)EntityRegistrar.EVOKER_UNIT.get()));
        ILLAGER_UNITS.put(5, List.of((EntityType)EntityRegistrar.VINDICATOR_UNIT.get(), (EntityType)EntityRegistrar.PILLAGER_UNIT.get(), (EntityType)EntityRegistrar.IRON_GOLEM_UNIT.get(), (EntityType)EntityRegistrar.EVOKER_UNIT.get(), (EntityType)EntityRegistrar.RAVAGER_UNIT.get()));
        ILLAGER_UNITS.put(6, List.of((EntityType)EntityRegistrar.VINDICATOR_UNIT.get(), (EntityType)EntityRegistrar.PILLAGER_UNIT.get(), (EntityType)EntityRegistrar.IRON_GOLEM_UNIT.get(), (EntityType)EntityRegistrar.EVOKER_UNIT.get(), (EntityType)EntityRegistrar.RAVAGER_UNIT.get()));
    }
}

