/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.time;

import com.solegendary.reignofnether.ability.AbilityClientboundPacket;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.sounds.SoundAction;
import com.solegendary.reignofnether.sounds.SoundClientboundPacket;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TimeServerEvents {
    private static Random RANDOM = new Random();
    private static int bloodMoonTicksLeft = 0;
    private static LivingEntity bloodMoonOwner = null;
    private static BlockPos bloodMoonTarget = null;
    private static boolean zombieOrSkeleton = true;

    public static void resetBloodMoon() {
        bloodMoonTicksLeft = 0;
        bloodMoonOwner = null;
    }

    public static boolean isBloodMoonActive() {
        return bloodMoonTicksLeft > 0;
    }

    public static void startBloodMoon(int tickDuration, Unit owner, BlockPos targetPos) {
        bloodMoonTicksLeft = tickDuration;
        bloodMoonOwner = (LivingEntity)owner;
        bloodMoonTarget = targetPos;
        PlayerServerEvents.sendMessageToAllPlayers("abilities.reignofnether.blood_moon.start", 0xFF0000, true, owner.getOwnerName());
        SoundClientboundPacket.playSoundForAllPlayers(SoundAction.RANDOM_CAVE_AMBIENCE);
    }

    private static void doRandomBloodMoonSpawn(Level level) {
        if (level.m_5776_() || bloodMoonTarget == null) {
            return;
        }
        Random random = new Random();
        ArrayList<BuildingPlacement> enemyBuildings = new ArrayList<BuildingPlacement>(BuildingServerEvents.getBuildings().stream().filter(b -> b.centrePos.m_123331_((Vec3i)bloodMoonTarget) < 625.0 && !b.getBuilding().invulnerable).toList());
        Collections.shuffle(enemyBuildings);
        ArrayList<BuildingPlacement> singleEnemyBuildings = new ArrayList<BuildingPlacement>();
        for (BuildingPlacement building : enemyBuildings) {
            if (singleEnemyBuildings.stream().map(b -> b.ownerName).toList().contains(building.ownerName)) continue;
            singleEnemyBuildings.add(building);
        }
        for (BuildingPlacement building : singleEnemyBuildings) {
            int x = building.centrePos.m_123341_() + random.nextInt(-10, 10);
            int z = building.centrePos.m_123343_() + random.nextInt(-10, 10);
            BlockPos bp = building.getClosestGroundPos(new BlockPos(x, building.minCorner.m_123342_(), z), 3);
            EntityType mobType = zombieOrSkeleton ? (EntityType)EntityRegistrar.ZOMBIE_UNIT.get() : (EntityType)EntityRegistrar.SKELETON_UNIT.get();
            UnitServerEvents.spawnMobs((EntityType<? extends Mob>)mobType, (ServerLevel)level, (Vec3i)bp, 1, "Blood Moon");
        }
        zombieOrSkeleton = !zombieOrSkeleton;
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END || evt.level.m_5776_() || evt.level.m_46472_() != Level.f_46428_) {
            return;
        }
        if (bloodMoonTicksLeft > 0 && bloodMoonOwner != null) {
            if (--bloodMoonTicksLeft <= 0) {
                PlayerServerEvents.sendMessageToAllPlayers("abilities.reignofnether.blood_moon.end", 0xFFFFFF, true, new Object[0]);
            } else if (bloodMoonTicksLeft % 120 == 0) {
                TimeServerEvents.doRandomBloodMoonSpawn(evt.level);
            }
            if (bloodMoonTicksLeft % 20 == 0) {
                AbilityClientboundPacket.doAbility(bloodMoonOwner.m_19879_(), UnitAction.BLOOD_MOON, bloodMoonTicksLeft);
            }
        }
    }
}

