/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.tutorial;

import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.tutorial.TutorialAction;
import com.solegendary.reignofnether.tutorial.TutorialServerEvents;
import com.solegendary.reignofnether.tutorial.TutorialStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class TutorialServerboundPacket {
    TutorialAction action;
    TutorialStage stage;

    public static void doServerAction(TutorialAction action) {
        PacketHandler.INSTANCE.sendToServer((Object)new TutorialServerboundPacket(action, TutorialStage.INTRO));
    }

    public static void saveStage(TutorialStage stage) {
        PacketHandler.INSTANCE.sendToServer((Object)new TutorialServerboundPacket(TutorialAction.SAVE_STAGE, stage));
    }

    public TutorialServerboundPacket(TutorialAction action, TutorialStage stage) {
        this.action = action;
        this.stage = stage;
    }

    public TutorialServerboundPacket(FriendlyByteBuf buffer) {
        this.action = (TutorialAction)buffer.m_130066_(TutorialAction.class);
        this.stage = (TutorialStage)buffer.m_130066_(TutorialStage.class);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.action);
        buffer.m_130068_((Enum)this.stage);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            switch (this.action) {
                case SAVE_STAGE: {
                    TutorialServerEvents.saveStage(this.stage);
                    break;
                }
                case SET_DAY_TIME: {
                    TutorialServerEvents.setDayTime();
                    break;
                }
                case SET_NIGHT_TIME: {
                    TutorialServerEvents.setNightTime();
                    break;
                }
                case SPAWN_ANIMALS: {
                    TutorialServerEvents.spawnAnimals();
                    break;
                }
                case SPAWN_MONSTERS_A: {
                    TutorialServerEvents.spawnMonstersA();
                    break;
                }
                case ATTACK_WITH_MONSTERS_A: {
                    TutorialServerEvents.attackWithMonstersA();
                    break;
                }
                case SPAWN_MONSTERS_B: {
                    TutorialServerEvents.spawnMonstersB();
                    break;
                }
                case ATTACK_WITH_MONSTERS_B: {
                    TutorialServerEvents.attackWithMonstersB();
                    break;
                }
                case SPAWN_MONSTER_WORKERS: {
                    TutorialServerEvents.spawnMonsterWorkers();
                    break;
                }
                case START_MONSTER_BASE: {
                    TutorialServerEvents.startBuildingMonsterBase();
                    break;
                }
                case EXPAND_MONSTER_BASE_A: {
                    TutorialServerEvents.expandMonsterBaseA();
                    break;
                }
                case EXPAND_MONSTER_BASE_B: {
                    TutorialServerEvents.expandMonsterBaseB();
                    break;
                }
                case SPAWN_MONSTER_BASE_ARMY: {
                    TutorialServerEvents.spawnMonsterBaseArmy();
                    break;
                }
                case SPAWN_FRIENDLY_ARMY: {
                    TutorialServerEvents.spawnFriendlyArmy();
                }
            }
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

