/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.goals;

import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.placements.FarmPlacement;
import com.solegendary.reignofnether.building.buildings.shared.AbstractBridge;
import com.solegendary.reignofnether.building.buildings.villagers.OakStockpile;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class BuildRepairGoal
extends MoveToTargetBlockGoal {
    public boolean ignoreNextCheckpoint = false;
    public final List<BuildingPlacement> queuedBuildings = new ArrayList<BuildingPlacement>();
    private BuildingPlacement buildingTarget;
    private Boolean isBuildingServerside = false;
    private final int AUTOCAST_RANGE = 20;
    public boolean autocastRepair = false;

    public BuildRepairGoal(Mob mob) {
        super(mob, true, 0);
    }

    public void setIsBuildingServerside(boolean isBuilding) {
        this.isBuildingServerside = isBuilding;
    }

    public boolean startNextQueuedBuilding() {
        this.queuedBuildings.removeIf(b -> !BuildingUtils.isBuildingBuildable(this.mob.m_9236_().m_5776_(), b));
        if (this.queuedBuildings.size() > 0) {
            this.setBuildingTarget(this.queuedBuildings.get(0));
            return true;
        }
        return false;
    }

    public void m_8037_() {
        if (this.buildingTarget == null) {
            BuildingPlacement building;
            if (!this.mob.m_9236_().m_5776_() && WorkerUnit.isIdle((WorkerUnit)this.mob) && this.autocastRepair && (building = BuildingUtils.findClosestBuilding(this.mob.m_9236_().m_5776_(), this.mob.m_146892_(), b -> b.getBlocksPlaced() < b.getBlocksTotal() && BuildingServerEvents.getUnitToBuildingRelationship((Unit)this.mob, b) != Relationship.HOSTILE)) != null) {
                this.setBuildingTarget(building);
            }
            return;
        }
        if (!BuildingUtils.isBuildingBuildable(this.mob.m_9236_().m_5776_(), this.buildingTarget)) {
            if (!this.startNextQueuedBuilding()) {
                Object object;
                if (this.buildingTarget instanceof FarmPlacement && (object = this.mob) instanceof WorkerUnit) {
                    WorkerUnit workerUnit = (WorkerUnit)object;
                    ((WorkerUnit)this.mob).getGatherResourceGoal().setTargetResourceName(ResourceName.FOOD);
                    ((WorkerUnit)this.mob).getGatherResourceGoal().setTargetFarm(this.buildingTarget);
                } else {
                    object = this.buildingTarget.getBuilding();
                    if (object instanceof OakStockpile) {
                        WorkerUnit workerUnit;
                        OakStockpile stockpile = (OakStockpile)object;
                        if (!this.buildingTarget.isBuilt && (object = this.mob) instanceof WorkerUnit && (workerUnit = (WorkerUnit)object).getBuildRepairGoal().isBuilding()) {
                            ((Unit)this.mob).getReturnResourcesGoal().depositItems();
                            workerUnit.getGatherResourceGoal().setTargetResourceName(stockpile.mostAbundantNearbyResource);
                        }
                    }
                }
                this.stopBuilding();
            }
            return;
        }
        this.calcMoveTarget();
        if (this.isBuilding() && this.buildingTarget != null) {
            BlockPos bp = this.buildingTarget.centrePos;
            this.mob.m_21563_().m_24946_((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_());
            this.mob.m_21563_().f_186068_ = 20;
        }
    }

    private void calcMoveTarget() {
        if (this.buildingTarget != null) {
            this.moveTarget = this.buildingTarget.getClosestGroundPos(this.mob.m_20097_(), 1);
        }
    }

    public boolean isBuilding() {
        if (this.mob.m_9236_().m_5776_()) {
            return this.isBuildingServerside;
        }
        if (this.buildingTarget != null && this.moveTarget != null && (BuildingServerEvents.getUnitToBuildingRelationship((Unit)this.mob, this.buildingTarget) == Relationship.OWNED || this.buildingTarget.getBuilding() instanceof AbstractBridge)) {
            return MiscUtil.isMobInRangeOfPos(this.moveTarget, (LivingEntity)this.mob, 2.0f);
        }
        return false;
    }

    public void setBuildingTarget(@Nullable BuildingPlacement target) {
        if (target != null) {
            if (this.ignoreNextCheckpoint) {
                this.ignoreNextCheckpoint = false;
            } else {
                MiscUtil.addUnitCheckpoint((Unit)this.mob, new BlockPos(target.centrePos.m_123341_(), target.originPos.m_123342_() + 1, target.centrePos.m_123343_()), true);
            }
        }
        this.buildingTarget = target;
        this.calcMoveTarget();
        this.m_8056_();
    }

    public BuildingPlacement getBuildingTarget() {
        return this.buildingTarget;
    }

    public void stopBuilding() {
        this.queuedBuildings.clear();
        this.buildingTarget = null;
        super.stopMoving();
    }
}

