/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.goals;

import com.solegendary.reignofnether.registrars.GameRuleRegistrar;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.MiscUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.level.GameRules;

public class FlyingMoveToTargetGoal
extends MoveToTargetBlockGoal {
    public FlyingMoveToTargetGoal(Mob mob, int reachRange) {
        super(mob, false, reachRange);
    }

    @Override
    public boolean isAtDestination() {
        if (this.moveTarget == null) {
            return true;
        }
        return this.mob.m_20275_((double)((float)this.moveTarget.m_123341_() + 0.5f), (double)((float)this.moveTarget.m_123342_() + 0.5f), (double)((float)this.moveTarget.m_123343_() + 0.5f)) < 4.0;
    }

    @Override
    public boolean m_8045_() {
        if (!this.isAtDestination() && this.moveTarget != null) {
            this.m_8056_();
            return true;
        }
        if (this.moveTarget == null) {
            return false;
        }
        if (this.isAtDestination()) {
            if (!this.persistent && !((Unit)this.mob).getHoldPosition()) {
                this.moveTarget = null;
                this.mob.m_21566_().f_24981_ = MoveControl.Operation.WAIT;
            }
            return false;
        }
        return true;
    }

    @Override
    public void m_8056_() {
        if (this.moveTarget != null) {
            this.mob.m_21563_().m_24946_((double)this.moveTarget.m_123341_(), (double)this.moveTarget.m_123342_(), (double)this.moveTarget.m_123343_());
            this.mob.m_21566_().m_6849_((double)((float)this.moveTarget.m_123341_() + 0.5f), (double)((float)this.moveTarget.m_123342_() + 0.5f), (double)((float)this.moveTarget.m_123343_() + 0.5f), 1.0);
        } else {
            this.mob.m_21566_().f_24981_ = MoveControl.Operation.WAIT;
        }
    }

    @Override
    public void setMoveTarget(@Nullable BlockPos bp) {
        if (bp != null) {
            MiscUtil.addUnitCheckpoint((Unit)this.mob, bp, true);
            if (this.mob.m_9236_().m_8055_(bp).m_60795_()) {
                return;
            }
            BlockPos bpGround = bp;
            int y = 1;
            while (!MiscUtil.isGroundBlock(this.mob.m_9236_(), bpGround)) {
                bpGround = bp.m_7918_(0, -y, 0);
                if (++y <= 30) continue;
            }
            BlockPos targetBp = bpGround.m_7918_(0, 10, 0);
            double maxHeight = ((GameRules.IntegerValue)this.mob.m_9236_().m_46469_().m_46170_(GameRuleRegistrar.FLYING_MAX_Y_LEVEL)).m_46288_();
            if ((double)targetBp.m_123342_() > maxHeight) {
                targetBp = new BlockPos(targetBp.m_123341_(), (int)maxHeight, targetBp.m_123343_());
            }
            this.moveTarget = targetBp;
        } else {
            this.moveTarget = null;
            this.mob.m_21566_().f_24981_ = MoveControl.Operation.WAIT;
        }
        this.m_8056_();
    }

    @Override
    public void stopMoving() {
        Object e;
        this.moveTarget = null;
        this.mob.m_21566_().f_24981_ = MoveControl.Operation.WAIT;
        if (this.mob.m_20160_() && (e = this.mob.m_20197_().get(0)) instanceof Unit) {
            Unit unit = (Unit)e;
            unit.getMoveGoal().stopMoving();
        }
    }
}

