/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.goals;

import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class MoveToTargetBlockGoal
extends Goal {
    protected final Mob mob;
    @Nullable
    protected BlockPos moveTarget = null;
    protected boolean persistent;
    protected int moveReachRange = 0;
    @Nullable
    public BlockPos lastSelectedMoveTarget = null;
    protected final int RECALC_COOLDOWN_MAX = 20;
    protected int recalcCooldown = 0;

    protected void resetRecalcCooldown() {
        this.recalcCooldown = 20;
    }

    public MoveToTargetBlockGoal(Mob mob, boolean persistent, int reachRange) {
        this.mob = mob;
        this.persistent = persistent;
        this.moveReachRange = reachRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean isAtDestination() {
        if (this.moveTarget == null) {
            return true;
        }
        return this.mob.m_21573_().m_26571_();
    }

    public double getMinDistToRecalculateSqr() {
        double dist = Math.max(1, this.moveReachRange);
        return dist * dist;
    }

    public boolean m_8036_() {
        return this.moveTarget != null;
    }

    public boolean m_8045_() {
        if (this.recalcCooldown > 0) {
            --this.recalcCooldown;
            return true;
        }
        if (this.mob.m_21573_().m_26571_() && this.moveTarget != null && this.mob.m_20097_().m_123331_((Vec3i)this.moveTarget) > this.getMinDistToRecalculateSqr()) {
            this.m_8056_();
            this.resetRecalcCooldown();
            return true;
        }
        if (this.moveTarget == null) {
            return false;
        }
        if (this.mob.m_21573_().m_26571_()) {
            if (!this.persistent && !((Unit)this.mob).getHoldPosition()) {
                this.moveTarget = null;
            }
            return false;
        }
        return true;
    }

    public void m_8056_() {
        if (this.moveTarget != null) {
            Path bestPath;
            boolean improvedPathfinding;
            AttributeInstance ai = this.mob.m_21051_(Attributes.f_22277_);
            boolean bl = improvedPathfinding = ai != null && ai.m_22115_() == 64.0;
            if (improvedPathfinding) {
                ai.m_22100_(16.0);
                Path shortPath = this.mob.m_21573_().m_26524_((double)this.moveTarget.m_123341_(), (double)this.moveTarget.m_123342_(), (double)this.moveTarget.m_123343_(), this.moveReachRange);
                BlockPos shortFinalPos = this.getFinalNodePos(shortPath);
                ai.m_22100_(64.0);
                Path longPath = this.mob.m_21573_().m_26524_((double)this.moveTarget.m_123341_(), (double)this.moveTarget.m_123342_(), (double)this.moveTarget.m_123343_(), this.moveReachRange);
                BlockPos longFinalPos = this.getFinalNodePos(longPath);
                bestPath = longPath;
                if (shortFinalPos != null && longFinalPos != null) {
                    double longXZDist;
                    BlockPos moveTargetXZ = new BlockPos(this.moveTarget.m_123341_(), 0, this.moveTarget.m_123343_());
                    double shortXZDist = new BlockPos(shortFinalPos.m_123341_(), 0, shortFinalPos.m_123343_()).m_123331_((Vec3i)moveTargetXZ);
                    if (shortXZDist < (longXZDist = new BlockPos(longFinalPos.m_123341_(), 0, longFinalPos.m_123343_()).m_123331_((Vec3i)moveTargetXZ))) {
                        bestPath = shortPath;
                    }
                }
            } else {
                bestPath = this.mob.m_21573_().m_26524_((double)this.moveTarget.m_123341_(), (double)this.moveTarget.m_123342_(), (double)this.moveTarget.m_123343_(), this.moveReachRange);
            }
            this.mob.m_21573_().m_26536_(bestPath, (double)Unit.getSpeedModifier((Unit)this.mob));
        } else {
            this.mob.m_21573_().m_26573_();
        }
    }

    public void setMoveTarget(@Nullable BlockPos bp) {
        if (bp != null) {
            MiscUtil.addUnitCheckpoint((Unit)this.mob, bp, true);
        }
        this.moveTarget = bp;
        if (!this.mob.m_9236_().m_5776_()) {
            this.m_8056_();
        }
    }

    public BlockPos getMoveTarget() {
        return this.moveTarget;
    }

    @Nullable
    public BlockPos getFinalNodePos() {
        Path path = this.mob.m_21573_().m_26570_();
        if (path != null && !path.f_77362_.isEmpty()) {
            return ((Node)path.f_77362_.get(path.f_77362_.size() - 1)).m_77288_();
        }
        return null;
    }

    @Nullable
    public BlockPos getFinalNodePos(Path path) {
        if (path != null && !path.f_77362_.isEmpty()) {
            return ((Node)path.f_77362_.get(path.f_77362_.size() - 1)).m_77288_();
        }
        return null;
    }

    public void stopMoving() {
        Object e;
        this.recalcCooldown = 0;
        this.moveTarget = null;
        this.mob.m_21573_().m_26573_();
        if (this.mob.m_20160_() && (e = this.mob.m_20197_().get(0)) instanceof Unit) {
            Unit unit = (Unit)e;
            unit.getMoveGoal().stopMoving();
        }
    }
}

