/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.goals;

import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesClientboundPacket;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.goals.GatherResourcesGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.unit.packets.UnitSyncClientboundPacket;
import com.solegendary.reignofnether.util.MiscUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class ReturnResourcesGoal
extends MoveToTargetBlockGoal {
    private BuildingPlacement buildingTarget;

    public ReturnResourcesGoal(Mob mob) {
        super(mob, true, 0);
    }

    public void depositItems() {
        Mob mob = this.mob;
        if (mob instanceof Unit) {
            Resources res;
            Unit unit = (Unit)mob;
            if (!this.mob.m_9236_().m_5776_() && (res = Resources.getTotalResourcesFromItems(unit.getItems())).getTotalValue() > 0) {
                res.ownerName = unit.getOwnerName();
                ResourcesServerEvents.addSubtractResources(res);
                ResourcesClientboundPacket.showFloatingText(res, this.moveTarget != null ? this.moveTarget : this.mob.m_20097_());
                unit.getItems().clear();
                UnitSyncClientboundPacket.sendSyncResourcesPacket(unit);
                this.stopReturning();
            }
        }
    }

    public void m_8037_() {
        if (this.buildingTarget != null) {
            Mob mob;
            this.calcMoveTarget();
            if (this.canDropOff() && (mob = this.mob) instanceof Unit) {
                Unit unit = (Unit)mob;
                if (!this.mob.m_9236_().m_5776_()) {
                    this.depositItems();
                    Mob mob2 = this.mob;
                    if (mob2 instanceof WorkerUnit) {
                        WorkerUnit worker = (WorkerUnit)mob2;
                        unit.resetBehaviours();
                        WorkerUnit.resetBehaviours((WorkerUnit)((Object)unit));
                        GatherResourcesGoal goal = worker.getGatherResourceGoal();
                        if (goal != null && goal.saveData.hasData()) {
                            goal.loadState();
                            goal.saveData.delete();
                        }
                    }
                }
            }
        } else {
            this.moveTarget = null;
        }
    }

    private void calcMoveTarget() {
        if (this.buildingTarget != null) {
            this.moveTarget = this.buildingTarget.getClosestGroundPos(this.mob.m_20097_(), 1);
        }
    }

    public boolean canDropOff() {
        if (this.buildingTarget != null && this.moveTarget != null && this.buildingTarget.isBuilt && this.buildingTarget.getBuilding().canAcceptResources && BuildingServerEvents.getUnitToBuildingRelationship((Unit)this.mob, this.buildingTarget) == Relationship.OWNED && BuildingServerEvents.getBuildings().contains(this.buildingTarget)) {
            return this.buildingTarget.isPosInsideBuilding(this.mob.m_20097_()) || MiscUtil.isMobInRangeOfPos(this.moveTarget, (LivingEntity)this.mob, 1.5f);
        }
        return false;
    }

    public void returnToClosestBuilding() {
        if (this.mob.m_9236_().m_5776_()) {
            return;
        }
        BlockPos pos = this.mob.m_20097_();
        BuildingPlacement closestBuilding = null;
        double closestDist = 99999.0;
        for (BuildingPlacement building : BuildingServerEvents.getBuildings()) {
            BlockPos bp;
            double dist;
            if (!building.ownerName.equals(((Unit)this.mob).getOwnerName()) || !building.getBuilding().canAcceptResources || !building.isBuilt || !((dist = (bp = building.getClosestGroundPos(pos, 1)).m_123331_((Vec3i)pos)) < closestDist)) continue;
            closestBuilding = building;
            closestDist = dist;
        }
        if (closestBuilding != null) {
            this.setBuildingTarget(closestBuilding);
        }
    }

    public void setBuildingTarget(@Nullable BuildingPlacement target) {
        if (target != null) {
            MiscUtil.addUnitCheckpoint((Unit)this.mob, target.centrePos, true);
        }
        this.buildingTarget = target;
        this.calcMoveTarget();
        this.m_8056_();
    }

    public BuildingPlacement getBuildingTarget() {
        return this.buildingTarget;
    }

    public void stopReturning() {
        this.buildingTarget = null;
        super.stopMoving();
    }
}

