/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.goals;

import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.neutral.NeutralTransportPortal;
import com.solegendary.reignofnether.building.buildings.placements.PortalPlacement;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.sounds.SoundAction;
import com.solegendary.reignofnether.sounds.SoundClientboundPacket;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.LanguageUtil;
import com.solegendary.reignofnether.util.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;

public class UsePortalGoal
extends MoveToTargetBlockGoal {
    private BuildingPlacement buildingTarget;

    public UsePortalGoal(Mob mob) {
        super(mob, true, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_8037_() {
        this.calcMoveTarget();
        BuildingPlacement buildingPlacement = this.buildingTarget;
        if (buildingPlacement instanceof PortalPlacement) {
            PortalPlacement portal = (PortalPlacement)buildingPlacement;
            if (this.moveTarget != null) {
                if (this.buildingTarget.getBlocksPlaced() <= 0) {
                    this.stopUsingPortal();
                }
                Vec3 vec3 = new Vec3((double)((float)this.moveTarget.m_123341_() + 0.5f), (double)((float)this.moveTarget.m_123342_() + 0.5f), (double)((float)this.moveTarget.m_123343_() + 0.5f));
                if (!(this.mob.m_20238_(vec3) <= 3.0)) return;
                if (portal.hasDestination()) {
                    BlockPos bp = portal.destination;
                    SoundClientboundPacket.playSoundAtPos(SoundAction.USE_PORTAL, bp);
                    this.mob.m_6021_((double)((float)bp.m_123341_() + 0.5f), (double)((float)bp.m_123342_() + 0.5f), (double)((float)bp.m_123343_() + 0.5f));
                    SoundClientboundPacket.playSoundAtPos(SoundAction.USE_PORTAL, portal.destination);
                }
                this.stopUsingPortal();
                return;
            }
        }
        this.moveTarget = null;
    }

    private void calcMoveTarget() {
        if (this.buildingTarget instanceof PortalPlacement) {
            this.moveTarget = this.buildingTarget.centrePos;
        }
    }

    public void setBuildingTarget(BlockPos blockPos) {
        if (blockPos != null) {
            if (this.mob.m_9236_().m_5776_()) {
                this.buildingTarget = BuildingUtils.findBuilding(true, blockPos);
                BuildingPlacement buildingPlacement = this.buildingTarget;
                if (buildingPlacement instanceof PortalPlacement) {
                    PortalPlacement portal = (PortalPlacement)buildingPlacement;
                    if (this.buildingTarget.ownerName.equals(((Unit)this.mob).getOwnerName()) || portal.getBuilding() instanceof NeutralTransportPortal) {
                        if (portal.hasDestination()) {
                            MiscUtil.addUnitCheckpoint((Unit)this.mob, new BlockPos(this.buildingTarget.centrePos.m_123341_(), this.buildingTarget.originPos.m_123342_() + 1, this.buildingTarget.centrePos.m_123343_()), true);
                        } else {
                            HudClientEvents.showTemporaryMessage(LanguageUtil.getTranslation("hud.reignofnether.no_destination", new Object[0]));
                        }
                    }
                }
            } else {
                this.buildingTarget = BuildingUtils.findBuilding(false, blockPos);
            }
            this.calcMoveTarget();
            this.m_8056_();
        }
    }

    public BuildingPlacement getBuildingTarget() {
        return this.buildingTarget;
    }

    public void stopUsingPortal() {
        this.buildingTarget = null;
        super.stopMoving();
    }
}

