/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.interfaces;

import com.solegendary.reignofnether.unit.UnitAnimationAction;
import com.solegendary.reignofnether.unit.goals.BuildRepairGoal;
import com.solegendary.reignofnether.unit.goals.GatherResourcesGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.packets.UnitAnimationClientboundPacket;
import com.solegendary.reignofnether.unit.units.monsters.ZombieVillagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.VillagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.VillagerUnitProfession;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public interface WorkerUnit {
    public BuildRepairGoal getBuildRepairGoal();

    public GatherResourcesGoal getGatherResourceGoal();

    public BlockState getReplantBlockState();

    /*
     * Enabled aggressive block sorting
     */
    public static void tick(WorkerUnit unit) {
        GatherResourcesGoal gatherResourcesGoal;
        BuildRepairGoal buildRepairGoal = unit.getBuildRepairGoal();
        if (buildRepairGoal != null) {
            buildRepairGoal.m_8037_();
        }
        if ((gatherResourcesGoal = unit.getGatherResourceGoal()) != null) {
            gatherResourcesGoal.m_8037_();
        }
        LivingEntity entity = (LivingEntity)unit;
        ItemStack mainHandItem = entity.m_6844_(EquipmentSlot.MAINHAND);
        if (unit.getBuildRepairGoal().isBuilding()) {
            VillagerUnit vUnit;
            if (mainHandItem.m_150930_(Items.f_42384_)) return;
            if (entity instanceof VillagerUnit && (vUnit = (VillagerUnit)entity).isVeteran() && vUnit.getUnitProfession() == VillagerUnitProfession.MASON) {
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42389_));
                return;
            }
            entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42384_));
            return;
        }
        if (unit.getGatherResourceGoal().isGathering()) {
            switch (unit.getGatherResourceGoal().getTargetResourceName()) {
                case FOOD: {
                    VillagerUnit vUnit;
                    if (mainHandItem.m_150930_(Items.f_42387_)) return;
                    if (entity instanceof VillagerUnit && (vUnit = (VillagerUnit)entity).isVeteran() && vUnit.getUnitProfession() == VillagerUnitProfession.FARMER && vUnit.getGatherResourceGoal().isFarming()) {
                        entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42392_));
                        return;
                    }
                    entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42387_));
                    return;
                }
                case WOOD: {
                    VillagerUnit vUnit;
                    if (mainHandItem.m_150930_(Items.f_42386_)) return;
                    if (entity instanceof VillagerUnit && (vUnit = (VillagerUnit)entity).isVeteran() && vUnit.getUnitProfession() == VillagerUnitProfession.LUMBERJACK) {
                        entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42391_));
                        return;
                    }
                    entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42386_));
                    return;
                }
                case ORE: {
                    VillagerUnit vUnit;
                    if (mainHandItem.m_150930_(Items.f_42385_)) return;
                    if (entity instanceof VillagerUnit && (vUnit = (VillagerUnit)entity).isVeteran() && vUnit.getUnitProfession() == VillagerUnitProfession.MINER) {
                        entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42390_));
                        return;
                    }
                    entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42385_));
                    return;
                }
                case NONE: {
                    if (mainHandItem.m_150930_(Items.f_41852_)) return;
                    entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_41852_));
                    return;
                }
            }
            return;
        }
        if (entity instanceof AttackerUnit) {
            AttackerUnit attackerUnit = (AttackerUnit)entity;
            if (((Unit)entity).getTargetGoal().getTarget() != null && !(entity instanceof ZombieVillagerUnit)) {
                VillagerUnit vUnit;
                if (mainHandItem.m_150930_(Items.f_42420_)) return;
                if (mainHandItem.m_150930_(Items.f_42425_)) return;
                if (entity instanceof VillagerUnit && (vUnit = (VillagerUnit)entity).getUnitProfession() == VillagerUnitProfession.HUNTER && vUnit.isVeteran()) {
                    entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
                } else {
                    entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42420_));
                }
                if (entity.m_9236_().m_5776_()) return;
                UnitAnimationClientboundPacket.sendEntityPacket(UnitAnimationAction.NON_KEYFRAME_START, entity, ((Unit)entity).getTargetGoal().getTarget());
                return;
            }
        }
        if (mainHandItem.m_150930_(Items.f_41852_)) return;
        entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_41852_));
        if (entity.m_9236_().m_5776_()) return;
        UnitAnimationClientboundPacket.sendBasicPacket(UnitAnimationAction.NON_KEYFRAME_STOP, entity);
    }

    public static void resetBehaviours(WorkerUnit unit) {
        unit.getBuildRepairGoal().stopBuilding();
        unit.getGatherResourceGoal().stopGathering();
    }

    public static boolean isIdle(WorkerUnit unit) {
        GatherResourcesGoal resGoal = unit.getGatherResourceGoal();
        boolean isMoving = !((Mob)unit).m_21573_().m_26571_();
        boolean isGathering = resGoal.isGathering();
        boolean isGatheringIdle = resGoal.isIdle();
        boolean isBuilding = unit.getBuildRepairGoal().getBuildingTarget() != null;
        boolean isFarming = resGoal.isFarming();
        boolean isAttacking = ((Unit)((Object)unit)).getTargetGoal().getTarget() != null;
        return !isMoving && !isGathering && !isBuilding && isGatheringIdle && !isAttacking && !isFarming;
    }
}

