/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.monsters;

import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.production.ProductionItem;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.building.production.StartProductionButton;
import com.solegendary.reignofnether.building.production.StopProductionButton;
import com.solegendary.reignofnether.hud.buttons.UnitSpawnButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.EntityType;

public class SkeletonProd
extends ProductionItem {
    public static final String itemName = "Skeleton";
    public static final ResourceCost cost = ResourceCosts.SKELETON;

    public SkeletonProd() {
        super(cost);
        this.onComplete = (level, placement) -> {
            if (!level.m_5776_()) {
                if (ResearchServerEvents.playerHasResearch(placement.ownerName, ProductionItems.RESEARCH_STRAYS)) {
                    placement.produceUnit((ServerLevel)level, (EntityType<? extends Unit>)((EntityType)EntityRegistrar.STRAY_UNIT.get()), placement.ownerName, true);
                } else {
                    placement.produceUnit((ServerLevel)level, (EntityType<? extends Unit>)((EntityType)EntityRegistrar.SKELETON_UNIT.get()), placement.ownerName, true);
                }
            }
        };
    }

    @Override
    public String getItemName() {
        return itemName;
    }

    public UnitSpawnButton getPlaceButton() {
        return new UnitSpawnButton(itemName, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/skeleton.png"), List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.monsters.reignofnether.skeleton", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.monsters.reignofnether.skeleton.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.monsters.reignofnether.skeleton.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_)));
    }

    @Override
    public StartProductionButton getStartButton(ProductionPlacement prodBuilding, Keybinding hotkey) {
        return new StartProductionButton(itemName, ResearchClient.hasResearch(ProductionItems.RESEARCH_STRAYS) ? ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/stray.png") : ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/skeleton.png"), hotkey, () -> ResearchClient.hasResearch(ProductionItems.RESEARCH_STRAYS), () -> true, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.monsters.reignofnether.skeleton", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), ResourceCosts.getFormattedPopAndTime(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.monsters.reignofnether.skeleton.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.monsters.reignofnether.skeleton.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_)), this);
    }

    @Override
    public StopProductionButton getCancelButton(ProductionPlacement prodBuilding, boolean first) {
        return new StopProductionButton(ResearchClient.hasResearch(ProductionItems.RESEARCH_STRAYS) ? "Stray" : itemName, ResearchClient.hasResearch(ProductionItems.RESEARCH_STRAYS) ? ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/stray.png") : ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/skeleton.png"), prodBuilding, this, first);
    }
}

