/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.piglins;

import com.solegendary.reignofnether.ability.Abilities;
import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.abilities.WitherCloud;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.piglins.BasaltSprings;
import com.solegendary.reignofnether.building.buildings.piglins.FlameSanctuary;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.goals.AbstractMeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.GarrisonGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackBuildingGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.RandomLookAroundUnitGoal;
import com.solegendary.reignofnether.unit.goals.ReturnResourcesGoal;
import com.solegendary.reignofnether.unit.goals.SelectedTargetGoal;
import com.solegendary.reignofnether.unit.goals.UsePortalGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.Faction;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;

public class WitherSkeletonUnit
extends WitherSkeleton
implements Unit,
AttackerUnit {
    public static final Abilities ABILITIES = new Abilities();
    Object2ObjectArrayMap<Ability, Float> cooldowns = Unit.createCooldownMap();
    Object2ObjectArrayMap<Ability, Integer> charges = new Object2ObjectArrayMap();
    Ability autocast;
    private int eatingTicksLeft = 0;
    private BlockPos anchorPos = new BlockPos(0, 0, 0);
    private final ArrayList<Checkpoint> checkpoints = new ArrayList();
    GarrisonGoal garrisonGoal;
    UsePortalGoal usePortalGoal;
    private MoveToTargetBlockGoal moveGoal;
    private SelectedTargetGoal<? extends LivingEntity> targetGoal;
    private ReturnResourcesGoal returnResourcesGoal;
    private AbstractMeleeAttackUnitGoal attackGoal;
    private MeleeAttackBuildingGoal attackBuildingGoal;
    private LivingEntity followTarget = null;
    private boolean holdPosition = false;
    private BlockPos attackMoveTarget = null;
    public static final EntityDataAccessor<String> ownerDataAccessor;
    public static final float attackDamage = 3.0f;
    public static final float attacksPerSecond = 0.3f;
    public static final float attackRange = 2.0f;
    public static final float aggroRange = 10.0f;
    public static final boolean willRetaliate = true;
    public static final boolean aggressiveWhenIdle = true;
    public static final float maxHealth = 100.0f;
    public static final float armorValue = 0.0f;
    public static final float movementSpeed = 0.28f;
    public int maxResources = 100;
    public int deathCloudTicks = 0;
    private Abilities abilities = ABILITIES.clone();
    private final List<ItemStack> items = new ArrayList<ItemStack>();
    public static final int WITHER_SECONDS = 6;
    public static final int WITHER_MAX_AMPLIFIER = 5;
    public static final int WITHER_MAX_AMPLIFIER_HERO = 3;

    @Override
    public void updateAbilityButtons() {
        this.abilities = ABILITIES.clone();
    }

    @Override
    public Object2ObjectArrayMap<Ability, Float> getCooldowns() {
        return this.cooldowns;
    }

    @Override
    public boolean hasAutocast(Ability ability) {
        return this.autocast == ability;
    }

    @Override
    public void setAutocast(Ability autocast) {
        this.autocast = autocast;
    }

    @Override
    public Object2ObjectArrayMap<Ability, Integer> getCharges() {
        return this.charges;
    }

    @Override
    public void setEatingTicksLeft(int amount) {
        this.eatingTicksLeft = amount;
    }

    @Override
    public int getEatingTicksLeft() {
        return this.eatingTicksLeft;
    }

    @Override
    public void setAnchor(BlockPos bp) {
        this.anchorPos = bp;
    }

    @Override
    public BlockPos getAnchor() {
        return this.anchorPos;
    }

    @Override
    public ArrayList<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    @Override
    public GarrisonGoal getGarrisonGoal() {
        return this.garrisonGoal;
    }

    @Override
    public boolean canGarrison() {
        return this.getGarrisonGoal() != null;
    }

    @Override
    public UsePortalGoal getUsePortalGoal() {
        return this.usePortalGoal;
    }

    @Override
    public boolean canUsePortal() {
        return this.getUsePortalGoal() != null;
    }

    @Override
    public Faction getFaction() {
        return Faction.PIGLINS;
    }

    @Override
    public Abilities getAbilities() {
        return this.abilities;
    }

    @Override
    public List<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public MoveToTargetBlockGoal getMoveGoal() {
        return this.moveGoal;
    }

    public SelectedTargetGoal<? extends LivingEntity> getTargetGoal() {
        return this.targetGoal;
    }

    @Override
    public ReturnResourcesGoal getReturnResourcesGoal() {
        return this.returnResourcesGoal;
    }

    @Override
    public int getMaxResources() {
        return this.maxResources;
    }

    @Override
    public LivingEntity getFollowTarget() {
        return this.followTarget;
    }

    @Override
    public boolean getHoldPosition() {
        return this.holdPosition;
    }

    @Override
    public void setHoldPosition(boolean holdPosition) {
        this.holdPosition = holdPosition;
    }

    @Override
    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(ownerDataAccessor);
    }

    @Override
    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(ownerDataAccessor, (Object)name);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ownerDataAccessor, (Object)"");
    }

    @Override
    public float getMovementSpeed() {
        return 0.28f;
    }

    @Override
    public float getUnitMaxHealth() {
        return 100.0f;
    }

    @Override
    @Nullable
    public ResourceCost getCost() {
        return ResourceCosts.WITHER_SKELETON;
    }

    @Override
    public boolean getWillRetaliate() {
        return true;
    }

    @Override
    public int getAttackCooldown() {
        return 66;
    }

    @Override
    public float getAttacksPerSecond() {
        return 0.3f;
    }

    @Override
    public float getAggroRange() {
        return 10.0f;
    }

    @Override
    public boolean getAggressiveWhenIdle() {
        return !this.m_20160_();
    }

    @Override
    public float getAttackRange() {
        return 2.0f;
    }

    @Override
    public float getUnitAttackDamage() {
        return 3.0f;
    }

    @Override
    public BlockPos getAttackMoveTarget() {
        return this.attackMoveTarget;
    }

    @Override
    public boolean canAttackBuildings() {
        return this.getAttackBuildingGoal() != null;
    }

    @Override
    public Goal getAttackGoal() {
        return this.attackGoal;
    }

    @Override
    public Goal getAttackBuildingGoal() {
        return this.attackBuildingGoal;
    }

    @Override
    public void setAttackMoveTarget(@Nullable BlockPos bp) {
        this.attackMoveTarget = bp;
    }

    @Override
    public void setFollowTarget(@Nullable LivingEntity target) {
        this.followTarget = target;
    }

    public WitherSkeletonUnit(EntityType<? extends WitherSkeleton> entityType, Level level) {
        super(entityType, level);
        this.updateAbilityButtons();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        SpawnGroupData spawnGroupData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.m_21051_(Attributes.f_22281_).m_22100_(3.0);
        return spawnGroupData;
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22279_, (double)0.28f).m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22277_, (double)Unit.getFollowRange()).m_22268_(Attributes.f_22284_, 0.0);
    }

    public void m_32164_() {
    }

    public boolean m_21527_() {
        return false;
    }

    public boolean m_21526_() {
        return false;
    }

    protected void m_7581_(ItemEntity pItemEntity) {
    }

    protected void m_8024_() {
    }

    public LivingEntity m_5448_() {
        return this.targetGoal.getTarget();
    }

    public void m_8119_() {
        this.m_21553_(true);
        super.m_8119_();
        Unit.tick(this);
        AttackerUnit.tick(this);
        if (!this.m_9236_().m_5776_() && this.deathCloudTicks > 0 && this.deathCloudTicks % 20 == 0) {
            AreaEffectCloud aec = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            aec.m_19718_((LivingEntity)this);
            aec.m_19712_(4.0f);
            aec.m_19732_(0.0f);
            aec.m_146785_(0);
            aec.m_19734_(40);
            aec.m_19738_(-aec.m_19743_() / (float)aec.m_19748_());
            aec.m_19716_(new MobEffectInstance(MobEffects.f_19615_, 40, 1));
            this.m_9236_().m_7967_((Entity)aec);
        }
        if (this.deathCloudTicks > 0) {
            --this.deathCloudTicks;
        }
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.addUnitSaveData(pCompound);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readUnitSaveData(pCompound);
    }

    @Override
    public void initialiseGoals() {
        this.usePortalGoal = new UsePortalGoal((Mob)this);
        this.moveGoal = new MoveToTargetBlockGoal((Mob)this, false, 0);
        this.targetGoal = new SelectedTargetGoal((Mob)this, true, true);
        this.garrisonGoal = new GarrisonGoal((Mob)this);
        this.attackGoal = new MeleeAttackUnitGoal((Mob)this, false);
        this.returnResourcesGoal = new ReturnResourcesGoal((Mob)this);
        this.attackBuildingGoal = new MeleeAttackBuildingGoal((Mob)this);
    }

    protected void m_8099_() {
        this.initialiseGoals();
        this.f_21345_.m_25352_(2, (Goal)this.usePortalGoal);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)this.attackGoal);
        this.f_21345_.m_25352_(2, (Goal)this.attackBuildingGoal);
        this.f_21345_.m_25352_(2, (Goal)this.returnResourcesGoal);
        this.f_21345_.m_25352_(2, (Goal)this.garrisonGoal);
        this.f_21346_.m_25352_(2, this.targetGoal);
        this.f_21345_.m_25352_(3, (Goal)this.moveGoal);
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundUnitGoal((Mob)this));
    }

    @Override
    public void setupEquipmentAndUpgradesClient() {
    }

    @Override
    public void setupEquipmentAndUpgradesServer() {
        ItemStack swordStack = new ItemStack((ItemLike)Items.f_42393_);
        AttributeModifier mod = new AttributeModifier(UUID.randomUUID().toString(), 0.0, AttributeModifier.Operation.ADDITION);
        swordStack.m_41643_(Attributes.f_22281_, mod, EquipmentSlot.MAINHAND);
        this.m_8061_(EquipmentSlot.MAINHAND, swordStack);
    }

    public static void applyStackingWither(LivingEntity le) {
        int amplifier = 0;
        MobEffectInstance witherEffect = null;
        for (MobEffectInstance effect : le.m_21220_()) {
            if (effect.m_19544_() != MobEffects.f_19615_) continue;
            witherEffect = effect;
        }
        if (witherEffect != null) {
            int maxAmp = 5;
            if (le instanceof HeroUnit) {
                HeroUnit heroUnit = (HeroUnit)le;
                maxAmp = 3;
            }
            amplifier = Math.min(maxAmp, witherEffect.m_19564_() + 1);
            le.m_21195_(MobEffects.f_19615_);
        }
        le.m_147207_(new MobEffectInstance(MobEffects.f_19615_, 120, amplifier), null);
    }

    public boolean m_7327_(@NotNull Entity pEntity) {
        if (!super.m_7327_(pEntity)) {
            return false;
        }
        if (pEntity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)pEntity;
            WitherSkeletonUnit.applyStackingWither(le);
        }
        return true;
    }

    public boolean m_5825_() {
        BuildingPlacement bpl = BuildingUtils.findBuilding(this.m_9236_().m_5776_(), this.m_20097_());
        return super.m_5825_() || bpl != null && (bpl.getBuilding() instanceof FlameSanctuary || bpl.getBuilding() instanceof BasaltSprings);
    }

    @Override
    public boolean canPickUpEquipment(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        return (item == Items.f_42477_ || item == Items.f_42478_ || item == Items.f_42479_ || item == Items.f_42476_ || item == Items.f_42481_ || item == Items.f_42482_ || item == Items.f_42483_ || item == Items.f_42480_) && this.m_6844_(WitherSkeletonUnit.m_147233_((ItemStack)itemStack)).m_41720_() != item;
    }

    @Override
    public void onPickupEquipment(ItemStack itemStack) {
        this.m_8061_(WitherSkeletonUnit.m_147233_((ItemStack)itemStack), itemStack);
    }

    static {
        ABILITIES.add(new WitherCloud(), Keybindings.keyQ);
        ownerDataAccessor = SynchedEntityData.m_135353_(WitherSkeletonUnit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    }
}

