/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.abilities;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.piglins.BruteUnit;
import com.solegendary.reignofnether.unit.units.piglins.HeadhunterUnit;
import com.solegendary.reignofnether.unit.units.piglins.HoglinUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class Bloodlust
extends Ability {
    private static final int HEALTH_COST = 12;
    private static final int HEALTH_COST_HOGLIN = 18;
    private static final int DURATION_SECONDS = 10;
    public static final float BLOODLUST_ATTACK_SPEED_MULTIPLIER = 1.6f;

    public Bloodlust() {
        super(UnitAction.BLOOD_LUST, 0, 0.0f, 0.0f, false, false);
    }

    private static int getDurationLeft(Unit unit) {
        if (unit instanceof HeadhunterUnit) {
            HeadhunterUnit headhunterUnit = (HeadhunterUnit)unit;
            return headhunterUnit.bloodlustTicks;
        }
        if (unit instanceof BruteUnit) {
            BruteUnit bruteUnit = (BruteUnit)unit;
            return bruteUnit.bloodlustTicks;
        }
        if (unit instanceof HoglinUnit) {
            HoglinUnit hoglinUnit = (HoglinUnit)unit;
            return hoglinUnit.bloodlustTicks;
        }
        return 0;
    }

    private List<FormattedCharSequence> getTooltip(Unit unit) {
        if (unit instanceof HoglinUnit) {
            return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.bloodlust", (Object[])new Object[0]), true), FormattedCharSequence.m_13714_((String)"\ue007  12", (Style)MyRenderer.iconStyle), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.bloodlust.tooltip1", (Object[])new Object[]{18}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.bloodlust.tooltip2", (Object[])new Object[]{10}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.bloodlust.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_));
        }
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.bloodlust", (Object[])new Object[0]), true), FormattedCharSequence.m_13714_((String)"\ue007  12", (Style)MyRenderer.iconStyle), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.bloodlust.tooltip1", (Object[])new Object[]{12}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.bloodlust.tooltip2", (Object[])new Object[]{10}), (Style)Style.f_131099_));
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey, Unit unit) {
        return new AbilityButton("Bloodlust", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/redstone_block.png"), hotkey, () -> Bloodlust.getDurationLeft(unit) > 0, () -> !ResearchClient.hasResearch(ProductionItems.RESEARCH_BLOODLUST), () -> !((LivingEntity)unit).m_20160_() && !((LivingEntity)unit).m_20159_(), () -> UnitClientEvents.sendUnitCommand(UnitAction.BLOOD_LUST), null, this.getTooltip(unit), (Ability)this, unit);
    }

    @Override
    public void use(Level level, Unit unitUsing, BlockPos targetBp) {
        float healthCost = 12.0f;
        if (unitUsing instanceof HoglinUnit) {
            healthCost = 18.0f;
        }
        int duration = 200;
        if (((LivingEntity)unitUsing).m_21223_() <= healthCost) {
            return;
        }
        ((LivingEntity)unitUsing).m_6469_(level.m_269111_().m_269425_(), healthCost);
        if (unitUsing instanceof HeadhunterUnit) {
            HeadhunterUnit headhunterUnit = (HeadhunterUnit)unitUsing;
            headhunterUnit.bloodlustTicks = duration;
            headhunterUnit.m_7292_(new MobEffectInstance(MobEffects.f_19596_, duration, 0));
            headhunterUnit.m_7292_(new MobEffectInstance(MobEffects.f_19605_, (int)(healthCost * 20.0f * 2.5f) + 40, 0));
        } else if (unitUsing instanceof BruteUnit) {
            BruteUnit bruteUnit = (BruteUnit)unitUsing;
            bruteUnit.bloodlustTicks = duration;
            bruteUnit.m_7292_(new MobEffectInstance(MobEffects.f_19596_, duration, 0));
            bruteUnit.m_7292_(new MobEffectInstance(MobEffects.f_19605_, (int)(healthCost * 20.0f * 2.5f) + 40, 0));
        } else if (unitUsing instanceof HoglinUnit) {
            HoglinUnit hoglinUnit = (HoglinUnit)unitUsing;
            hoglinUnit.bloodlustTicks = duration;
            hoglinUnit.m_7292_(new MobEffectInstance(MobEffects.f_19596_, duration, 0));
            hoglinUnit.m_7292_(new MobEffectInstance(MobEffects.f_19605_, (int)(healthCost * 20.0f * 2.5f) + 40, 0));
        }
    }

    @Override
    public boolean shouldResetBehaviours() {
        return false;
    }
}

